/*  WRITE.C:  Routines for writing */


#include "zip.h"

extern char chtype[];


/*  Determine whether a box is unquotable alpha. */

int tokenalpha(w)
int w;
{
  int bc, t;
  char *p;
  if (tag(w) == ATOM) w = memoff(w,ATOCHOFF);
  p = (char *) (((int *) val(w)) + 1);
  bc = blockchars(w);
  t = chtype[*p];
  if (t == LCASE)
  {
    while (bc-- > 0) { if (chtype[*p++] >= SYMCH) return(FALSE); }
    return(TRUE);
  }
  return(FALSE);
}

/*  Determine whether a box is unquotable signs. */

int tokenother(w)
int w;
{
  int bc, t;
  char *p;
  if (tag(w) == ATOM) w = memoff(w,ATOCHOFF);
  p = (char *) (((int *) val(w)) + 1);
  bc = blockchars(w);
  t = chtype[*p];
  if (t == SYMCH)
  {
    while (bc-- > 0) if (chtype[*p++] != SYMCH) return(FALSE);
    return(TRUE);
  }
  return(FALSE);
}


/* write the contents of a box.  Extra argument is for quoting quotes. */

static writebox(w,q)
int w, q;
{
  char *p;
  int bc, c;
  bc = blockchars(w);
  p = (char *) (((int *) val(w)) + 1);
  if (q < 0) while (bc-- > 0) putch(*p++);
  else while (bc-- > 0)
  {
    c = *p++;
    putch(c);
    if (chtype[c] == q) putch(c);
  }
}


/* sign extend and write an integer */

static writeint(i)
int i;
{
  char a[20], n;
  int p;
  n = FALSE;
  p = 0;
  i = signextend(i);
  if (i < 0)
  {
    n = TRUE;
    i = -i;
   }
  do { a[p++] = '0' + (i % 10); } while (i /= 10);
  if (n) a[p] = '-'; else --p;
  while (p >= 0) putch(convch(a[p--]));
}


/* Write a token, with q as a quote flag. */

tokenput(w,q)
int w, q;
{
  switch(tag(w))
  {
    case TABREF:
    case CLAUSE:
    case PROC:
      putch(convch('<'));
      writeint(val(w));
      putch(convch('>'));
      break;
    case INT:
      writeint(val(w));
      break;
    case UNDEF:
      putch(convch('_'));
      writeint(val(w));
      break;
    case BOX:
      if (q)
      {
        putch(convch(CHDOUBQ));
        writebox(w,STRQT);
        putch(convch(CHDOUBQ));
      }
      else writebox(w,-1);
      break;
    case ATOM:
      w = memoff(w,ATOCHOFF);
      if (q)
      {
        putch(convch(CHSINGQ));
        writebox(w,ATOQT);
        putch(convch(CHSINGQ));
      }
      else writebox(w,-1);
      break;
  }
}
