#include "zip.h"

#ifdef HLHMODS

#include "if.h"

extern int unifytable[];
#ifdef STATS
extern int copyStats[], matchStats[];
extern int callStats[];
#endif
extern int runinc;
int mcresult;
extern int *unifytableptr;
extern int QREG;

# define runmicrocode(op) asm (op, &unifytableptr, SP)
#else
extern char unifytable[];
#endif

extern int T0, T1, INTFLAG;

extern int *LORG, *LTOP, *GORG, *GTOP, *HORG, *HTOP, *TRORG, *TRTOP, *H;
extern int syswords[SYSWSIZE+1], modstk[LENMODSTK], *modptr;

extern int IR;
extern int BP, M1;
extern int *TR, *XC, *L, *BL, *G;
extern int *CL;

extern char *PC;
extern int R0, R1, R2;      /* microcode temporaries */
extern int *IP, *IQ;    /* microcode temporaries */
extern int PM, M0;
extern int *D;
extern int *TR1, *SP;


/* The Scratchpad (used by FUNCTOR and arithmetic instructions) */

extern int pad[];

/*
  Use indexing information to update Match register M0 to point to the
  next clause.  Does the least possible amount of work based on the
  situation at hand, even if this means duplicating a few lines of code.
  The register declaration is optional.
  Possibly the only goto's in the whole system.
  Returns TRUE for next match, FALSE for none.
*/

int nextmatch()
{
  if (tag(M0) == TERMIN) return(FALSE);
  R1 = memoff(M0,CLAKEYOFF);
  if (tag(R1) == UNDEF) return(TRUE);
  R0 = *(CL+A1OFF); /* Grab the argument */
  deref(R0);
  if (tag(R0) == UNDEF) return(TRUE);
  if (tag(R0) == TERM) R0 = termfunctor(R0); 
next:
  switch(tag(R1))
  {
    case FUNCTOR:
    case ATOM:
    case INT:
    case CLAUSE:
      if (R0 == R1) return(TRUE);
      break;
    case CONS:
    case BOX:
      if (tag(R0) == tag(R1)) return(TRUE);
      break;
    default:
      processortrap(2);
  }
    M0 = memoff(M0,CLAFOROFF);
    if (tag(M0) == TERMIN) return(FALSE);
    R1 = memoff(M0,CLAKEYOFF);
    if (tag(R1) == UNDEF) return(TRUE);
    goto next;
}


/* The ZIP Emulator */

interpret()
{
  G = GORG;
  L = LORG;
  TR = TRORG;
  modstk[0] = syswords[SWUSER];
  modptr = modstk;
  M0 = syswords[SWSTART];
  CL = L;
  *(CL + CLOFF) = NULL;
  BL = NULL;

Arrive:
  ++T1;
  if (T0) trace(T0 & TMARMESS,"arrive",M0,T0 & TMARRIVE, T0 & TMARWAIT,PC);
  if (tag(M0) != PROC) {if (unknown()) goto Arrive; else goto Fail;}
  R0 = memoff(M0,PROCLAOFF);
  if (tag(R0) == INT)
  {
    if (primhandle(val(R0)))
    {
      PC = (char *) ((int *) val(*(CL + CPOFF)));
      XC = (int *) val(*(CL+XCOFF));
      CL = (int *) val(*(CL + CLOFF));
      D = L + ACTSIZE;
      goto CopyMode;
    }
    else goto Fail;
  }
  R0 = memoff(R0,FIXFIROFF);
  if (tag(R0) == TERMIN) {if (unknown()) goto Arrive; else goto Fail;}
  M0 = R0;
  if (!nextmatch()) goto Fail;
  M1 = M0;
  XC = (int *) val(M0);
  checklocal(10+(*(XC+CLAFLAOFF) & CFSIZE));
  M0 = *(XC+CLAFOROFF);
  if (!nextmatch()) goto Setup;
    *(CL + BPOFF) = BP;
    *(CL + BLOFF) = (int) BL;
    *(CL + TROFF) = (int) TR;
    *(CL + GOFF) = (int) G;
    BP = M0;
    BL = CL;
Setup:
  PC = (char *) ((int *) val(*(XC + CLATEXOFF)) + 1);
  D = L + ACTSIZE;
  SP = pad;
  goto MatchMode;
#include "xpcopy.c"
#include "xpmatch.c"
Fail:
  if (T0) trace(T0 & TMFAMESS,"fail",BP,T0 & TMFAILS, T0 & TMFAWAIT,PC);
  G = (int *) *(BL + GOFF);
  TR1 = (int *) *(BL + TROFF);
  if (BL < L)
  {
    L = BL;
    if (tag(BP) == CLAUSE) CL = L;
    else
    {
      CL = (int *) *(L + CLOFF);
      XC = (int *) *(L + XCOFF);
      PC = (char *) ((int *) val(BP));
      untrail();
      goto CopyMode;
    }
  }
  M1 = BP;
  XC = (int *) val(BP);
  checklocal(10+(*(XC+CLAFLAOFF) & CFSIZE));
  M0 = *(XC+CLAFOROFF);
  untrail();
  if (!nextmatch()) goto LB;
  BP = M0;
  goto Setup;
LB:
  BP = *(CL + BPOFF);
  BL = (int *) *(CL + BLOFF);
  goto Setup;
}

