/*  ZIP.C:  The ZIP Machine Emulator */

#include "zip.h"

#ifdef HLHMODS
extern int unifytable[];

/* The Scratchpad (used by FUNCTOR and arithmetic instructions) */

#define LENPAD		100
#define MAXPAD		&pad[LENPAD-1]

int T0, INTFLAG;
int *GORG, *HORG, *HTOP, *TRORG, *H;
int syswords[SYSWSIZE+1], modstk[LENMODSTK], *modptr;

int PM;
int *TR1;

/* Unifier Registers */

int URa, URb, URc, *URbot;

/* Tidytrail Registers */

int *TTR1, *TTR2;

extern int pad[];

/* The order of the following is known to the microcode */
/* Must all be initialized to guarantee contiguous storage */

double dummy = 0.0;		/* Force alignment */
int *unifytableptr = unifytable;
int *padptr = pad;
int *syswordsptr = syswords;
int *GTOP = (int *) 0;
int *LTOP = (int *) 0;
int *LORG = (int *) 0;
int *TRTOP = (int *) 0;
int *intflag = &INTFLAG;
int savepc = 0;
int savexc = 0;
int saveir = 0;
int saver2 = 0;
int BP = 0;
int T1 = 0;
int M1 = 0;
int R0 = 0;
int R1 = 0;
int R2 = 0;
int *IQ = (int *) 0;
int *IP = (int *) 0;
int IR0 = 0;
int *D = (int *) 0;
int *CL = (int *) 0;
int *L = (int *) 0;
int *XC = (int *) 0;
int M0 = 0;
int *TR = (int *) 0;
int *G = (int *) 0;
int *BL = (int *) 0;
int *SP = (int *) 0;
char *PC = (char *) 0;
int QREG = 0;
int var = 0;
int pad[LENPAD] = { 0 };

#else

int T0, T1, INTFLAG;
int *LORG, *LTOP, *GORG, *GTOP, *HORG, *HTOP, *TRORG, *TRTOP, *H;
int syswords[SYSWSIZE+1], modstk[LENMODSTK], *modptr;

int BP, M1;
int *TR, *XC, *L, *BL, *G;
int *CL;

char *PC;
int R0, R1, R2;      /* microcode temporaries */
int *IP, *IQ;    /* microcode temporaries */
int PM, M0;
int *D;
int *TR1, *SP;
extern char unifytable[];

/* Unifier Registers */

int URa, URb, URc, *URbot;

/* Tidytrail Registers */

int *TTR1, *TTR2;


/* The Scratchpad (used by FUNCTOR and arithmetic instructions) */

#define LENPAD		100
#define MAXPAD		&pad[LENPAD-1]

int pad[LENPAD];
#endif


/*
  In line unification of something in a register (a) with an atom (b).
  NOTE: corrupts register IQ because of in_trail.  Callers use IP.
*/

int in_unatomic(a,b)
int a,b;
{
  deref(a);
  if (tag(a) == UNDEF)
  {
    memoff0(a) = b;
    in_trail(a);
    return(TRUE);
  }
  return(a == b);
}


/*
  Set up the argument of a metacall.
  Note that lookups in the heap (findfunct, findproc) are used here.
  M0 is set to either a PROC, or a term having an unknown procedure.
  NOTE:  corrupts R0, R1, R2, M0.
*/

metaproc()
{
  M0 = R0; 
  R1 = 0; 
  if (tag(R0) == ATOM) 
  { 
    R2 = findfunct(R0,0,FALSE); 
    if (tag(R2) != TERMIN) M0 = findproc(R2,*modptr,FALSE); 
  } 
  else if (tag(R0) == TERM) 
  { 
    R2 = termfunctor(R0); 
    M0 = findproc(R2,*modptr,FALSE); 
    R1 = termarity(R0); 
  } 
  if (tag(M0) == TERMIN) M0 = R2;
  if (tag(M0) == TERMIN) M0 = R0; 
}

/*
   Push a Trail entry, but only if necessary.
   NOTE: corrupts register IQ.  Callers use IP.
*/

in_trail(w)
int w;
{
  IQ = (int *) val(w); 
  if ( ((IQ > LORG) && (IQ < BL)) || (IQ < (int *) *(BL + GOFF)) ) 
    { *TR++ = w; if (TR > TRTOP) fatality(68);} 
}

/*
  tidy trail.  Used by cut.
  NOTE:  corrupts  IP, IQ R0.
*/

tidytrail()
{
  if (TR1 < TR) 
  { 
    TTR1 = (int *) *(BL + GOFF); 
    IP = IQ = TR1; 
    while (IP < TR) 
    { 
      R0 = *IP; 
      TTR2 = (int *) val(R0); 
      if ( (tag(R0) == CLAUSE) || ((TTR2 > LORG) && (TTR2 < BL)) || (TTR2 < TTR1) ) 
      { 
        if (IP != IQ) *IQ = R0; 
        IQ++; 
      } 
      IP++; 
    } 
    TR = IQ; 
  } 
}


/*
  Pop trail down to dest, resetting entries as we go.
  Take action on trailed clause references.
  NOTE:  Corrupts R0, R1, R2, IP, IQ.
*/

untrail()
{
  if (TR > TR1) 
  { 
    IP = TR; 
    while (IP > TR1) 
    { 
      R0 = *--IP; 
      if (tag(R0) == UNDEF) mem(val(R0)) = R0; 
      else 
      { 
        proctrap((tag(R0) != CLAUSE), 50); 
        IQ = (int *) val(R0) + CLAFLAOFF; 
        R2 = *IQ; 
        *IQ = R2 & ~CFCLAIMED; 
        if ((R2 & CFDOOMED) && !(R2 & CFREFMASK))  dealloc(R0);
      } 
    } 
    TR = IP; 
  } 
}


/*
  Claim the current clause and its lookahead by pushing on the Trail.
  NOTE:  Corrupts IP.
*/

claimclause()
{
  IP = XC + CLAFLAOFF;
  if (!(*IP & CFCLAIMED))
  {
    *IP |= CFCLAIMED;
    *TR++ = makeword(CLAUSE, (int) XC);
    if (TR > TRTOP) fatality(68);
  }
  if (tag(M0) != TERMIN)
  {
    IP = (int *) (val(M0)) + CLAFLAOFF;
    if (!(*IP & CFCLAIMED))
    {
      *IP |= CFCLAIMED; 
      *TR++ = M0;
      if (TR > TRTOP) fatality(68);
    }
  }
}

/*
  Possible failure because of (a) unknown procedure, or (b) procedure with
  no clauses.  If merely an empty database key, then Fail.  Otherwise,
  call the unknown_handler after trying to find a culprit name.
  Returns TRUE for unknown, FALSE for mere Fail.
*/

int unknown()
{
  if (tag(M0) != ATOM) 
  { 
    if (tag(M0) == PROC) R0 = memoff(M0,PROFUNOFF); else R0 = M0; 
    if (R0 == syswords[SWDATABASE] || R0 == syswords[SWSOURCE]) return(FALSE); 
    R0 = memoff(R0,FUNATOFF); 
  } 
  *(CL+A1OFF) = R0;
  M0 = syswords[SWUNKNOWN];
  return(TRUE);
} 



/* General Purpose Unifier */

int unify()
{
  deref(R0);
  deref(R1);
  if (R0 == R1) return(TRUE);
  if (tag(R0) == UNDEF)
  {
    if (tag(R1) == UNDEF)
    {
      if (val(R1) < val(R0)) { R1 = makeword(LINK,val(R1)); goto R0var;}
      else { R0 = makeword(LINK,val(R0)); goto R1var;}
    }
    else
    {
R0var:
      memoff0(R0) = R1;
      in_trail(R0);
    }
  }
  else
  {
    if (tag(R1) == UNDEF)
    {
R1var:
      memoff0(R1) = R0;
      in_trail(R1);
    }
    else
    {
      URc = 1;
      IP = URbot = G;
      while (TRUE)
      {
        deref(R0);
        deref(R1);
        if (R0 != R1) switch (unifytable[tagcode(R0,R1)])
        {
          case 0:
            processortrap(14);
          case 1:
            if (R0 != R1)
            {
              if (val(R1) < val(R0))
              {
                memoff0(R0) = makeword(LINK,val(R1));
                in_trail(R0);
              }
              else
              {
                memoff0(R1) = makeword(LINK,val(R0));
                in_trail(R1);
              }
            }
            break;
          case 2:
            memoff0(R0) = R1;
            in_trail(R0);
            break;
          case 3:
            memoff0(R1) = R0;
            in_trail(R1);
            break;
          case 4:
            if (termfunctor(R0) != termfunctor(R1)) return(FALSE);
            if (URc > 1)
            {
              *++IP = URa;
              *++IP = URb;
              *++IP = URc;
            }
            URa = adroff(val(R0),1);
            URb = adroff(val(R1),1);
            URc = termarity(R0);
            R0 = mem(URa);
            R1 = mem(URb);
            continue;
          case 5:
            if (boxcmp(val(R0),val(R1)) == FALSE) return(FALSE);
            break;
          case 6:
            /* Taken care of by explicit test before the switch */
          case 7:
          case 8:
            return(FALSE);
          case 9:
            if (URc > 1)
            {
              *++IP = URa;
              *++IP = URb;
              *++IP = URc;
            }
            URa = val(R0);
            URb = val(R1);
            URc = 2;
            R0 = mem(URa);
            R1 = mem(URb);
            continue;
          case 10:
            if (tablesize(R0) != tablesize(R1))  return(FALSE);
            if (URc > 1)
            {
              *++IP = URa;
              *++IP = URb;
              *++IP = URc;
            }
            URa = adroff(val(R0),1);
            URb = adroff(val(R1),1);
            URc = tablesize(R0);
            R0 = mem(URa);
            R1 = mem(URb);
            continue;
        }
        if (--URc == 0)
        {
          if (IP == URbot) return(TRUE);
          URc = (*IP--) - 1;
          URb = *IP--;
          URa = *IP--;
        }
        URa = adroff(URa,1);
        URb = adroff(URb,1);
        R0 = mem(URa);
        R1 = mem(URb);
      }
    }
  }
  return(TRUE);
}
