#include "stdio.h"

/* C conventions */

#define TRUE		1
#define FALSE		0


/* ZIP Machine instructions */

#define INSTMIN		1
#define IPOP		1
#define VARARG		2
#define POPARG		3
#define IVAR		4
#define FIRSTVAR	5
#define FIRRESULT	6
#define VOID		7
#define ICONTINUE	8
#define IFUNCTOR	9
#define LASTFUNCTOR	10
#define CONSTANT	11
#define ENTER		12
#define IRETURN		13
#define SAVEL		14
#define CUT		15
#define DEPART		16
#define	CALL		17
#define DISJUNCT	18
#define IFAIL		19
#define PROVAR		20
#define PRONONVAR	21
#define PROATOM		22
#define PROINT		23
#define PROSUCC		24
#define IEXIT		25
#define CALLX		26
#define IMMED		27
#define ENDOR		28
#define GLOFIRVAR	29
#define GLOVAR		30
#define LOCALCUT	31
#define VOIDN		32
#define CONSLIST	33
#define LASTCONSLIST	34
#define CONSTNIL	35
#define PROARG		36
#define PROFUNCTOR	37
#define PROEQUAL	38
#define PROAIC		39
#define FIRVARARG	40
#define EVAL		41
#define PUSHB		42
#define PUSHI		43
#define PUSHV		44
#define RESULT		45
#define ISADD		46
#define ISSUB		47
#define ISMUL		48
#define ISDIV		49
#define ISMOD		50
#define ISSHR		51
#define ISSHL		52
#define ISAND		53
#define ISOR		54
#define ISNOT		55
#define ISNEG		56
#define ISEQ		57
#define ISNE		58
#define ISLT		59
#define ISLE		60
#define ISGT		61
#define ISGE		62
#define INITVAR		63
#define INSTMAX		63



/* tags */

#define TAGMIN		0
#define INT		0
#define FLOAT		(1<<28)
#define ATOM		(2<<28)
#define BOX		(3<<28)
#define TERM		(4<<28)
#define CONS		(5<<28)
#define LINK		(6<<28)
#define UNDEF		(7<<28)
#define FUNCTOR		(8<<28)
#define BLOCK		(9<<28)
#define EMPTY		(10<<28)
#define TERMIN		(11<<28)
#define PROC		(12<<28)
#define TABLE		(13<<28)
#define TABREF		(14<<28)
#define CLAUSE		(15<<28)
#define TAGMAX		(15<<28)


/* ZIP Machine constants */

#define MATCH		0
#define ARG		1
#define COPY		2
#define ACTSIZE		8
#define ARGOFF		7
#define A1OFF		8
#define A2OFF		9
#define A3OFF		10
#define XXOFF		0
#define CPOFF		1
#define CLOFF		2
#define BPOFF		3
#define GOFF		4
#define BLOFF		5
#define TROFF		6
#define XCOFF		7

#define ATOMLEN		3
#define ATOHAOFF	0
#define ATOFUOFF	1
#define ATOCHOFF	2

#define FUNCLEN		4
#define FUNATOFF	0
#define FUNAROFF	1
#define FUNFUOFF	2
#define FUNPROFF	3

#define PROCLEN		6
#define PROFLAOFF	0
#define PRODEFOFF	1
#define PROVISOFF	2
#define PROFUNOFF	3
#define PROPROOFF	4
#define PROCLAOFF	5

#define FIXTURELEN	3
#define FIXTABOFF	0
#define FIXFIROFF	1
#define FIXLASOFF	2

#define CLAUSELEN	7
#define CLAFLAOFF	0
#define CLAKEYOFF	1
#define CLAPROOFF	2
#define CLATEXOFF	3
#define CLASIZOFF	4
#define CLABACOFF	5
#define CLAFOROFF	6

#define FRELINOFF	0
#define FRECOUOFF	1


/* Various constants */

#define SYSWSIZE	24
#define SWUNDER		0
#define SWSTART		1
#define SWROOTMOD	2
#define SWUSER		3
#define SWDOT		4
#define SWFUNDOT	5
#define SWDATABASE	6
#define SWSOURCE	7
#define SWMINUS		8
#define SWNOCULP	9
#define SWRESLIM	10
#define SWUNKNOWN	11
#define SWISPROC	12
#define SWBREAK		13
#define SWEOF		14
#define SWNIL		15
#define SWCUT		16
#define SWSEMICOL	17
#define SWBRACES	18
#define SWFUNBRACES	19
#define SWFUNCALL	20
#define SWFUNCOMMA	21
#define SWFUNSEMICOLON	22
#define SWFUNARROW	23


/* Data Structure Mappings */


#define VALMASK		0X0FFFFFFF
#define TAGMASK		0XF0000000
#define ZIPSIGN		0X08000000
#define EXTEND		0XF0000000

#define tag(x)		(x & TAGMASK)
#define val(x)		(x & VALMASK)
#define makeword(t,v)	(t | v)
#define blocksize(c)	(((c-1)>>2)+2)


/* Procedure and Clause and TM flags */

#define PFOMNI		1
#define PFSACRED	2
#define PFVISA		4
#define PFTRANS		8
#define PFSPY		16
#define PFTRACE		32
#define CFSIZE          255
