/*
    Prolog-X, featuring the ZIP Virtual Machine, written in C.
    W F Clocksin, 1984.

*/


#include "stdio.h"
#include "setjmp.h"
#include "signal.h"

/* what kind of character set? */

#undef ebcdic

/* what kind of operating system? */

#undef PNX1	/* Perq PNX 1 and 1.5 */
#undef os370    /* MVS for 3081 */
#undef BERK41   /* Orion */
#define BERK42  /* VAX or Orion */

/* C conventions */

#define TRUE		1
#define FALSE		0


/* ZIP Machine instructions */

#define INSTMIN		1
#define IPOP		1
#define VARARG		2
#define POPARG		3
#define IVAR		4
#define FIRSTVAR	5
#define FIRRESULT	6
#define VOID		7
#define ICONTINUE	8
#define IFUNCTOR	9
#define LASTFUNCTOR	10
#define CONSTANT	11
#define ENTER		12
#define IRETURN		13
#define SAVEL		14
#define CUT		15
#define DEPART		16
#define	CALL		17
#define DISJUNCT	18
#define IFAIL		19
#define PROVAR		20
#define PRONONVAR	21
#define PROATOM		22
#define PROINT		23
#define PROSUCC		24
#define IEXIT		25
#define CALLX		26
#define IMMED		27
#define ENDOR		28
#define GLOFIRVAR	29
#define GLOVAR		30
#define LOCALCUT	31
#define VOIDN		32
#define CONSLIST	33
#define LASTCONSLIST	34
#define CONSTNIL	35
#define PROARG		36
#define PROFUNCTOR	37
#define PROEQUAL	38
#define PROAIC		39
#define FIRVARARG	40
#define EVAL		41
#define PUSHB		42
#define PUSHI		43
#define PUSHV		44
#define RESULT		45
#define ISADD		46
#define ISSUB		47
#define ISMUL		48
#define ISDIV		49
#define ISMOD		50
#define ISSHR		51
#define ISSHL		52
#define ISAND		53
#define ISOR		54
#define ISNOT		55
#define ISNEG		56
#define ISEQ		57
#define ISNE		58
#define ISLT		59
#define ISLE		60
#define ISGT		61
#define ISGE		62
#define INITVAR		63
#define INSTMAX		63


/* tags */

#define TAGMIN		0
#define INT		0
#define FLOAT		(1<<28)
#define ATOM		(2<<28)
#define BOX		(3<<28)
#define TERM		(4<<28)
#define CONS		(5<<28)
#define LINK		(6<<28)
#define UNDEF		(7<<28)
#define FUNCTOR		(8<<28)
#define BLOCK		(9<<28)
#define EMPTY		(10<<28)
#define TERMIN		(11<<28)
#define PROC		(12<<28)
#define TABLE		(13<<28)
#define TABREF		(14<<28)
#define CLAUSE		(15<<28)
#define TAGMAX		(15<<28)


/* ZIP Machine constants */

#define MATCH		0
#define COPY		0200

/* The stack offsets are now FIXED.  They must not be redefined. */

#define ACTSIZE		8
#define ARGOFF		7
#define A1OFF		8
#define A2OFF		9
#define A3OFF		10
#define XXOFF		0
#define BPOFF		1
#define BLOFF		2
#define TROFF		3
#define CPOFF		4
#define CLOFF		5
#define XCOFF		6
#define GOFF		7

#define ATOMLEN		3
#define ATOHAOFF	0
#define ATOFUOFF	1
#define ATOCHOFF	2

#define FUNCLEN		4
#define FUNATOFF	0
#define FUNAROFF	1
#define FUNFUOFF	2
#define FUNPROFF	3

#define PROCLEN		6
#define PROFLAOFF	0
#define PRODEFOFF	1
#define PROVISOFF	2
#define PROFUNOFF	3
#define PROPROOFF	4
#define PROCLAOFF	5

#define FIXTURELEN	3
#define FIXTABOFF	0
#define FIXFIROFF	1
#define FIXLASOFF	2

#define CLAUSELEN	7
#define CLAFLAOFF	0
#define CLAKEYOFF	1
#define CLAPROOFF	2
#define CLATEXOFF	3
#define CLASIZOFF	4
#define CLABACOFF	5
#define CLAFOROFF	6

#define FRELINOFF	0
#define FRECOUOFF	1


/* Various constants */

#define SYSWSIZE	24
#define SWUNDER		0
#define SWSTART		1
#define SWROOTMOD	2
#define SWUSER		3
#define SWDOT		4
#define SWFUNDOT	5
#define SWDATABASE	6
#define SWSOURCE	7
#define SWMINUS		8
#define SWNOCULP	9
#define SWRESLIM	10
#define SWUNKNOWN	11
#define SWISPROC	12
#define SWBREAK		13
#define SWEOF		14
#define SWNIL		15
#define SWCUT		16
#define SWSEMICOL	17
#define SWBRACES	18
#define SWFUNBRACES	19
#define SWFUNCALL	20
#define SWFUNCOMMA	21
#define SWFUNSEMICOLON	22
#define SWFUNARROW	23


#ifdef ebcdic
extern char etoa[];
extern char atoe[];
#define convch(c)	etoa[c]		/* provided by C Library */
#define unconvch	atoe[c]		/* provided by C Library */
#else
#define convch(c) (c)
#define unconvch(c) (c)
#endif

/* Various character codes */

#define BYTEMASK	0377		/* Prolog byte bits */
#define ASCMASK		0177		/* Significant ASCII bits */

#define CHNEWLINE '\n'
#define CHPRNL		10		/* CProlog standard newline char */
#define CHPREOF		26		/* CProlog standard end of file char */
#define CHSINGQ		'\''
#define CHDOUBQ		'"'


/* Character classes for tokeniser */

#define DIGIT		0
#define LCASE		1
#define UCASE		2
#define ULINE		3
#define SYMCH		4
#define ATOQT		5
#define STRQT		6
#define EOFCH		7
#define BLANK		8
#define COMCH		9
#define SOLCH		10
#define PUNCH		11


/* Adjustable parameters */

#define GS_SIZE		50000
#define LS_SIZE		30000
#define H_SIZE		128000
#define TR_SIZE		10000
#define MEMSIZE		(GS_SIZE + LS_SIZE + H_SIZE + TR_SIZE)
#ifdef PERQ
#define PAGESIZE	(128*1024)
#endif
#define LENMODSTK	8
#define MAXMODSTK	&modstk[LENMODSTK-1]
#define LENHASH		199


/* Data Structure Mappings */


#define VALMASK		0X0FFFFFFF
#define TAGMASK		0XF0000000
#define ZIPSIGN		0X08000000
#define EXTEND		0XF0000000

#define tag(x)		(x & TAGMASK)
#define val(x)		(x & VALMASK)
#define makeword(t,v)	(t | v)
#define mem(x)		*((int *) x)

/* take advantage of 370 addressing truncating to 24 bits */
#ifdef os370
#define memoff(x,y) (*(((int *) x) + (y)))
#define memoff0(x) (*((int *) x))
#else
#define memoff(x,y)	(*(((int *) val(x)) + (y)))
#define memoff0(x) (*((int *) val(x)))
#endif

#define adroff(x,y)	(int) (((int *) x) + y)
#define tagint(x)	((x >> 28) & 0XF)
#define tagcode(x,y)	(((x >> 24) & 0XF0) | ((y >> 28) & 0XF))
#define signextend(i)	(((i) & ZIPSIGN) ? ((i) | EXTEND) : (val(i)))
#define tablesize(w)	val(memoff0(w))
#define blockchars(w)	val(memoff0(w))
#define blocksize(nc)	(((nc-1)>>2)+2)
#define termfunctor(w)	memoff0(w)
#define termarity(w)	val(memoff(termfunctor(w),FUNAROFF))
#define funcatom(w)	memoff(w,FUNATOFF)
#define atomname(w)     memoff(w,ATOCHOFF)
#define clausesize(w)	val(memoff(w,CLASIZOFF))

/* Procedure and Clause and TM flags */

#define PFOMNI		1
#define PFSACRED	2
#define PFVISA		4
#define PFTRANS		8
#define PFSPY		16
#define PFTRACE		32
#define PFRECORD	64

#define CFSIZE		0X000000FF
#define CFCLAIMED	0X00000100
#define CFDOOMED	0X00000200
#define CFRECORD	0X00000400
#define CFREFINC	0X00010000
#define CFREFMASK	0X00FF0000

#define TMSINGLE	1
#define TMSIWAIT	2
#define TMARRIVE	4
#define TMARWAIT	8
#define TMFAILS		16
#define TMFAWAIT	32
#define TMNOINDX	64
#define TMUNKNOWN	128
#define TMSIMESS	256
#define TMARMESS	512
#define TMFAMESS	1024


/* nonlocal goto's */

#define LJ_ABORT	1
#define LJ_HALT		2


/* Other convenient macro definitions */

#define macblkmov(n,a,b) while (n-- > 0)  *b++ = *a++
#ifdef HLHMODS
#define OP_DEREF 242	/* UNUSED by C */
#define deref(r)	{r = asm (OP_DEREF, r);}
#else
#define deref(r)	 {while(tag(r) == LINK) r = memoff0(r); }
#endif
#define getarg(n,v)	{ v = *(CL+(ARGOFF+n)); deref(v); }
#define proctrap(e,n)	 if (e) processortrap(n)
#define checkglobal(e)	if ((G+e) > GTOP) fatality(66)
#define checklocal(e)	if ((L+e) > LTOP) fatality(69)

/* Type Definitions */

typedef
  struct
  {
    char see;
    short buff, column, line, colmax, depmax;
    int name;
    FILE *File;
  } fileentry;
