credit(0, _) :- !.
credit(Ac, X) :-
	retract(account(Ac, PIN, B, L)),
	N is B+X,
	asserta(account(Ac, PIN, N, L)).

debit(0, _) :- !.
debit(Ac, X) :-
	account(Ac, PIN, B, L),
	N is B-X,
	N >= -L,
	retract(account(Ac, PIN, B, L)),
	asserta(account(Ac, PIN, N, L)).

balance(0, 0) :- !.
balance(Ac, B) :-
	account(Ac, _, B, _).

info(0, 0, 0) :- !.
info(Ac, B, L) :-
	account(Ac, _, B, L).

validate_user(0,999) :- !.
validate_user(Ac, PIN) :-
	account(Ac, PIN, _, _).

account_exists(Ac) :-
	validate_user(Ac, _).

bank_load(Name, Who) :-
	kill(account/4),
	consult(Name),
	concat(Name, ' @ ', Temp),
	concat(Temp, Who, Title),
	window_label(Title).

bank_save(Name) :-
	concat(Name, '.pl', File),
	open(File, write, Stream),
	set_output(Stream),
	listing(account/4),
	close(Stream),
	set_output(user).

list_accounts :-
	listing(account/4).
