/****************************************************************/
/*                      Tests                                   */
/****************************************************************/


/************************************************************************/
/*                      SERVER                                          */
/************************************************************************/
/****************
	Connected
****************/
server1 :-
	tcp_server(0, Id),
	tcp_getsockaddr(Id, Port, Mach),
	write('Machine: '), write(Mach), nl,
	write('   Port: '), write(Port), nl,
	run_server1(Id).

run_server1(Id) :-
	tcp_accept(Id, NewId, Port, Mach, block),
	write('Machine: '), write(Mach),
	write(',  Port: '), write(Port), nl,
	run_handler1(NewId, Final),
	'$maybe_continue1$'(Final, Id).

'$maybe_continue1$'(stop, Id) :-
	tcp_close(Id).
'$maybe_continue1$'(Final, Id) :-
	run_server1(Id).

run_handler1(Id, Final) :-
	tcp_recv(Id, Data),
	write('got>'), write(Data), write('<'), nl,
	handler1(Data, Id, Final).

handler1(Data, Id, stop)  :-
	Data == stop, !,
	write('DONE'(Data)), nl,
	tcp_close(Id).
handler1(Data, Id, end)  :-
	Data == end, !,
	write('DONE'(Data)), nl,
	tcp_close(Id).
handler1(Data, Id, Final) :-
	run_handler1(Id, Final).

/*********************
	Connectionless
*********************/
server2 :-
	tcp_connectionless(0, Id),
	tcp_getsockaddr(Id, Port, Mach),
	write('Machine: '), write(Mach), nl,
	write('   Port: '), write(Port), nl,
	run_server2(Id).

run_server2(Id) :-
	tcp_recvfrom(Id, Data, Port, Mach),
	write('Machine: '), write(Mach),
	write(',  Port: '), write(Port),
	write(',    got>'), write(Data), write('< '), nl,
	'$maybe_continue2$'(Data, Id).

'$maybe_continue2$'(Data, Id) :-
	Data == stop, !,
	tcp_close(Id).
'$maybe_continue2$'(_, Id) :-
	run_server2(Id).

/****************
	Broadcast
****************/
server3(P) :-
	tcp_connectionless(P, Id),
	tcp_getsockaddr(Id, Port, Mach),
	write('listening for messages on port number '), write(Port), nl,
	run_server3(Id).

run_server3(Id) :-
	tcp_recvfrom(Id, Data, Port, Mac),
	process3(Data, Id, Mac, Port).

process3(stop, Id, Mac, Port) :- !,
	tcp_close(Id).
process3(end, Id, Mac, Port) :- !, run_server3(Id).
process3(Data, Id, Mac, Port) :-
	tcp_gethost(Name, Mac),
	write(Name:Port), write(' : '), write(Data), nl,
	read(Data),
	tcp_connectionless(0, NewId),
	tcp_sendto(NewId, Data, Port, Mac),
	tcp_close(NewId),
	run_server3(Id).

/************************************************************************/
/*                      CLIENT                                          */
/************************************************************************/
/****************
	Connected
****************/
client1(Mach, Port) :-
	write('Client text: '),
	read(Data),
	tcp_client(Port, Mach, Id),
	mysend1(Id, 1),
	mysend1(Id, 2),
	mysend1(Id, [3,4]),
	mysend1(Id, V),
	mysend1(Id, pp(a)),
	mysend1(Id, jj(Id, XX, V, XX)),
	mysend1(Id, stop),
	mysend1(Id, Data),
	tcp_close(Id).

mysend1(Id, Data) :-
	write('sending>'), write(Data), write('<'), nl,
	tcp_send(Id, Data).

/*********************
	Connectionless
*********************/
client2(Mach, Port) :-
	write('Client: '),
	read(Data),
	tcp_connectionless(0, Id),
	mysend2(Id, Mach, Port, 1),
	mysend2(Id, Mach, Port, 2),
	mysend2(Id, Mach, Port, [3,4]),
	mysend2(Id, Mach, Port, TT),
	mysend2(Id, Mach, Port, pp(a, M, N, A,M,N,F)),
	mysend2(Id, Mach, Port, jj(Id, XX, V)),
	mysend2(Id, Mach, Port, Data),
	mysend2(Id, Mach, Port, stop),
	tcp_close(Id).

mysend2(Id, Mach, Port, Data) :-
	write(mysend2(Id, Data, Port, Mach)), nl,
	write('sending>'), write(Data), write('<'), nl,
	tcp_sendto(Id, normal, Mach, Port, Data).

/****************
	Broadcast
****************/
client3(Port) :-
	tcp_broadcast(0, Id),
	fork(get_replies(Id)),
	run_client(Id, Port).

run_client(Id, P) :-
	write('enter term, "end" ends this channel, "stop" stops server> '), flush,
	read(D),
	send3(Id, P, D).

send3(Id, P, stop) :- !,
	tcp_sendbr(Id, stop, P),
	tcp_close(Id).
send3(Id, P, end) :- !,
	tcp_sendbr(Id, end, P),
	tcp_close(Id).
send3(Id, P, Data) :-
	tcp_sendbr(Id, Data, P),
	run_client(Id, P).

get_replies(Id) :-
	tcp_recvfrom(Id, Msg, Port, Mach), !,
	tcp_gethost(Name, Mach),
	write(Name:Port), write(' : '), write(Msg), nl,
	get_replies(Id).
get_replies(Id).

?- ensure_loaded(tcp).
