/*****************************************************************************
LOGIC & OBJECTS ------------- IC PROLOG ][ version

written by F.G.McCabe (fgm@doc.ic.ac.uk)
modified for IC PROLOG ][ by Z.Bobolakis (zb@doc.ic.ac.uk)
last modified: 25 Jan 1993

Logic Programming Section
Dept. of Computing
Imperial College
London
******************************************************************************/

% L&O File 


% CAUTION: Do not name this file 'dynamic.pl', ICP-][ has an operator
% called so and doesn't like it!!!


/* a suite of primitives to implement mutable class templates */
%
% assert_object will either assert a class rule, an individual axiom
% or a body
%


assert_object(O) :-
  assert_object(O,_).


assert_object((LHS<=RHS), _):-!,
  functor(LHS,Lb,LbA),
  dynamic_label(LHS,Lb,LbA,_,LbI,LbU),
  tr_mode(Tr),
  tr_rule(LHS,RHS, true, Clause, LbI,Tr,0),
  assert(Clause),
  tr_rule(LHS,RHS, true, UClause, LbU,Tr,0),
  assert(UClause),!.
assert_object((LHS<<RHS), _):-!,
  functor(LHS,Lb,LbA),
  dynamic_label(LHS,Lb,LbA,_,LbI,_),
  tr_mode(Tr),
  tr_rule(LHS,RHS, true, Clause, LbI,Tr,0),
  assert(Clause),!.
assert_object(Label:Cl, _):-!,
  assert_object(Cl, Label).
assert_object((Head:-Body), Label):-!,
  ass_axiom(Head,Body, Label).
assert_object({Clauses}, Label):-!,
  ass_axioms(Clauses, Label),
  assert_object((Label<<system),_).
assert_object(Head, Label):-
  ass_axiom(Head,true, Label).

ass_axioms('. '((Head:-Body),Cls),Label):-!,
  ass_axiom(Head, Body, Label),
  ass_axioms(Cls, Label).
ass_axioms('. '(Head,Cls),Label):-!,
  ass_axiom(Head, true, Label),
  ass_axioms(Cls, Label).
ass_axioms(((Head:-Body)..Cls),Label):-!,
  ass_axiom(Head, Body, Label),
  ass_axioms(Cls, Label).
ass_axioms((Head..Cls),Label):-!,
  ass_axiom(Head, true, Label),
  ass_axioms(Cls, Label).
ass_axioms((Head:-Body),Label):-!,
  ass_axiom(Head,Body, Label).
ass_axioms(Head,Label):-
  ass_axiom(Head, true, Label).

ass_axiom(H,B,Label):-
  functor(Label,Lb,LbA),
  dynamic_label(Label,Lb,LbA,LbS,_,_),
  functor(H,Pr,Pa),
  dynamic_pred(Pr,Pa,LbS,LI), 
  assert(LI(H,Label,B)).

initialise_ivars(Label,LbS):-  % initialise any instance variables
  LbS('#init#',Label,Label),
  fail.
initialise_ivars(_,_).

%
% retract dynamically asserted objects
%

retract_object(O) :-
  retract_object(O,_).

retract_object((LHS<=RHS), _):-!,
  functor(LHS,Lb,LbA),
  dynamic_label(LHS,Lb,LbA,_,LbI,LbU),
  tr_mode(Tr),
  tr_rule(LHS,RHS, true, UClause, LbU,Tr,0),
  retract(UClause),!,
  tr_rule(LHS,RHS, true, Clause, LbI,Tr,0),
  retract(Clause).
retract_object((LHS<<RHS), _):-!,
  functor(LHS,Lb,LbA),
  dynamic_label(LHS,Lb,LbA,_,LbI,_),
  tr_mode(Tr),
  tr_rule(LHS,RHS, true, Clause, LbI,Tr,0),
  retract(Clause).
retract_object(Label:Cl, _):-!,
  retract_object(Cl, Label).
retract_object((Head:-Body), Label):-!,
  retract_axiom(Head,Body, Label).
retract_object(Head, Label):-
  retract_axiom(Head,true, Label).

retract_axiom(H,B,Label):-
  functor(Label,Lb,LbA),
  dynamic_label(Label,Lb,LbA,LbS,_,_),
  functor(H,Pr,Pa),
  dynamic_pred(Pr,Pa,LbS,LI),
  retract(LI(H,Label,B)).

%
% dynamic_label sets up the skeleton for a dynamic label
%
dynamic_label(LbL,Lb,LbA,LbS,LbI,LbU):-
  ?::?(LbL,'?label?'(LbS),LbL),!,
  ('?dynamic?'(LbS,LbA,LbI,LbU)-> true;
     warning([sorry,:,you,may,not,modify,static,label,Lb/LbA])).
dynamic_label(_,Lb,LbA,LbS,LbI,LbU):-
  label_symbol(Lb,LbA,LbS),
  conc([LbS, '&inherit'], LbI),
  conc([LbS,'&super'],LbU),
  access_rule(LbS,Lb,LbA,Access),
  assert(Access),
  label_rule(LbS,Lb,LbA,LbRule,_,true),
  assert(LbRule),
  triple(LbS,Atom,Label,Self,Head),
  triple(LbI,Atom,Label,Self,Body),
  assert((Head:-Body)),
  assert('?dynamic?'(LbS,LbA,LbI,LbU)).

%
% execute a local procedure in a dynamically asserted class
%
execute_local(LC,Atom,Label,Self,LbS):-
  '#e#'(Atom,Label,Self,local_listing(user,Label,Pr,PA)),
  LC(Atom,Label,Bo),
  execute_dynamic_body(Bo,Label,Self,LbS),
  '#s#'(Atom,Label,Self,local_listing(user,Label,Pr,PA)).
execute_local(_,Atom,Label,Self,LbS):-
  '?dynamic?'(LbS,_,LbI,LbU),
  triple(LbU,Atom,Label,Self,Head),
  clause(Head,Body),
  triple(_,Atom,Mabel,Self,Body),
  '#i#'(Label,Mabel,Atom,rule_listing(LbI,user),Self),
  Body.
  
%
% execute a dynamically asserted body
%
execute_dynamic_body(true,_,_,_):-!.
execute_dynamic_body((A,B),L,S,LbS):-!,
  execute_dynamic_body(A,L,S,LbS),
  execute_dynamic_body(B,L,S,LbS).
execute_dynamic_body((A;B),L,S,LbS):-!,
  execute_dynamic_body(A,L,S,LbS);
  execute_dynamic_body(B,L,S,LbS).
execute_dynamic_body(not(A),L,S,LbS):-!,
  \+execute_dynamic_body(A,L,S,LbS).
execute_dynamic_body(\+(A),L,S,LbS):-!,
  \+execute_dynamic_body(A,L,S,LbS).
execute_dynamic_body(self:A,_,S,_):-!,
  functor(S,SS,_),
  execute_dynamic_body(A,S,S,SS).
execute_dynamic_body(M:A,_,_,_):-!,
  functor(M,MbF,MA),
  concat(MA,MbF,T1),
  concat(T1,':',MbS),
  execute_dynamic_body(A,M,M,MbS).
execute_dynamic_body(A,_,_,_):-
  functor(A,QP,QA),
  primitive_pred(QP,QA),!,
  A.
execute_dynamic_body(A,L,S,LbS):-
  LbS(A,L,S).
% Q-Prolog version:
% triple(LbS,A,L,S,X), call(X).



%
% dynamic_pred is called to see if a locally defined
% predicate is being defined for a mutable class template
%
dynamic_pred(QP,QA,LbS,I):-       % already defined?
  '?local_pred?'(QP,QA,LbS,I),!.
dynamic_pred(QP,QA,LbS,LP):-
  '?local_pred?'(_,_,LbS,_),!,    % ANY local definitions yet?
  conc([LbS,'&',QA,QP],LP),
  assert('?local_pred?'(QP,QA,LbS,LP)).
dynamic_pred(QP,QA,LbS,LP):-      % the first local def for this label
  triple(LbS,Atom,Label,Self,Head),
  asserta((Head:- functor(Atom,Pr,PA),
                  '?local_pred?'(Pr,PA,LbS,LC),
                  LC(_,_,_),!,    % make sure that there is at least one
                  execute_local(LC,Atom,Label,Self,LbS))),
  conc([LbS,'&',QA,QP],LP),
  assert('?local_pred?'(QP,QA,LbS,LP)).

clause_object(LbL,Head,Body):-
  functor(LbL,_,LbA),
  ?::?(LbL,'?label?'(LbS),LbL),
  '?dynamic?'(LbS,LbA,_,_),
  functor(Head,Pr,PA),
  '?local_pred?'(Pr,PA,LbS,LC),!,
  LC(Head,LbL,Body).

local_listing(File,LbL,Local,Arity):-
  functor(Head,Local,Arity),!,
  toground(LbL,Lb,LV),
  findall((Head:-Body),clause_object(Lb,Head,Body),Lst),
  toground(Lst,List,BV),
  append(LV,BV,V),
  writeqseq(File,[Lb,:],V),writenl(File,'{'),
  disp_clauses(List,File,V),
  writenl(File,'}.'),!.

object_listing(Labs):-
  object_listing(Labs,user).
object_listing([],_):-!.
object_listing([Lab|Labs],F):-!,
  object_listing(Lab,F),
  object_listing(Labs,F).
object_listing(Lab/Arity,F):-
  label_symbol(Lab,Arity,LS),
  '?dynamic?'(LS,Arity,LbI,_),
  body_listing(LS,Lab,Arity,F),
  rule_listing(LbI,F).

body_listing(LS,Lab,Arity,File):-
  functor(LbL,Lab,Arity),
  findall(Head,('?local_pred?'(Pr,PA,LS,_),functor(Head,Pr,PA)),HL),
  toground(LbL,Lb,LV),
  findall((Head:-Body),(Head on HL,clause_object(Lb,Head,Body)),Lst),
  toground(Lst,List,BV),
  append(LV,BV,V),
  writeqseq(File,[Lb,:],V),writenl(File,'{'),
  disp_clauses(List,File,V),
  writenl(File,'}.'),!.

rule_listing(LbI,F):-
  clause(LbI(Atom,Label,Self),_(Atom,Mabel,Self)),
  writeqnl(F,(Label<<Mabel)),fail.
rule_listing(_,_).

