/*****************************************************************************
LOGIC & OBJECTS ------------- IC PROLOG ][ version

written by F.G.McCabe (fgm@doc.ic.ac.uk)
modified for IC PROLOG ][ by Z.Bobolakis (zb@doc.ic.ac.uk)
last modified: 25 Jan 1993

Logic Programming Section
Dept. of Computing
Imperial College
London
******************************************************************************/

% L&O File

% These clauses reduce an L&O call to a prolog call.

% interface to L&O programs from Prolog ...
Label:C :-
   ?:?(C, Label, Label).

% Broadcasting ...
% and-casting
[] &: _.
[O|L] &: M :- ?:?(M,O,O), L &: M.

% or-casting
\:([O|_],M) :- ?:?(M,O,O).
\:([_|L],M) :- \:(L,M).

% filter broadcast ... return those objects which satisfy a condition
&^([],_,[]):-!.
&^([O|L],M,[O|L1]):- ?:?(M,O,O),!,&^(L,M,L1).
&^([_|L],M,L1):- &^(L,M,L1).

map_cast([],_,[]):-!.
map_cast([O:L],M,[R|LO]):-
    ?:?(M(R),O,O),!,
    map_cast(L,M,LO).

acc_cast([],_,Zero,_,Zero):-!.
acc_cast([O|L],M,Zero,Acc,Result):-
  ?:?(M(X),O,O),
  Zero:Acc(X,NZ),
  acc_cast(L,M,NZ,Acc,Result).







/* Standard program invoked with a variable label etc */
?:?(Atom, Label, _):-
  ?::?(Label,Atom,Label).            % Invoke label
?:?(Atom, system, _):-!,
  '0system:'(Atom, system, system).  % check for a system function ...
?:?('?error?'(Code,Expr),_,Sf):-nonvar(Sf),!,
  '?default_error?'(Code,Expr,Sf).           % default error handler
/*
?:?(Atom,Label,Label):-
  nonvar(Label),                     % a variable label may fail at this point
  ?:?('?error?'('Unknown label',Atom),label,Label).
*/



/*
valid_expr:-
  nl, write(user_output,'Enter expression:'),
  gread(user_input,Ev,V), nl,
  Ev\=end_of_file,
  tohollow(Ev, E, V, X),
  tr_mode(Tr),
  label_arg_form(system, system, true, def('0system:',[],[],[],Tr),Defnd),
  tr_term(E, R, G, Defnd),
  'time%f'(Start),
  evaluate_exp(G,R),
  'time%f'(End),
  pname(R,T),
  ET is (End-Start)/1000,
  pname(s(ET),ETS),
  nl,writeq(user_output,(Ev =? R)),nl.

*/


evaluate_exp(G,_):-call(G),!.
evaluate_exp(_,'?no_value?').





% A variation which is used during inheritance - which keeps self
?#?(Atom, Label, Self):-
  ?::?(Label,Atom,Self).             % Keep the existing self here
?#?(Atom, system, _):-!,
  '0system:'(Atom, system, system).  % check for a system function ...
?#?('?error?'(Code,Expr),_,Sf):-nonvar(Sf),!,
  '?default_error?'(Code,Expr,Sf).   % default error handler
/*
?#?(Atom,Label,Label):-
  nonvar(Label),                     % a variable label may fail at this point
  ?#?('?error?'('Unknown label',Atom),Label,Label).
*/

% variation on the above, used to apply a function to arguments
'?apply?'(P, Args, Label, Self):-
  Atom =.. [P|Args],
  ?:?(Atom, Label, Self).

% Run-time binding of a function symbol its predicate symbol
'?*?'(Symbol, F):-
  conc([Symbol,'*'],F).

% The system interface, calling Prolog from L&O
'0system:'(assert(Clause), _, Self):-!,
  assert_object(Clause, Self).
'0system:'(retract(Clause), _, Self):-!,
  retract_object(Clause, Self).
'0system:'(clause(Head,Body), _, Self):-!,
  clause_object(Self,Head,Body).
'0system:'(listing(Labs), _, _):-!,
  object_listing(Labs).
'0system:'(listing, _, Self):-!,
  functor(Self,SL,SA),
  object_listing(SL/SA).
'0system:'(Var:=Exp, _, Self):-!,
  '?:?'('?error?'('Illegal assignment',Var:=Exp),Self,Self).
'0system:'(Atom, _, _):-
  functor(Atom,F,A),
  '$ pred'(F,A,_,_),
  Atom.


/* standard query predicates */
=?(Ex):-
  !,
  =?(Ex,NE),
  writenl(NE).
=?(E,NE):-
  tr_mode(Tr),
  label_arg_form(system, system, true, def('0system:',[],[],[],Tr),Defnd),
  tr_term(E, NE, G, Defnd),
  evaluate_exp(G,NE),!.

%
% support for the assignment primitive
%
retrieve(Label,Variable,Value):-
  '?::?'(Label,'?label?'(LbL),Label),
  (get_prop(LbL,Variable,Val),!,Val=Value;   % cut out the other choices now
    '?::?'(Label,'#init#',Label),fail;
    get_prop(LbL,Variable,Val),!,Val=Value;  % try again,...
    '?:?'('?error?'('No value',Variable),Label,Label)).


assign(Label,Variable,Value):-
  '?::?'(Label,'?label?'(LbL),Label),!,
  set_prop(LbL,Variable,Value).

initialise(Label,Variable,Value):-
  '?::?'(Label,'?label?'(LbL),Label),!,
  (get_prop(LbL,Variable,_)->true;
  set_prop(LbL,Variable,Value)).



%
% default error handler
%
'?default_error?'(Code,Expr,Sf):-
  warning([Code,occurred,in,Sf:Expr]).

