/* Copyright (C) 1992 Imperial College */
/* pjs 26.6.90 speeded up assert */

/* Public List for Compilation :
[	consult/1,
	reconsult/1,
	assert/1,
	asserta/1,
	assertz/1,
	assertx/2,
	'$ assertx_hollow'/2,
	'$ assertx_ground'/6,
	clause/2,
	retract/1,
	retract/4,
	retractx/3,
	retractall/1,

	'$ consult'/2,
	'$ retractx'/3,
	'$ retract'/1,
	'$ retractall'/1,

	'$ dcodegen'/4 ]

	Exe	: foo(X,Y,Z) :- $c$foo(X,Y,Z,B),B.
	Rel	: $c$(foo(X,Y,Z),B) :- $c$foo(X,Y,Z,B).
	Dbn	: $c$foo(..x..,..y..,..z..,...body...).

*/

% *********************************************************************

assert(X) :-
	'$ primcatch'('$ assertx_hollow'(X,0),assert(X)).

asserta(X) :-
	'$ primcatch'('$ assertx_hollow'(X,1),asserta(X)).

assertz(X) :-
	'$ primcatch'('$ assertx_hollow'(X,0),assertz(X)).

assertx(X,Y) :-
	'$ primcatch'('$ assertx_hollow'(X,Y),assertx(X,Y)).

retractx(X,Y,Z) :-
	'$ primcatch'('$ retractx'(X,Y,Z),retractx(X,Y,Z)).

retractall(X) :-
	'$ primcatch'('$ retractall'(X), retractall(X)).

retract(X) :-
	catch('$ retract'(X),retract(X)).

consult(X) :-
	'$ primcatch'('$ consult'(X, consult), consult(X)).

reconsult(X) :-
	'$ primcatch'('$ consult'(X, reconsult), reconsult(X)).

% ********************************************************************

clause(Head(),Body) :- !,
	'$c$'(Head,Body).
clause(Head,Body) :-
	'$c$'(Head,Body).

'$ consult'(user, ConsultType) :- !,
	consult_it(pl, user, ConsultType).
'$ consult'(File, ConsultType) :-
	'$ srcfile'(File,Name,Type), !,
	writeseqnl(user_error, ['{consulting', Name, '...}']),
	open(Name,read,Stream),
	current_input(In),
	set_input(Stream),
	consult_it(Type, Name, ConsultType),
	close(Stream),
	set_input(In),
	'$ LOAD'.
'$ consult'(_, _) :-
	throw(203).
	/* error: non-atom filename */

consult_it(Type, Name, ConsultType) :-
	'$read_consulted_prolog_file$'(Type, Name, Progs), !,
	'$assert_consulted_relations$'(Progs, ConsultType).

'$read_consulted_prolog_file$'(Type, Name, Progs) :-
	'defined%f'(user_consult/3, _),
	user_consult(Type, Name, Progs), !.
'$read_consulted_prolog_file$'(pl, _, Progs) :-
	read_prolog_file(Progs), !.
'$read_consulted_prolog_file$'(_, _, _) :-
	throw(303).

'$assert_consulted_relations$'([], _).
'$assert_consulted_relations$'([pr(Pred/Arity, Cl)|Progs],Consult) :-
	'$maybe_delete_old$'(Consult, Pred, Arity),
	'$ primcatch'('$ valid_pred'(Pred,Arity), Pred/Arity),
	'$assert_consulted_relation$'(Cl, Pred, Arity),
	'$assert_consulted_relations$'(Progs, Consult).

'$maybe_delete_old$'(reconsult, Pred, Arity) :-
	defined(Pred/Arity), !,
	concat('$c$',Pred,DbPred),
	DbArity is Arity + 1,
	'delete%f'(DbPred,DbArity).
'$maybe_delete_old$'(_, _, _).

'$ valid_pred'(Pred,Arity) :-
	valid_pred(Pred,Arity,_).

'$assert_consulted_relation$'([],_,_).
'$assert_consulted_relation$'([Vars-Clause|Rest],Pred,Arity) :-
	split_clause(Clause,Head,Body),
	'$ assertx_ground'(Head,Body,Vars,Pred,Arity,0),
	'$assert_consulted_relation$'(Rest,Pred,Arity).

'$ assertx_hollow'(Clause,Index) :-
	split_clause(Clause,Head,Body),
	valid_head(Head,Name,Arity),
	toground((Head:-Body),Ground,_,Vars),
	Ground = (Ghead :- Gbody),
	valid_pred(Name,Arity,_),
	'$ assertx_ground'(Ghead,Gbody,Vars,Name,Arity,Index).

'$ assertx_ground'(Head,Body,Vars,Name,Arity,Index) :-
	concat('$c$',Name,DbName),
	gen_clause(Head,Body,DbName,DbClause),
	'$ assert_compiler'(DbClause,Vars,DbCode,[],0,_),
	assert_clauses(Name,Arity,DbName,DbCode,Index).

valid_head(Head,Name,Arity) :-
	functor(Head,Name,Arity),
	'atom%f'(Name), !.
valid_head(_,_,_) :-
	throw(216).
	/* error: invalid clause-pattern */

valid_pred(Name,Arity,defined) :-
	'$ pred'(Name, Arity, System, Type), !,
	/* Name/Arity is defined and has type Type */
	validpred(System,Type).
valid_pred(_,_,undefined).
	/* no errors:(assert/retract)ing a clause for an undefined predicate */

validpred(user,(dynamic)) :- !.
validpred(system,_) :- !,
	throw(215).	/* assert/retract a system predicate */
validpred(user,static) :-
	throw(214).	/* assert/retract a static predicate */

assert_clauses(Name,Arity,DbName,DbCode,Index) :-
	current_output(Out),
	N is Arity + 1,
	assert_them(Name,Arity,DbName,DbCode,Index,N),
	set_output(Out).

assert_them(Name,Arity,DbName,DbCode,Index,N) :-
	defined(Name/Arity), !,
	'$ dcodegen'(DbName,N,DbCode,Index).	/* Dbn : $c$foo(..x..,..y..,..z..,...body...) */
assert_them(Name,Arity,DbName,DbCode,_,N) :-
	'$ dynamic'(Name, Arity, DbName, N),
	'$ dcodegen'(DbName,N,DbCode,1).	/* Dbn : $c$foo(..x..,..y..,..z..,...body...) */

dynamic((First,Rest)) :- !,
  dynamic(First),
  dynamic(Rest).
dynamic([]) :- !.
dynamic([First|Rest]) :- !,
  '$dynamic$'(First),
  dynamic(Rest).
dynamic(File) :-
  '$dynamic$'(File).

'$dynamic$'(Pred) :-
	'curr_input%f'(_, Index),
	get_prop('$ dynamic', Index, L), !,	/* if compiling, just mark it */
	set_prop('$ dynamic', Index, [Pred|L]).
'$dynamic$'(Name/Arity) :-
	abolish(Name/Arity),
	concat('$c$', Name, DbName),
	N is Arity + 1,
	current_output(Out),
	'$ dynamic'(Name, Arity, DbName, N),
	set_output(Out).

'$ dynamic'(Name, Arity, DbName, N) :-
	gen_rel(Arity,Name,N,DbName,RelCode),
	gen_exe(DbName,Arity,N,ExeCode),
	'$ dcodegen'(Name,Arity,ExeCode,1),	/* Exe : foo(X,Y,Z) :- $c$foo(X,Y,Z,B),B      */
	'$ dcodegen'('$c$',2,RelCode,1).	/* Rel : $c$(foo(X,Y,Z),B) :- $c$foo(X,Y,Z,B) */

gen_clause(H,B,Name,Code) :- !,
	H =.. [_|Args1],
	append(Args1,[B],Args2),
	Code =.. [Name|Args2].

gen_exe(DbName,Arity,N,
	[gc(1,Arity),allocate(),put_y_var(0,N),call(DbName/N,1,1),
	put_slash(1),put_unsafe_y(0,2),deallocate(),execute('?call?'/2)]).

gen_rel(0,Name,_,DbName,
	[get_const(1,Name),get_x_var(2,1),execute(DbName/1)]) :- !.
gen_rel(Arity,Name,N1,DbName,Code) :-
	N2 is N1 ++ 1,
	Code = [gc(N2,N1),get_x_var(2,N1),get_tpl(1,N1),unify_const(Name)|Rest],
	gen_n(Arity,[execute(DbName/N1)],Rest).

gen_n(0,Code,Code) :- !.
gen_n(M,Tail,Code) :-
	N is M -- 1,
	gen_n(N,[unify_x_var(M)|Tail],Code).

split_clause((H:-B),H,B) :- !.
split_clause(H,H,true).

'$ dcodegen'(Name,Arity,Code,Index) :-
	'timeslice%f'(0),
	'cg_init%f'(2 /* DYNAMIC */),
	'cg%f'([dynamic(Arity,'?','?','?')|Code]),
	'cg_fixup%f'([Name/Arity],Size),
	'o_mem%f'(_,2,Out,Size),
	'set_out%f'(1,Out),
	'cg_out%f'(),
	'set_up_seg%f'(Out),
	'set_out%f'(0, 1),	/* must reset to some valid output here */
	'link%f'(Index),	/* change to link%f with one arg */
	fail.
'$ dcodegen'(_,_,_,_) :-
	'timeslice%f'(1).

'$ retractx'(Name,Arity,Index) :-
	atom(Name),
	integer(Arity),
	integer(Index), !,
	valid_pred(Name,Arity,defined),
	concat('$c$',Name,DbName),	/* construct '$c$foo' */
	N is Arity ++ 1,		/* arity of '$c$foon' */
	'retract%f'(DbName,N,Index).	/* retract the clause */
'$ retractx'(_,_,_) :-
	throw(210).
	/* error: invalid argument */

'$ retractall'(Clause) :-
	split_clause(Clause,Head,Body),
	valid_head(Head,Name,Arity),
	valid_pred(Name,Arity,defined),
	'$ retract'(Head,Body,Name,Arity),
	fail.
'$ retractall'(_).

'$ retract'(Clause) :-
	split_clause(Clause,Head,Body),
	valid_head(Head,Name,Arity),
	valid_pred(Name,Arity,defined),
	'$ retract'(Head,Body,Name,Arity).

'$ retract'(Head,Body,Name,Arity) :-
	functor(Head2,Name,Arity),	/* construct most general term for foo/n */
	concat('$c$',Name,DbName),	/* construct '$c$foo' */
	N is Arity ++ 1,		/* arity of '$c$foo' */
	Index = [0],			/* clear counter */
	'timeslice%f'(0),
	clause(Head2,Body2),		/* found a clause for foo/n ? */
	'inc%f'(Index),			/* increment counter */
	Head2 = Head,			/* is it the one we want to retract ? */
	Body2 = Body,
	Index = [Int],
	'retract%f'(DbName,N,Int),	/* retract the clause */
	('timeslice%f'(1) ; 'timeslice%f'(0), fail),
	'dec%f'(Index).			/* replaces erroneous 'clear%f'(Index) */
'$ retract'(_,_,_,_) :-
	'timeslice%f'(1),
	fail.

/*
 * 'find_clause'(Name,ArityName2,Arity2,Index) : find index of first dynamic
 * Name/Arity clause whose segment has Name2/Arity2 as external.
 */
'$ unlink'(Name,Arity,DbName,N) :-
	'find_clause%f'('$c$',2,DbName,N,Index), /* find index of'$c$' clause for foo/n */
	'retract%f'('$c$',2,Index),	/* retract that clause */
	'retract%f'(Name,Arity,1).	/* retract the clause for foo/n */
