/* Copyright (C) 1992 Imperial College */
/* This file contains the control primitives */

/* The definition of the following control primitives are built
   into the meta-call, so they will never be called directly.

        not, \+         negation
        ,               conjuction
        ;               disjunction
        ->              conditional
        !               backtracking
        fail, false     failure
        true, otherwise true
*/

true.
otherwise.

fail :- fail.
false :- fail.

\+(Goal) :-
    not(Goal).

not(Goal) :-
    Goal, !,
    fail.
not(_).

succeed(Call) :-
    Call, !.
succeed(_).


repeat.
repeat :-
    repeat.


/* meta-call */
call(Goal) :-
    'back%f'(Bk),
    '?meta?'(Goal,Bk).

'?call?'(Bk,Goal) :-
    '?meta?'(Goal,Bk).

/* Goals such variables, integers and [] are invalid */
'?meta?'(Goal, Bk) :-
    'tag%f'(Goal, N),
    '?validGoal?'(N, Goal), !,
    '$meta$'(Goal, Bk).
'?meta?'(Goal, _) :-
    system_error(Goal, 217).

'?validGoal?'(3, _).
'?validGoal?'(5, _).
'?validGoal?'(6, Goal) :-
    'funct%f'(Goal, Pred),
    'atom%f'(Pred).

'$meta$'(!, Bk) :- !,
    'deepcut%f'(Bk).

'$meta$'(fail, _) :- !,
    fail.

'$meta$'(false, _) :- !,
    fail.

'$meta$'(true, _) :- !.

'$meta$'(otherwise, _) :- !.

'$meta$'((This, That), Bk) :- !,
    '?meta?'(This, Bk),
    '?meta?'(That, Bk).

'$meta$'((If->Then;_), Bk) :-
    '?meta?'(If, Bk), !,
    '?meta?'(Then, Bk).
'$meta$'((_->_;Else), Bk) :- !,
    '?meta?'(Else, Bk).

'$meta$'((If->Then), Bk) :-
    '?meta?'(If, Bk), !,
    '?meta?'(Then, Bk).
'$meta$'((_->_), _) :- !,
    fail.

'$meta$'((Either;_), Bk) :-
    '?meta?'(Either, Bk).
'$meta$'((_;Or), Bk) :- !,
    '?meta?'(Or, Bk).

'$meta$'(\+ Goal, Bk) :-
    '?meta?'(Goal, Bk), !,
    fail.
'$meta$'(\+ _, _) :- !.

'$meta$'(not Goal, Bk) :-
    '?meta?'(Goal, Bk), !,
    fail.
'$meta$'(not _, _) :- !.

'$meta$'([H|T], _) :- !,
    '$ consult_files'([H|T]).

'$meta$'(Goal, _) :-
    'meta%f'(Goal).

'$ consult_files'([]) :- !.
'$ consult_files'([H|T]) :-
    '$ consult_one'(H),
    '$ consult_files'(T).

'$ consult_one'(-Where) :-
    '$ catch_call'(reconsult(Where)), !.
'$ consult_one'(-_) :- !.
'$ consult_one'(Where) :-
    '$ catch_call'(consult(Where)), !.
'$ consult_one'(_).

'$ catch_call'(G) :-
  catch(G,system_fail(G,C),C).

one(Goal) :-
    Goal, !.


forall(Gen, Test) :-
    Gen,
    not Test, !,
    fail.
forall(_, _).


findall(Term, Goal, Termlist) :-
    Count = [0],
    'back%f'(N),
    '?concat?'('findall$', N, Obj),
    '?findall?'(Goal, Term, Termlist, Count, Obj).

'?findall?'(Goal, Term, _, Count, Obj) :-
    Goal,
    'inc%f'(Count),
    Count = [N],
    'set_prop%f'(Obj, N, Term),
    fail.
'?findall?'(_, _, Termlist, Count, Obj) :-
    Count = [N],
    '?collect_terms?'(N, Obj, [], Termlist).

'?collect_terms?'(0, Obj, L, L) :- !,
    'del_props%f'(Obj).
'?collect_terms?'(N, Obj, Rest, Terms) :-
    '?get_prop?'(Obj, N, Term),
    'sub%f'(N, 1, M),
    '?collect_terms?'(M, Obj, [Term|Rest], Terms).


bagof(Term, Query, List) :-
    '?existential-vars?'(Query, Call, Evars),
    '?varsin?'(Term, Tvars),
    '?varsin?'(Call, Cvars),
    append(Evars, Tvars, Etvars),
    '?list-subtract?'(Cvars, Etvars, Lvars),
    findall(Lvars(Term), Call, Pairs), !,
    '?split?'(Pairs, Lvars, List).

'?existential-vars?'(Query, Call, [Exist|Lvars]) :-
    not var(Query),
    Query = Exist ^ Subquery, !,
    '?existential-vars?'(Subquery, Call, Lvars).
'?existential-vars?'(Query, Query, Lvars) :-
    '?existential?'(Query, Lvars).

'?existential?'(Goal, Lvars) :-
    tag(Goal, N),
    '?validGoal?'(N, Goal), !,
    '$existential$'(Goal, Lvars).
'?existential?'(_, []).

'$existential$'(bagof(Term, Query, _), Etvars) :- !,
    '?existential-vars?'(Query, _, Evars),
    '?varsin?'(Term, Tvars),
    append(Evars, Tvars, Etvars).
'$existential$'(setof(Term, Query, _), Etvars) :- !,
    '?existential-vars?'(Query, _, Evars),
    '?varsin?'(Term, Tvars),
    append(Evars, Tvars, Etvars).
'$existential$'((This,That), Lvars) :- !,
    '?existential?'(This, V1),
    '?existential?'(That, V2),
    append(V1, V2, Lvars).
'$existential$'((Either;Or), Lvars) :- !,
    '?existential?'(Either, V1),
    '?existential?'(Or, V2),
    append(V1, V2, Lvars).
'$existential$'((If->Then), Lvars) :- !,
    '?existential?'(If, V1),
    '?existential?'(Then, V2),
    append(V1, V2, Lvars).
'$existential$'(\+ Query, Lvars) :- !,
    '?existential?'(Query, Lvars).
'$existential$'(not Query, Lvars) :- !,
    '?existential?'(Query, Lvars).
'$existential$'(_, []).

'?list-subtract?'([], _, []) :- !.
'?list-subtract?'([V|Pos], Neg, Dif) :-
    on(Var, Neg),
    V == Var, !,
    '?list-subtract?'(Pos, Neg, Dif).
'?list-subtract?'([V|Pos], Neg, [V|Dif]) :-
    '?list-subtract?'(Pos, Neg, Dif).

'?split?'(Pairs, Lvars, List) :-
    '?same-instance?'(Pairs, Inst, Rempairs, Firstlist), !,
    (   Lvars(List) = Inst(Firstlist)
    ;   '?split?'(Rempairs, Lvars, List)
    ).

'?same-instance?'([Inst(Term)|Pairs], Inst, Rempairs, [Term|List]) :-
    '?instances-of?'(Pairs, Inst, Rempairs, List).

'?instances-of?'([], _, [], []).
'?instances-of?'([In(Term)|Pairs], Inst, Rempairs, [Term|List]) :-
    Inst == In, !,
    '?instances-of?'(Pairs, Inst, Rempairs, List).
'?instances-of?'([Pair|Pairs], Inst, [Pair|Rempairs], List) :-
    '?instances-of?'(Pairs, Inst, Rempairs, List).


setof(Term, Call, List) :-
    bagof(Term, Call, L1),
    qsort(L1, L2, @<),
    '?unique?'(L2, List).

'?unique?'([], []) :- !.
'?unique?'([First, Second|Rest], List) :-
    First == Second, !,
    '?unique?'([Second|Rest], List).
'?unique?'([First|Rest], [First|List]) :-
    '?unique?'(Rest, List).


map(_, []) :- !.
map(Rel, [H|T]) :-
    '?map?'(Rel, H), !,
    map(Rel, T).

'?map?'(Rel, Item) :-
    'atom%f'(Rel),
    Rel(Item).
'?map?'(Rel, Item) :-
    Rel =.. List,
    append(List, [Item], List1),
    Call =.. List1,
    Call.

map(_, [], []) :- !.
map(Rel, [H|T], [Hout|Outlist]) :-
    Rel =.. List,
    append(List, [H, Hout], List1),
    Call =.. List1,
    Call, !,
    map(Rel, T, Outlist).

map(_, [], Invalue, Invalue) :- !.
map(Rel, [H|T], Invalue, Outvalue) :-
    Rel =.. List,
    append(List, [H, Invalue, Temp], List1),
    Call =.. List1,
    Call, !,
    map(Rel, T, Temp, Outvalue).

map(_, [], [], Invalue, Invalue) :- !.
map(Rel, [H|T], [Hout|Outlist], Invalue, Outvalue) :-
    Rel =.. List,
    append(List, [H, Hout, Invalue, Temp], List1),
    Call =.. List1,
    Call, !,
    map(Rel, T, Outlist, Temp, Outvalue).
