/* Copyright (C) 1992 Imperial College */
/* fork a child thread */
fork(Goal) :-
    fork(Goal, _).

fork(Goal, Th) :-
    pipe(Out, In), Out = port(O), In = port(I),
    new_thread(Th),
    'thread%f'(Parent),
    write_pipe(Out, Goal+Parent),
    'close_port%f'(O),
    'fork%f'(Th, I).



% /* remote procedure call */
% rpc(Goal) :-
%     rpc(Goal, Th, Output),
%     '$read_answer$'(Goal, Th, Output).
% 
% '$read_answer$'(Goal, Th, Output) :-
%     read_pipe(Output, NewGoal),
%     (   Goal = NewGoal ->
%         true
%     ;   !,
%         close_port(Output),
%         kill_thread(Th),
%         fail
%     ).
% '$read_answer$'(Goal, Th, Output) :-
%     suspend,
%     'resume%f'(Th),
%     '$read_answer$'(Goal, Th, Output).
% 
% /* deterministic remote procedure call */
% detrpc(Goal) :-
%     rpc(Goal, Th, Output),
%     read_pipe(Output, NewGoal),
%     kill_thread(Th),
%     Goal = NewGoal.
% 
% rpc(Goal, Th, In2) :-
%     pipe(Out1, In1), Out1 = port(O1), In1 = port(I1),
%     pipe(Out2, In2), Out2 = port(O2),
%     new_thread(Th),
%     'thread%f'(Parent),
%     write_pipe(Out1, Goal+Parent),
%     'close_port%f'(O1),
%     'rpc%f'(Th, I1, O2).

new_thread(T) :- '$ primcatch'('?new_thread?'(T), new_thread(T)).

'?new_thread?'(Th) :-
    'new_thread%f'(Th).

pipe(O, I) :- '$ primcatch'('?pipe?'(O, I), pipe(O, I)).

'?pipe?'(port(Out), port(In)) :-
    'pipe%f'(Out, In).

read_pipe(I, T) :- '$ primcatch'('?read_pipe?'(I, T), read_pipe(I, T)).

'?read_pipe?'(port(In), Term) :-
    'read_pipe%f'(In, Term).

look_pipe(I, T) :- '$ primcatch'('?look_pipe?'(I, T), look_pipe(I, T)).

'?look_pipe?'(port(In), Term) :-
    'look_pipe%f'(In, Term).

commit_read(I) :- '$ primcatch'('?commit_read?'(I), commit_read(I)).

'?commit_read?'(port(In)) :-
    'commit_read%f'(In).

unlock(I) :- '$ primcatch'('?unlock?'(I), unlock(I)).

'?unlock?'(port(In)) :-
    'unlock%f'(In).

empty_pipe(I) :- '$ primcatch'('?empty_pipe?'(I), empty_pipe(I)).

'?empty_pipe?'(port(In)) :-
    'empty_pipe%f'(In).

write_pipe(O, T) :- '$ primcatch'('?write_pipe?'(O, T), write_pipe(O, T)).

'?write_pipe?'(port(Out), Term) :-
    'write_pipe%f'(Out, Term).

close_port(P) :- '$ primcatch'('?close_port?'(P), close_port(P)).

'?close_port?'(port(P)) :-
    'close_port%f'(P).

release_port(P) :- '$ primcatch'('?release_port?'(P), release_port(P)).

'?release_port?'(port(P)) :-
    'release_port%f'(P).

is_iport(P) :- '$ primcatch'('?is_iport?'(P), is_iport(P)).

'?is_iport?'(port(P)) :-
    'is_iport%f'(P).

is_oport(P) :- '$ primcatch'('?is_oport?'(P), is_oport(P)).

'?is_oport?'(port(P)) :-
    'is_oport%f'(P).

ram_pipe(O, I) :- '$ primcatch'('?ram_pipe?'(O, I), ram_pipe(O, I)).

'?ram_pipe?'(memory(Out), memory(In)) :-
    'ram_pipe%f'(Out, In).



/* shell programs for new threads */
/* BEWARE : THIS PREDICATE NAME IS HARD WIRED IN C CODE */
'$fork$' :-
    'thread%f'(Th),
    current_input(In),
    read_pipe(In, Goal+Parent),
    In = port(IP),
    'close_port%f'(IP),
    get_prop(Parent, initial, (_,I,O,E)),
    set_prop(Th, initial, (Goal,I,O,E)),
    set_prop(Th, undefined, fail),
    '?set_input?'(I),
    '?set_output?'(O),
    catch(Goal, system_fail(Goal, Err), Err), !,
    exit.
'$fork$' :-
    exit.

% /* BEWARE : THIS PREDICATE NAME IS HARD WIRED IN C CODE */
% '$rpc$' :-
%     'thread%f'(Th),
%     current_input(In),
%     current_output(Out),
%     read_pipe(In, Goal+Parent),
%     get_prop(Parent, initial, (_,I,O,E)),
%     set_prop(Th, initial, (Goal,I,O,E)),
%     set_prop(Th, undefined, fail),
%     '?set_input?'(I),
%     '?set_output?'(O),
%     '?rpc?'(Goal, Parent, Out).
% 
% '?rpc?'(Goal, Parent, Out) :-
%     catch(Goal, system_fail(Goal, Err), Err),
%     write_pipe(Out, Goal),
%     suspend,
%     'resume%f'(Parent),
%     fail.
% '?rpc?'(_, _, Out) :-
%     write_pipe(Out, end_of_file),       /* anything which isn't a valid goal */
%     exit.

exit :-
    'thread%f'(Th),
    kill_thread(Th),
    'resume%f'(0).

resume :-
    resume(0).
resume(Th) :- '$ primcatch'('?resume?'(Th), resume(Th)).

'?resume?'(Th) :-
    'resume%f'(Th).

thread(Th) :-
    'thread%f'(Th).

kill_thread(Th) :-
    get_prop(Th, initial, Term),
    Term = (Goal,In,Out,Err),
    '$ close_streams'(Goal,In,Out,Err), !,
    (   get_prop(Th, '$ lazy_out', Port) ->
		close(Port)
    ;   true
    ),
    del_props(Th),
    'kill_thread%f'(Th).
kill_thread(_).

'$ close_streams'('<TOP_SHELL>', _, _, _) :- !, halt.
'$ close_streams'('<SHELL>', In, _, _) :- !,
    close(In).
'$ close_streams'(_, In, Out, Err) :-
    '$ close'(In),
    '$ close'(Out),
    '$ close'(Err).

'$ close'(stream(_)) :- !.
'$ close'(S) :-
    close(S).

suspend :-
    'suspend%f'.

suspend(Th) :-
    'suspend%f'(Th).

timeslice(X) :-
    'timeslice%f'(X).

'?parlog_ops?'(X) :-
    thread(Th),
    get_prop(Th, initial, L),
    set_prop(parlog, initial, L),
    'init_parlog%f'(X).

parlog :- '$ primcatch'('?parlog_ops?'(0), parlog).
xparlog :-
	'$ primcatch'('?parlog_ops?'(1), xparlog),
	'resume%f'(0), 'resume%f'(0), 'resume%f'(0).	% delay

parlog(Goal) :-
    recall(parlog_port, P), !,
    write_pipe(P, Goal),
    release_port(P).
parlog(Goal) :-
    pname(Goal, Pname),
    set_prop('$parlog$', '$argv$', [Pname,halt]),
    parlog, !,
    set_prop('$parlog$', '$argv$', []).
parlog(_) :-
    write(user_error, '\nParlog has not been started yet.\nCall parlog/0 or xparlog/0 first !\n'),
    fail.


close_parlog :-
    'get_port%f'(1, P),			/* retrieve parlog port */
    'close_port%f'(P),
    forget(parlog_port),
    del_prop(parlog, initial).

qprolog(Goal) :-
    'get_port%f'(0, P1),		/* retrieve prolog port */
    pipe(Out, In),
    write_pipe(port(P1), Goal+Out),
    release_port(port(P1)),
    read_pipe(In, Answer),
    close_port(In),
    Goal = Answer.

'$prolog_server'(Queries) :-
    read_pipe(Queries, Goal+Port),
    (  catch(Goal, system_fail(Goal, Err), Err)
    -> write_pipe(Port, Goal)
    ;  true 
    ),
    close_port(Port), !,
    '$prolog_server'(Queries).
'$prolog_server'(_) :-
    write(user, '\nprolog server unexpectedly failed\n').

/* BEWARE : THIS PREDICATE NAME IS CALLED BY PARLOG */
'$solve'(Goal, Out) :-
    catch(Goal, system_fail(Goal, Err), Err),
    write_pipe(Out, Goal),
    fail.
'$solve'(_, Out) :-
    close_port(Out),
    exit.

/* BEWARE : THIS PREDICATE NAME IS CALLED BY PARLOG */
'$lazy_solve'(Goal, Out) :-
    thread(Th),
    set_prop(Th, '$ lazy_out', Out),
    catch(Goal, system_fail(Goal, Err), Err),
    write_pipe(Out, Goal),
    'suspend%f',
    'resume%f'(0),
    fail.
'$lazy_solve'(_, _) :-
    exit.

/* BEWARE : THIS PREDICATE NAME IS HARD WIRED IN C CODE */
'$nested$'(Goal) :-
    get_prop(xpce, debug, on),
    writeseqnl(user_error, ['XPCE callback :', Goal]),
    (   call(Goal) ->
	writeseqnl(user_error, [callback, Goal, succeeded]), 'exit%f'(1)
    ;   writeseqnl(user_error, [callback, Goal, succeeded]), 'exit%f'(0)
    ), !.
'$nested$'(Goal) :-
    call(Goal), !,
    'exit%f'(1).
'$nested$'(_) :-
    'exit%f'(0).
