/* Copyright (C) 1992 Imperial College */
/* 1.10.90 must add '$ continuation'/1 to public list */

/* takes a single source, or list of sources */
load([]) :- !.
load([First|Rest]) :- !,
  '$file_type$'(First, Type),
  '$load$'(First, Type),
  load(Rest).
load(File) :-
  '$file_type$'(File, Type),
  '$load$'(File, Type).

load([], _) :- !.
load([First|Rest], Type) :- !,
  '$load$'(First, Type),
  load(Rest, Type).
load(File, Type) :-
  '$load$'(File, Type).

'$load$'(Name, Type) :-
	'$maybe_compile$'(Name), !,
	loadicp(Name, Type).

'$maybe_compile$'(Name) :-
	'$ srcfile'(Name, Src, Type),
	file_exists(Src),
	out_of_date(Name, Type), !,
	compile(Name, []).
'$maybe_compile$'(Name) :-
	'$ icpfile'(Name, Bin),
	file_exists(Bin), !.
'$maybe_compile$'(Name) :-
	compile(Name, []).

loadicp(Name) :-
	'$file_type$'(Name, Type), !,
	loadicp(Name, Type).

loadicp(Name, Type) :-
  '$ icpfile'(Name, Fullname),
  writeseq(user_error, ['loading', Fullname, '...']),
  flush_output(user_error),
  '$loader$'(Fullname, Type), !,
  '$ LOAD',
  writenl(user_error, 'ok').
loadicp(_, _) :-
  writenl(user_error, 'aborted').

'$ loader'(Name) :-
	'$file_type$'(Name, Type), !,
	'$loader$'(Name, Type).

'$loader$'(Where, Type) :-
  current_input(Temp),
  open(Where, read, W),
  set_input(W),
  '$read_binary$'(Type),
  close(W),
  set_input(Temp).

'$ LOAD' :-
  'defined%f'('<LOAD>', _),
  'gensym%f'('<LOAD>', Begin),
  ( '<LOAD>', fail ; true ), !,
  system(on),
  abolish('<LOAD>'),
  system(off),
  'gensym%f'('<LOAD>', End),
  'name%f'(Begin, [_,_,_,_,_,_|BL], 1),
  'name%f'(B, BL, 2),
  'name%f'(End, [_,_,_,_,_,_|EL], 1),
  'name%f'(E, EL, 2),
  Next is B++1,
  '$execute_load$'(Next, E).
'$ LOAD'.

'$execute_load$'(End, End) :- !.
'$execute_load$'(Num, End) :-
  'concat%f'('<LOAD>', Num, Prop),
  'get_prop%f'('<LOAD>', Prop, Goal),
  'del_prop%f'('<LOAD>', Prop),
  call(Goal),
  Next is Num++1, !,
  '$execute_load$'(Next, End).

'$file_type$'(Name, Type) :-
	defined(system_file/1),
	system_file(Name), !,
	Type = system.
'$file_type$'(Name, Type) :-
	defined(system_file/1),
	'suffix%f'(Name, '.icp'),
	concat(Base, '.icp', Name),
	system_file(Base), !,
	Type = system.
'$file_type$'(_, user).

'$read_binary$'(Type) :-
  'load%f'(Type), 
  '$ validate'(Status),
  (   Status == failure ->
        !, fail
  ;   '$read_binary$'(Type)
  ), !.
% reached end of file
'$read_binary$'(_).
  
'$ validate'(Status) :-
    'validate%f'(Defined,Flag),
    '$partition$'(Defined,User,System),
    '$ validate'(Flag,User,System,Status),
    '$ continuation'(Status).	/* must do this before any meta-calls */

'$ validate'(0,[],[],static) :- !.
'$ validate'(0,User,[],static) :- !,
    '$ notify'(User,'redefining: '),
    '$abolish_all$'(User).
'$ validate'(0,_,[System|Rest],failure) :- !,
    '$ notify'([System|Rest],'cannot redefine system predicate(s): ').
'$ validate'(1,[],[],static) :- !.
'$ validate'(1,User,[],static) :- !,
    '$ notify'(User,'redefining: '),
    '$abolish_all$'(User).
'$ validate'(1,_,[System|Rest],failure) :- !,
    '$ notify'([System|Rest],'cannot redefine system predicate(s): ').      
'$ validate'(2,[],_,(dynamic)) :- !.
'$ validate'(2,[P/A],_,(dynamic)) :-
	'$ pred'(P,A,_,(dynamic)), !,
	concat('$c$',P,DbName),
        N is A ++ 1,
	'$ unlink'(P,A,DbName,N).
'$ validate'(2,[Pred],_,failure) :-
        '$ notify'([Pred],'cannot redefine static predicate ').

'$ continuation'(static) :-
  'fix_tables%f'.
'$ continuation'(failure) :-
  'undo_seg%f'.
'$ continuation'((dynamic)) :-
  'link%f'(0).
  
'$abolish_all$'([]).
'$abolish_all$'([First|Rest]) :-
    abolish(First),!,
    '$abolish_all$'(Rest).

'$partition$'([],[],[]).
'$partition$'([Pred,Ar|Rest],User,[Pred/Ar|System]) :-
    '$ pred'(Pred, Ar, system, _), !,
    '$partition$'(Rest,User,System).
'$partition$'([Pred,Ar|Rest],[Pred/Ar|User],System) :-  !,
    '$partition$'(Rest,User,System).
