/* Copyright (C) 1992 Imperial College */

/* max determines the maximum of two numbers */
max(A, B, Max) :- A >= B, !, A = Max.
max(_, B, B).

/* occ is unsafe list membership */
occ(Var, [Var|_]) :- !.
occ(Var, [_|List]) :-
         occ(Var, List).

/* no_occ is non-membership */
no_occ(_, []) :- !.
no_occ(E, [T|L]) :-
         E \= T,
         no_occ(E, L).

/* quick sort program */
qsort(List,Sorted,Test):-
	'atom%f'(Test),
        '?qs?'(List,Sorted,[],Test).

'?qs?'([],S,S,_) :- !.
'?qs?'([El],[El|L],L,_):-!.
'?qs?'([E|L],S1,S2,Test):-
        '?part?'(L,E,P1,P2,Test),
        '?qs?'(P1,S1,[E|S],Test),!,
        '?qs?'(P2,S,S2,Test).

'?part?'([],_,[],[],_) :- !.
'?part?'([D|L],E,[D|P1],P2,Test):-
        Test(D,E),!,
        '?part?'(L,E,P1,P2,Test).
'?part?'([D|L],E,P1,[D|P2],Test):-
        '?part?'(L,E,P1,P2,Test).



/* arb-member member of an arbitrary structure */
arb_member(El, Term):-
  '?in_term?'(Term, El), !.
/* this is needed to avoid a call to negation and hence meta_variable */
not_arb_member(El, Term):-
  '?in_term?'(Term, El), !,
  fail.
not_arb_member(_, _).

'?in_term?'(Term, Name) :-
    'tag%f'(Term, N),
    '?in_term?'(N, Term, Name).

'?in_term?'(0, _, _) :- !,
    fail.
'?in_term?'(_, Name, Name) :- !.
'?in_term?'(5, [H|_], Name) :-
    'tag%f'(H, N),
    '?in_term?'(N, H, Name), !.
'?in_term?'(5, [_|List], Name) :-
    'tag%f'(List, N),
    '?in_term?'(N, List, Name), !.
'?in_term?'(6, Tuple, Name) :-
    'arity%f'(Tuple, Len),
    'gt%f'(Len, 0),
    '?in_tpl_term?'(0, Len, Tuple, Name).

'?in_tpl_term?'(Pos, _, Tuple, Name) :-
    'arg%f'(Pos, Tuple, Term),
    'tag%f'(Term, N),
    '?in_term?'(N, Term, Name), !.
'?in_tpl_term?'(Pos, Len, Tuple, Name) :-
    'increment%f'(Pos, Ps),
    'lt%f'(Ps, Len),
    '?in_tpl_term?'(Ps, Len, Tuple, Name).



defined(Rel) :- '$ defined'(Rel, _).

'$ defined'(Rel, Address) :-
    'var%f'(Address),
    'defined%f'(Rel, Address).

address(X,Y) :- '$ primcatch'('?address?'(X,Y), address(X,Y)).

'?address?'(X, Y) :-
    'addr%f'(X,Y).

time(X)      :- '$ primcatch'('?time?'(X), time(X)).

ctime(A, Year, Month, Day, Hour, Min, Sec) :-
	number(A), !,
	'ctime%f'(A, Year1, Month1, Day1, Hour1, Min1, Sec1),
	(Year,Month,Day,Hour,Min,Sec) = (Year1,Month1,Day1,Hour1,Min1,Sec1).
ctime(A, Year, Month, Day, Hour, Min, Sec) :-
	integer(Year), integer(Month), integer(Day),
	integer(Hour), integer(Min), integer(Sec),
	'ctime%f'(A, Year, Month, Day, Hour, Min, Sec).

'?time?'(X) :-
    'time%f'(X).

realtime(X) :- '$ primcatch'('?realtime?'(X), realtime(X)).

'?realtime?'(X) :-
    'realtime%f'(X).

/*************** this is sicstus
statistics(runtime, L) :- '$runtime'(L).
	statistics(memory, L) :- '$total_usage'(L).
	statistics(program, L) :- '$program_usage'(L).
	statistics(global_stack, L) :- '$termheap_usage'(L).
	statistics(local_stack, L) :- '$envstack_usage'(L).
	statistics(trail, L) :- '$trail_usage'(L).
	statistics(choice, L) :- '$choice_usage'(L).
	statistics(garbage_collection, L) :- '$gc_usage'(L).
	statistics(stack_shifts, L) :- '$stack_shift_usage'(L).
	statistics(core, L) :- statistics(memory, L).
	statistics(heap, L) :- statistics(program, L).
********************/
statistics(runtime, X) :-
	X = [T1, T2],
	'$ primcatch'('?runtime?'(T1, T2), statistics(runtime, X)).
statistics(garbage_collection, X) :-
	X = [Time, Size, Number],
	'$ primcatch'('?gc_usage?'(Time, Size, Number),
		statistics(garbage_collection, X)).

'?runtime?'(Total, SinceStats) :- 'runtime%f'(Total, SinceStats).

'?gc_usage?'(Time, Size, Number) :- 'gc_usage%f'(Time, Size, Number).

/* append '.pl' suffix if not already present */
'$ srcfile'(Name, Name, Type) :-
  '$ file_extension_type'(Ext, Type),
  'suffix%f'(Name, Ext), !.
'$ srcfile'(Base, Name, Type) :-
  '$ file_extension_type'(Ext, Type),
  concat(Base, Ext, Name),
  file_exists(Name), !.
'$ srcfile'(Base, Name, pl) :-
  concat(Base, '.pl', Name).

'$file_extension_type$'('.lo', lo).
'$file_extension_type$'('.pl', pl).

'$ file_extension_type'(Ext, Type) :-
	'$file_extension_type$'(Ext, Type).
'$ file_extension_type'(Ext, Type) :-
	defined(user_file_type/2),
	user_file_type(Ext, Type), !,
	\+ '$file_extension_type$'(Ext, _).

/* append '.icp' suffix if not already present */
'$ icpfile'(Name, Name) :-
  'suffix%f'(Name, '.icp'), !.
'$ icpfile'(Base, Name) :-
  concat(Base, '.icp', Name).

out_of_date(Base, Type) :-
	'$ filenames'(Base, Srcfile, Binfile, Type),
	stat(Srcfile, _, PlTime, _, _, _, _),
	stat(Binfile, _, IcpTime, _, _, _, _),
	IcpTime >= PlTime, !,
	fail.
out_of_date(_, _).

errno(X,Y) :- 'errno%f'(X,Y).

'$ return_clr_eol'('\n') :-
	recall(debugger, on).
'$ return_clr_eol'('\r\e[K').

window_label(Title) :-
	write(user, '\e]2;'),
	write(user, Title),
	write(user, '\^G'),
	flush.

icon_label(Title) :-
	write(user, '\e]1;'),
	write(user, Title),
	write(user, '\^G'),
	flush.

set_prolog_flag(Flag, Value) :-
	nonvar(Value),
	nonvar(Flag),
	'$set_prolog_flag$'(Flag, Value).

'$set_prolog_flag$'(trace, on) :- trace.
'$set_prolog_flag$'(trace, off) :- notrace.

'$set_prolog_flag$'(undefined_predicate, error) :-
	thread(Th),
	set_prop(Th, undefined, error).
'$set_prolog_flag$'(undefined_predicate, fail) :-
	thread(Th),
	set_prop(Th, undefined, fail).
'$set_prolog_flag$'(undefined_predicate, warning) :-
	thread(Th),
	set_prop(Th, undefined, warning).

get_prolog_flag(Flag, Value) :-
	nonvar(Flag),
	'$ get_prolog_flag$'(Flag, Value).

'$ get_prolog_flag$'(trace, on) :-
	thread(Th),
	get_prop(Th, trace, on), !.
'$ get_prolog_flag$'(trace, off).

'$ get_prolog_flag$'(undefined_predicate, Flag) :-
	thread(Th),
	get_prop(Th, undefined, Flag), !.
'$ get_prolog_flag$'(undefined_predicate, error).


?- dynamic '$loaded$'/1.

ensure_loaded([]) :- !.
ensure_loaded([H|T]) :- !,
	'$ensure_loaded'(H),
	ensure_loaded(T).
ensure_loaded(F) :-
	'$ensure_loaded'(F).

'$ensure_loaded'(F) :-
	'$loaded$'(F), !.
'$ensure_loaded'(F) :-
	load(F),
	assert('$loaded$'(F)).

set_path(Path) :-
	atom(Path), !,
	set_prop('$prolog$', '$icp_path$', [Path]).
set_path(Path) :-
	list(Path), !,
	set_prop('$prolog$', '$icp_path$', Path).
set_path(Path) :-
	writeseqnl(user_error, ['ERROR:', set_path(Path), 'Argument must be a list of atoms']), fail.

get_path(Path) :- get_prop('$prolog$', '$icp_path$', Path).

absolute_file_name(File, Abs) :-
	stat(File, Abs, _, _, _, _, _).
