/* Copyright (C) 1992 Imperial College */
/* public list :
        [op/3, current_op/3, '$ op'/3]
*/
op(P,T,O) :- '$ primcatch'('$ op'(P,T,O), op(P,T,O)).

'$ op'(P, T, O) :-
    'int%f'(P),
    P >= 0,
    P =< 1200, !,
    op_test(P, T, O).
'$ op'(_, _, _) :-
    throw(401).

op_test(P, T, O) :-
    type(T, P, L, R, Ty), !,
    op_choose(O, T, P, L, R, Ty).
op_test(_, _, _) :-
    throw(402).

op_choose(Op, _, P, L, R, Ty) :-
    'atom%f'(Op), !,            % If op is valid then RC
    op_one(Ty, P, L, R, Op).    
op_choose(Ops, T, P, L, R, Ty) :-
    list(Ops), !,  % RC
    op_list(Ops, op(P,T,Ops), P, L, R, Ty).
op_choose(_, _, _, _, _, _) :- 
    throw(204).

op_list([], _, _, _, _, _) :- !.
op_list([Op | Ops], Goal, P, L, R, Ty) :-
    'atom%f'(Op),
    op_one(Ty, P, L, R, Op), !,
    op_list(Ops, Goal, P, L, R, Ty).
op_list([Op | Ops], Goal, P, L, R, Ty) :-
    system_error((Goal-->Op), 204),
    op_list(Ops, Goal, P, L, R, Ty).

op_one(pre, P, _, R, O) :- !,   % RC
    'op_prefix%f'(P, R, O).
op_one(in, P, L, R, O) :- !,    % RC
    'op_infix%f'(L, P, R, O).
op_one(post, P, L,  _, O) :-
    'op_postfix%f'(L, P, O).

type(Type, _, _, _, _) :-
    'var%f'(Type), !,
     fail.
type(fy, P, _, P, pre).
type(fx, P, _, R, pre) :-  
    R is P -- 1.
type(yfy, P, P, P, in).
type(yfx, P, P, R, in) :- 
    R is P -- 1.
type(xfy, P, L, P, in) :- 
    L is P -- 1.
type(xfx, P, L, L, in) :- 
    L is P -- 1.
type(yf, P, P, _, post).
type(xf, P, L, _, post) :- 
    L is P -- 1.

current_op(P, T, O) :-
    'atom%f'(O), !,
    'op_look%f'(O, XR, OX, XOR, LXR, LOX, LX, XO),
    decode_op(T, P, XR, OX, XOR, LXR, LOX, LX, XO).
current_op(P, T, O) :-
    'var%f'(O),
    enum(O, -1, T, P).

enum(O, N, T, P) :-
    'op_get%f'(O, N, XR, OX, XOR, LXO, LOX, LX, XO, M),
    match(O, M, T, P, XR, OX, XOR, LXO, LOX, LX, XO).

match(_, _, T, P, XR, OX, XOR, LXO, LOX, LX, XO) :-
    decode_op(T, P, XR, OX, XOR, LXO, LOX, LX, XO).
match(O, M, T, P, _, _, _, _, _, _, _) :-
    enum(O, M, T, P).

decode_op(T, P, P, R, _, _, _, _, _) :-
    P =< 1200,
    prefix(T, P, R).
decode_op(T, P, _, _, L, P, R, _, _) :-
    P =< 1200,
    infix(T, P, L, R).
decode_op(T, P, _, _, _, _, _, P, L) :-
    P =< 1200,
    postfix(T, P, L).

prefix(fy, P, P) :- !.
prefix(fx, P, R) :- 
    R is P -- 1.

infix(yfy, P, P, P) :- !.
infix(yfx, P, P, R) :- 
    R is P -- 1, !.
infix(xfy, P, L, P) :- 
    L is P -- 1, !.
infix(xfx, P, L, L) :- 
    L is P -- 1.

postfix(yf, P, P) :- !.
postfix(xf, P, L) :-
    L is P -- 1.    
