/* Copyright (C) 1992 Imperial College */
/* pjs 24.6.90 */

/* Public List for Compilation : on 31.5.90
[	predicate/2,
        current_predicate/2,
        system_predicate/2,
        save/2,
	save/3,
        abolish/1,
        kill/1,
        '$ notify'/2, 
]
*/

predicate(Name,Term) :-
	'$predicate$'(Name,Term,Type),
	\+ '$hidden$'(Type, Name).

'$hidden$'(system, Name) :- 'prefix%f'(Name, '$').
'$hidden$'(system, Name) :- 'prefix%f'(Name, '?').

current_predicate(Name,Term) :- '$predicate$'(Name,Term,user).

system_predicate(Name,Term) :-
	'$predicate$'(Name,Term,system),
	\+ '$hidden$'(system, Name).

predicate_property(Term, Property) :-
	'tpl%f'(Term),
	functor(Term,Name,Arity),
	'atom%f'(Name), !,
	'$pred_look$'(Name, Arity, Type, Storage),
	'$property$'(Property, Storage, Type).
predicate_property(Term, Property) :-
	'var%f'(Property), !,
	'$get_pred$'(Name,Arity,Type,Storage),
	functor(Term, Name, Arity),
	'$property$'(Property, Storage, Type).
predicate_property(Term, Property) :-
	'$property$'(Property, Storage, Type),
	'$get_pred$'(Name,Arity,Type,Storage),
	functor(Term, Name, Arity).

'$property$'(Storage, Storage, _).
'$property$'(Type, _, Type).

'$ pred'(Name,Arity,Type,Storage) :-
    'atom%f'(Name),
    'int%f'(Arity),!,  
    '$pred_look$'(Name, Arity, Type, Storage).
'$ pred'(Name,Arity,Type,Storage) :-
    '$get_pred$'(N,Arity,Type,Storage),
    Name = N.

'$predicate$'(Name,Term,Type) :- 
    'tpl%f'(Term),
    functor(Term,Name,Arity),
    'atom%f'(Name), !,
    '$pred_look$'(Name, Arity, Type, _).
'$predicate$'(Name,Term,Type) :-
    '$get_pred$'(N, Arity, Type, _),
    Name = N,
    functor(Term,Name,Arity).

'$pred_look$'(Name, Arity, Type, Storage) :-
    'pred_look%f'(Name,Arity,T,S),
    Type = T,
    Storage = S.
    
'$get_pred$'(Name,Arity,Type,Storage) :-
    remember(index,-1),
    repeat,
        recall(index,I),
        (   'pred_get%f'(Name,Arity,I,J,Type,Storage) ->
                (   remember(index,J)
                ;   fail
                ) 
        ;   !,
            fail
        ).

/* Simple Version of Save to get us going */

save(List, File) :-
    save(List, File, write).

save([], _, _).
save(Pred/Ar, File, Mode) :-
    save([Pred/Ar], File, Mode).
save([H|T], File, Mode) :-
    saver([H|T], File, Saved, Undef, Mode),
    '$ notify'(Saved, 'saving: '),
    '$ notify'(Undef, 'cannot save undefined predicate(s): ').

saver(Pred, File, Saved, Undef, Mode) :-
    concat(File, '.icp', Fullname),
    current_output(Out),
    open(Fullname, Mode, W),
    set_output(W), 
    'save%f'(Pred, Saved, Undef),!,
    close(W),
    set_output(Out).

'$ notify'([],_) :- !.
'$ notify'([First|Rest],Str) :- 
    write(user_error, Str),
    write(user_error, First),
    flush_output(user_error),
    notify2(Rest).

notify2([]) :- write(user_error, '.\n').
notify2([First|Rest]) :-
    write(user_error, ', '),
    write(user_error, First), !,
    flush_output(user_error),
    notify2(Rest).

abolish(Name/Arity) :-
    'atom%f'(Name),
    'int%f'(Arity), !,
    abolish(Name,Arity).
abolish(Name) :-
    'atom%f'(Name), !,
    abolish(Name,0).
abolish(Pred) :-        /* error: invalid argument */
    system_error(abolish(Pred),210).
    
abolish(Name,Arity) :-
    '$ pred'(Name, Arity, user, Type), !,
    abolish(Type,Name,Arity).
abolish(_,_).

abolish(static,Name,Arity) :- !,
    'abolish%f'(Name,Arity).
abolish((dynamic),Name,Arity) :-
    kill((dynamic),Name,Arity).

kill(Name/Arity) :-
    'atom%f'(Name),
    'int%f'(Arity), !,
    kill(Name,Arity).
kill(Name) :-
    'atom%f'(Name), !,
    kill(Name,0).
kill(Pred) :-           /* error: invalid argument */
    system_error(kill(Pred),210).
    
kill(Name,Arity) :-
    '$ pred'(Name, Arity, user, Type), !,
    kill(Type,Name,Arity).
kill(_,_).

kill(static,Name,Arity) :- !,
    'kill%f'(Name,Arity).
kill((dynamic),Name,Arity) :-
    defined(Name/Arity), !,
    concat('$c$',Name,DbName),
    DbArity is Arity + 1,
    'delete%f'(DbName,DbArity),
    'delete%f'(Name,Arity),
    '$ unlink'(Name,Arity,DbName,DbArity).
/*
kill((dynamic),Name,Arity) :-
    functor(Head,Name,Arity),
    '$ retract'(Head,Body,Name,Arity),
    fail.
*/
kill(_,_,_).
