/* Copyright (C) 1992 Imperial College */

:- op(900,fx,'??').
?- op(900,fx,'??').

% ------------------------------------------------------------------------
%			INTERPRETER
% ------------------------------------------------------------------------

'??'(Goal) :-
	remember(leash,143),
	remember(echo,143),
	'$ run'(Goal, backing_up(_), [], [], _, '').

'$ run'(!, backing_up(_), _, G, [!|G], Lvl) :-
	runcall(!,Lvl,'built-in '),
	runsucceed(!,Lvl,'built-in ').
% otherwise just fail first ancestor
'$ run'(!, backing_up(Goal), [Goal=_|_], G, G, _).
'$ run'(call(Goal),B,L,G1,G2,Lvl) :- !,
	'$ run'(Goal,B,L,G1,G2,Lvl).
'$ run'((P,Q), backing_up(To), L, G1, G3,Lvl) :-
	!,			% This is the only clause for a conjunction
	'$ run'(P, backing_up(Goal), L, G1, G2, Lvl),
	( nonvar(Goal),
	  G3 = G2,
	  To = Goal
	; '$ run'(Q, backing_up(To), L, G2, G3, Lvl)
	).
'$ run'((T->P;Q), backing_up(To), L, G1, G2, Lvl) :-
	!,			% This is the only clause for a if-then-else
	concat(Lvl,'-> ',LvA),
	('$ run'(T, backing_up(_), L, G1, G3, LvA)->
	   '$ run'(P, backing_up(To), L, G3, G2, LvA)
	; '$ run'(Q, backing_up(To), L, G1, G2, LvA)
	).
'$ run'((T->P), backing_up(To), L, G1, G2, Lvl) :-
	!,			% This is the only clause for a if-then
	concat(Lvl,'-> ',LvA),
	'$ run'(T, backing_up(_), L, G1, G3, LvA)->
	   '$ run'(P, backing_up(To), L, G3, G2, LvA).
'$ run'((P;Q), backing_up(To), L, G1, G2, Lvl) :-
	!,			% This is the only clause for a disjunction
	( '$ run'(P, backing_up(To), L, G1, G2, Lvl)
	; '$ run'(Q, backing_up(To), L, G1, G2, Lvl)
	).
'$ run'(not(Q), backing_up(_), L, G1, G1, Lvl) :-
	!,			% This is the only clause for not
	concat(Lvl,' not ',LvA),
	\+('$ run'(Q, backing_up(_), L, G1, _, LvA)).
'$ run'(\+(Q), backing_up(_), L, G1, G1, Lvl) :-
	!,			% This is the only clause for not
	concat(Lvl,' \\+ ',LvA),
	\+('$ run'(Q, backing_up(_), L, G1, _, LvA)).
'$ run'(P(), B, L, G1, G2, Lvl) :-
	'$ run'(P, B, L, G1, G2, Lvl).
'$ run'(P, backing_up(To), L, G1, [P/done|G2], Lvl) :-
	functor(P, Func, ArgCount),
	'$ pred'(Func, ArgCount, user, (dynamic)), !,
	runcall(P, Lvl, (dynamic)),
	% The only clause for a user-defined predicate
	run_dynamic(P, Func, ArgCount, To, L, G1, G2, Lvl).
'$ run'(P, backing_up(_), _, G, [P|G],Lvl) :-
	functor(P, Func, ArgCount),
	'$ pred'(Func, ArgCount, system, _), !,
	'$ execute'(P,P,Lvl,'built-in ').
'$ run'(P, backing_up(_), _, G, [P|G],Lvl) :-
	'$ execute'(P,P,Lvl,'static ').

run_dynamic(P, _, _, _, _, G1, G1, Lvl) :-
	recall(skipping, G),
	not(not(P=G)), !,
	forget(skipping),
	'$ execute2'(P, P, Lvl, 'skipped ').
run_dynamic(P, Func, ArgCount, To, L, G1, G2, Lvl) :-
	functor(Pgeneral, Func, ArgCount),
	N = [0],
	findall(M(Pgeneral,Q),(clause(Pgeneral,Q),'$ inc'(N),[M]=N), BodyList),
	\+ BodyList = [],
	!,			
	'$ execute2'(P,'$ runproc'(P,BodyList,To,L,G1,G2,Lvl), Lvl, (dynamic)).

'$ inc'(X) :- 'inc%f'(X).

%
%  This is where it all happens !
%
'$ execute'(P,Goal,Lvl,Type) :-
	runcall(P, Lvl, Type),
	'$ execute2'(P,Goal,Lvl,Type).

'$ execute2'(P,Goal,Lvl,Type) :-
	copy_term(P,H),
	(   call(Goal)
	;   runfail(P,Lvl,Type), fail
	),
	(   runsucceed(P,Lvl,Type)
	;   runredo(H,Lvl,Type), fail
	).

/* Hack to bypass trivial 'true' -- Timd, Sat Sep  9 20:28:47 1989  */
'$ runproc'(P,BodyList,To,L,G1,G2,Lvl) :-
	select(N(Head,Body), BodyList, Outstanding),
	runmatch(P,Head,N,Lvl),
	concat(Lvl,'  ',Nlvl),
	runignoretrivialtrue(Body,L,G1,P,G2,Outstanding,To,Nlvl),
	( nonvar(To),
	  To = P, !,
	  fail
	; true
	).

select(Item, [Item|Rest], Rest).
select(Item, [_|Rest], Tail) :- select(Item, Rest, Tail).

runmatch(P,Head,N,Lvl) :-
	runtrymatch(P,Head,N,Lvl),
	fail.
runmatch(Head1,Head2,N,Lvl) :-
	runsucceedmatch(Head1,Head2,N,Lvl), !.
runmatch(P,Head,Lvl) :-
	runfailmatch(P,Head,Lvl), !,
	fail.

runignoretrivialtrue(true,_,A3,A4,[true,A4|A3],_,_,_) :- !.
runignoretrivialtrue(Body,L,G1,P,G2,Outstanding,To,Lvl) :-
	'$ run'(Body, backing_up(To), [P=Outstanding|L], [P/called|G1],G2, Lvl).

% ------------------------------------------------------------------------
%			TRACER PORTS
% ------------------------------------------------------------------------

runcall(P,Lvl,Type) :-
	test_echo(1,_,Info),
	writeseq(user, [Lvl,'call']),
	write_type(Type),
	'$ icp_print'(user, P),
	check_leash(1,P,Info),
	fail.
runcall(_,_,_).

runfail(P,Lvl,Type) :-
	test_echo(8,P,Info),
	writeseq(user, [Lvl,'fail']),
	write_type(Type),
	'$ icp_print'(user, P),
	check_leash(8,_,Info),
	fail.
runfail(_,_,_).

runsucceed(P,Lvl,Type) :-
	test_echo(2,P,Info),
	writeseq(user, [Lvl,'exit']),
	write_type(Type),
	'$ icp_print'(user, P),
	check_leash(2,_,Info),
	fail.
runsucceed(_,_,_).

runredo(H,Lvl,Type) :-
	test_echo(4,_,Info),
	writeseq(user, [Lvl,'redo']),
	write_type(Type),
	'$ icp_print'(user, H),
	check_leash(4,H,Info),
	fail.
runredo(_,_,_).

write_type((dynamic)) :- !.
write_type(Type) :-
	write(user, Type).

runtrymatch(P,H,N,Lvl) :-
	test_echo(16,_,Info),
	writeseq(user, [Lvl,'try match clause',N,:,P,=,H]),
	check_leash(16,_,Info),
	fail.
runtrymatch(_,_,_,_).

runsucceedmatch(H,H,N,Lvl) :-
	test_echo(32,_,Info),
	writeseq(user, [Lvl,'succeed match clause',N,:,H]),
	check_leash(32,_,Info),
	fail.
runsucceedmatch(H1,H2,N,Lvl) :-
	test_echo(128,_,_),
	not (not H1 = H2),
	get_eqns(H1,H2,Eqns),
	Eqns \== [],
	writeseq(user, [Lvl,'unify clause',N]),
	writeqns(Eqns),
	fail.
runsucceedmatch(H,H,_,_).

runfailmatch(_,H,Lvl) :-
	test_echo(64,_,Info),
	writeseq(user, [Lvl,'fail match',H]),
	check_leash(64,_,Info),
	fail.
runfailmatch(_,_,_).

get_eqns(T1,T2,Eqns) :-
	toground(T1,G,V,N),
	tohollow(G,H,N,NV),
	H=T2,
	mk_eqns(V,NV,Eqns).

mk_eqns([],[],[]) :- !.
mk_eqns([V|RV],[T|RT],[V,T|RE]) :-
	nonvar(T), !,
	mk_eqns(RV,RT,RE).
mk_eqns([_|RV],[_|RT],RE) :-
	mk_eqns(RV,RT,RE).

writeqns(Eqns) :-
	current_output(Out),
	set_output(user_output),
	write_equations(Eqns),
	set_output(Out).

write_equations([]) :-
	write(' []\n').
write_equations([L,R|T]) :-
	write('['),
	'$ icp_print'(L),
	write(=),
	'$ icp_print'(R),
	writerest(T).

writerest([]) :-
	write(']\n').
writerest([L,R|T]) :-
	write(','),
	'$ icp_print'(L),
	write(=),
	'$ icp_print'(R),
	writerest(T).

% ------------------------------------------------------------------------
%			USER INTERFACE
% ------------------------------------------------------------------------

check_leash(B,P,leash) :-
	recall(leash,L),	% if port B is being leashed
	B is L /\ B, !,		% then stop and behave accordingly
	write(user, ' ? '),
	flush_output(user_output),
	tty_get0(C),
	react(C,B,P).
check_leash(_,_,_) :- nl.

react(10,_,_) :- !.
react(0'?,B,P) :-  skip(10),
	write(user, '\
----------------------------------------\n\
 <CR> - continue\n\
  s   - skip\n\
  u   - unleash\n\
  n   - no trace\n\
  a   - abort trace\n\
  e   - set echoes\n\
  l   - set leashes\n\
  p   - display echoed and leashed ports\n\
  d   - enter debugger\n\
  !   - shell escape\n\
----------------------------------------\n\
 ? '),
	flush_output(user_output),
	tty_get0(C), !,
	react(C,B,P).
react(0's,B,G) :- skip(10),
	(   0 is B /\ 5 ->
		write(user, 'skip only valid at call or redo ports\n'),
		react_again(B,G)
	;   remember(skipping,G)
	),!.
react(0'u,B,G) :-  skip(10),
	(   0 is B /\ 5 ->
		write(user, 'unleash only valid at call or redo ports\n'),
		react_again(B,G)
	;   remember(unleashing,G)
	),!.
react(0'n,_,_) :- !,
	skip(10),
	leash(0),
	echo(0), !.
react(0'a,_,_) :- !,
	skip(10),
	forget(skipping),
	forget(unleashing),
	throw(1000).
react(0'e,B,G) :-
	skip(10),
	display_help,
	set_echoes, !,
	react_again(B,G).
react(0'l,B,G) :-
	skip(10),
	display_help,
	set_leashes, !,
	react_again(B,G).
react(0'p,B,G) :-
	skip(10),
	display_info, !,
	react_again(B,G).
react(0'd,B,G) :- !,
	skip(10),
	debugicp,
	write(user, ' ... back to tracer (? for help)\n\n '),
	react_again(B,G).
react(0'!,B,G) :- !,
	skip(10),
	notrace,
	shell_escape,
	trace,
	write(user, '\n ... back to tracer (? for help)\n\n '),
	react_again(B,G).
react(_,_,_) :- skip(10), !.

react_again(B,G) :-
	write(user, ' ? '),
	flush_output(user_output),
	tty_get0(C),
	react(C,B,G).

leash(N) :-
	remember(leash,N), !.

echo(N) :-
	remember(echo,N).

display_help :-
	write(user, '\
Port specification (abbreviations in parentheses) :\n\
	call (c)\n\
	exit (e)\n\
	redo (r)\n\
	fail (f)\n\
	try_match (tm)\n\
	succeed_match (sm)\n\
	fail_match (fm)\n\
	unify (u)\n\
	none\n\
	all\n\
e.g.\n\
	call, -fail, -exit.\n\
or\n\
	c, -f, -e.\n\
enables call ports and disables fail and exit ports.\n\n').

display_info :-
	leashes(Leashes),
	echoes(Echoes),
	display_leashes(Leashes),
	display_echoes(Echoes).

display_leashes([]) :- !,
	write(user, ' No ports are being leashed.\n').
display_leashes(Leashes) :-
	'$ notify'(Leashes,' Port(s) being leashed: ').

display_echoes([]) :-
	write(user, ' No ports are being echoed.\n').
display_echoes(Echoes) :-
	'$ notify'(Echoes,' Port(s) being echoed : ').

% ------------------------------------------------------------------------
%			LEASHING
% ------------------------------------------------------------------------
%   1 - CALL			 15 - Four port model
%   2 - SUCCEED			127 - Seven port model
%   4 - REDO			143 - Five port model
%   8 - FAIL
%  16 - TRYMATCH
%  32 - SUCCEEDMATCH
%  64 - FAILMATCH
% 128 - UNIFY

set_echoes :-
	write(user, 'ports to be echoed ? '),
	flush_output(user_output),
	read(Ports),
	echoes(Ports).

set_leashes :-
	write(user, 'ports to be leashed ? '),
	flush_output(user_output),
	read(Ports),
	leashes(Ports).

echoes(Ports) :-
	var(Ports), !,
	recall(echo,Echoes),
	get_ports(128,Echoes,[],Ports).
echoes(all) :- !,
	remember(echo,255).
echoes(none) :- !,
	remember(echo,0),
	remember(leash,0).
echoes(Ports) :-
	recall(echo,Echoes),
	recall(leash,Leashes),
	set_echo_bits(Ports,Leashes,Echoes).

leashes(Ports) :-
	var(Ports), !,
	recall(leash,Leashes),
	get_ports(128,Leashes,[],Ports).
leashes(all) :- !,
	remember(leash,255),
	remember(echo,255).
leashes(none) :- !,
	remember(leash,0).
leashes(Ports) :-
	recall(leash,Leashes),
	recall(echo,Echoes),
	set_leash_bits(Ports,Leashes,Echoes).

set_echo_bits((Port,Ports),Leashes,Echoes) :- !,
	set_echo_bit(Port,Leashes,Echoes,NewLeashes,NewEchoes),
	set_echo_bits(Ports,NewLeashes,NewEchoes).
set_echo_bits(Port,Leashes,Echoes) :-
	set_echo_bit(Port,Leashes,Echoes,NewLeashes,NewEchoes),
	remember(leash,NewLeashes),
	remember(echo,NewEchoes).

set_echo_bit(-Port,Leashes,Echoes,NewLeashes,NewEchoes) :-
	port(Port,PortBits), !,
	NewEchoes is Echoes /\ (\PortBits),
	NewLeashes is Leashes /\ (\PortBits).
set_echo_bit(Port,Leashes,Echoes,Leashes,NewEchoes) :-
	port(Port,PortBits), !,
	NewEchoes is Echoes \/ PortBits.
set_echo_bit(_,Leashes,Echoes,Leashes,Echoes).

set_leash_bits((Port,Ports),Leashes,Echoes) :- !,
	set_leash_bit(Port,Leashes,Echoes,NewLeashes,NewEchoes),
	set_leash_bits(Ports,NewLeashes,NewEchoes).
set_leash_bits(Port,Leashes,Echoes) :-
	set_leash_bit(Port,Leashes,Echoes,NewLeashes,NewEchoes),
	remember(leash,NewLeashes),
	remember(echo,NewEchoes).

set_leash_bit(-Port,Leashes,Echoes,NewLeashes,Echoes) :-
	port(Port,PortBits), !,
	NewLeashes is Leashes /\ (\PortBits).
set_leash_bit(Port,Leashes,Echoes,NewLeashes,NewEchoes) :-
	port(Port,PortBits), !,
	NewLeashes is Leashes \/ PortBits,
	NewEchoes is Echoes \/ PortBits.
set_leash_bit(_,Leashes,Echoes,Leashes,Echoes).

get_ports(0,_,Ports,Ports).
get_ports(PortBits,PortsBits,Portsin,Portsout) :-
	PortBits is PortBits /\ PortsBits,
	port(Port,PortBits), !,
	NewPortBits is PortBits >> 1,
	get_ports(NewPortBits,PortsBits,[Port|Portsin],Portsout).
get_ports(PortBits,PortsBits,Portsin,Portsout) :-
	NewPortBits is PortBits >> 1,
	get_ports(NewPortBits,PortsBits,Portsin,Portsout).

port(call,1).
port(exit,2).
port(redo,4).
port(fail,8).
port(try_match,16).
port(succeed_match,32).
port(fail_match,64).
port(unify,128).
port(c,1).
port(e,2).
port(r,4).
port(f,8).
port(tm,16).
port(sm,32).
port(fm,64).
port(u,128).

test_echo(B,G,leash) :-
	recall(skipping,P), !,	% If we are skipping
	R is B /\ 10,		% and this is a succeed or fail port
	R > 0,			%    and
	not(not(P=G)),		% succedeed/failed goal matches skipped goal
	forget(skipping).	% then stop skipping
test_echo(B,G,Info) :-
	recall(unleashing,P),!,
	recall(echo,L),
	B is L /\ B,
	test_unleash(B,G,P,Info).
test_echo(B,_,leash) :-
	recall(echo,L),		% if we are echoing this port
	B is L /\ B.		% then allow echoing and leashing

test_unleash(B,G,P,leash) :-
	R is B /\ 10,		% if this is a success or failure port
	R > 0,			%    and
	not(not(P=G)), !,	% succeeded/failed goal matches unleashed goal
	forget(unleashing).	% then stop unleashing
test_unleash(_,_,_,unleash).
