/* Copyright (C) 1992 Imperial College */
unix(Command) :-
    '$ primcatch'('?unix?'(Command), unix(Command)).

'?unix?'(Command) :-
    'unix%f'(Command).

cd :-
    unix(cd).

cd(Dir) :-
    'atom%f'(Dir),
    concat('cd ', Dir, Command),
    unix(Command).

ls :-
    unix(ls).

ls(Dir) :-
    'atom%f'(Dir),
    concat('ls ', Dir, Command),
    unix(Command).

pwd :-
    unix(pwd).

vi(File) :-
    edit(File, vi).

edit(File) :-
    recall(editor, Editor),
    edit(File, Editor).

edit(File, Editor) :-
    'atom%f'(File),
    '$edit_name$'(File, Fullname),
    concat(Editor, ' ', Ed),
    concat(Ed, Fullname, Command),
    unix(Command).

'$edit_name$'(File, File) :-
    name(File, Codes),
    on(0'., Codes), !.
'$edit_name$'(File, Fullname) :-
    '$ srcfile'(File, Fullname, pl).

getenv(Name, Value) :-
	'getenv%f'(Name, V),
	name(V,L),
	name(Value,L).

setenv(Name, Value) :- 'setenv%f'(Name, Value).

stat(File, Name, Mod_Time, FileSize, FileModes, UserId, GroupId) :-
	'stat%f'(File, Name, Mod_Time, FileSize, FileModes, UserId, GroupId).
