/*  $Id: global.pl,v 1.1 92/02/25 10:34:58 jan Exp Locker: jan $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1992 University of Amsterdam. All rights reserved.
*/



:- module(pce_global,
	[ pce_global/2				  % Ref x Goal
	]).


:- dynamic
	trap/1.
?- dynamic
	global_goal/3,				  % Ref, Module, Goal
	global_catcher/2.			  % Module, Goal

:- module_transparent
	pce_global/2.


		/********************************
		*            USER PART		*
		********************************/

%	pce_global(+@Reference, +Goal)
%	Register `Goal' to be a goal that creates `@Reference'

pce_global(@Ref, Goal) :-
	context_module(Module),
	global(Ref, Module, Goal).

global(Ref, Module, Goal) :-
	var(Ref), !,
	retractall(global_catcher(Module, Goal)),
	assert(global_catcher(Module, Goal)).
global(Ref, Module, Goal) :-			  % just reconsult
	global_goal(Ref, Module, Goal), !.
global(Ref, Module, Goal) :-
	global_goal(Ref, Module, _G2), !,	  % definition changed
	(   object(@Ref)
	->  gensym(Ref, NewRef),
	    send(@Ref, name_reference, NewRef),
	    format(user_error, ':- pce_global: Renamed @~w into @~w~n',
		   [Ref, NewRef])
	;   retractall(global_goal(Ref, Module, _G2)),
	    assert(global_goal(Ref, Module, Goal))
	).
global(Ref, _M1, _G1) :-
	global_goal(Ref, M2, _G2), !,
	'$warning'('Global object @~w already defined in module ~w',
		   [Ref, M2]).
global(Ref, Module, Goal) :-
	assert(global_goal(Ref, Module, Goal)).


		/********************************
		*            SYSTEM		*
		********************************/

?- send(@pce?exception_handlers, append,
	attribute(undefined_assoc, message(@prolog, trap_ref, @arg1))).

trap(@Ref) :-
	trap_ref(Ref).

trap_ref(Ref) :-
	global_goal(Ref, Module, Goal), !,
	(   Goal = new(Term)
	->  (   Module:new(@Ref, Term)
	    ->  true
	    ;   '$warning'('pce_global/2: Create failed: ~w', [Term]),
	        fail
	    )
	;   Module:apply(Goal, [@Ref])
	->  true
	;   Goal =.. List,
	    append(List, [@Ref], GoalList),
	    GoalTerm =.. GoalList,
	    '$warning'('pce_global/2: Goal failed: ~w:~w', [Module, GoalTerm]),
	    fail
	).
trap_ref(Ref) :-
	global_catcher(Module, Goal),
	Module:apply(Goal, [@Ref]), !.
	    
	
