module_transparent(_).
module(_,_).
context_module(user).
discontiguous(_).

source_location(filename, 0).

use_module(library(M)) :- !,
	load(M).
use_module(M) :-
	load(M).

:(_, Goal) :-
	call(Goal).

'$warning'(Format, Args) :-
	format(user_output, '[WARNING: ', []), 
	format(user_output, Format, Args), 
	format(user_output, ']~n', []).

maplist(F, X, Y) :-
	map(F, X, Y).

checklist(Rel, L) :-
	map(Rel, L).

apply(T, MoreArgs) :-
	T =.. Args,
	append(Args, MoreArgs, CallList),
	Call =.. CallList,
	call(Call).

predsort(Pred, List, Sorted) :-
	qsort(List, Sorted, Pred).

pcedummy :-
	resume,
	pcedummy.

