%** ask
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/

/*
** query_user/4
**	Top level call to query the user.
*/
query_user(Vars, Goal, Number, VN) :-
	get_limits(Vars, Goal, Limits),
	\+ answered_maximum(Limits, Number),
	make_ask_template(Goal, Vars, VN, Template),
	ask_new(Vars, Goal, Limits, Number, VN, Template).

ask_new([], Goal, _, _, _, Template) :-
	!,
	ask_yesno(Template, Answer),	
	deal_with_yesno_answer(Answer, Goal).
ask_new(Vars, Goal, Limits, Number, VN, Template) :-
	get_default_answer(Goal, Vars, Default),
	findall(Vars, been_told(Goal), Known),
	ask_which(Goal, Vars, Told, Limits, Number, VN, Template, Default, Known), 
	!,
	member(Vars, Told).

assert_lemma_list([], _, _) :- !.
assert_lemma_list([Answer|Answers], Vars, Goal) :-
	assert_lemma(Goal, Vars, Answer),
	assert_lemma_list(Answers, Vars, Goal).

deal_with_yesno_answer(yes, Goal) :-
	!,
	assert_lemma(Goal, [], []),
	ask_nomore(Goal, complete).
deal_with_yesno_answer(no, Goal) :-
	!,
	ask_nomore(Goal, complete),
	fail.
deal_with_yesno_answer(stop, Goal) :- 
	ask_nomore(Goal, assumable),
	fail.

ask_which(Goal, Vars, Told, Limits, Number, VarNames, Template, Default, Known) :-
	read_answers(Goal, Vars, VarNames, Stop, Told1, Limits, Number, Template, Default, Known),
	deal_with_which_answers(Stop, Goal, Vars, Told1, Told),
	!.
ask_which(Goal, Vars, Told, Limits, Number, VarNames, Template, Default, Known) :- !,
	ask_which(Goal, Vars, Told, Limits, Number, VarNames, Template, Default, Known).

deal_with_which_answers(complete, Goal, Vars, Told, Told) :-
	assert_lemma_list(Told, Vars, Goal),
	!,
	ask_nomore(Goal, complete).
deal_with_which_answers(stop, Goal, Vars, Told, Told) :- 
	assert_lemma_list(Told, Vars, Goal).
deal_with_which_answers(assumable, Goal, Vars, Told, Told) :-
	assert_lemma_list(Told, Vars, Goal),
	!,
	ask_nomore(Goal, assumable).
deal_with_which_answers(Any, _, _, _, []) :-
	message(['should not be here, which ',Any]).

answered_maximum((_,Max), Number) :-
	integer(Max),
	Number >= Max.

get_limits([], _, (0,1)) :- !.
get_limits(Vars, Goal, Limits) :-
	defined(ask_limits/3),
	copy_term((Goal, Vars), (Goal1, Vars1)),
	ask_limits(Goal1, Vars1, Limits),
	subsumes(Vars1, Vars), !.
get_limits(_, _, (0, '?')).

get_default_answer(Goal, Vars, Default) :-
	defined(default_answer/3),
	copy_term((Goal, Vars), (Goal1, Vars1)),
	default_answer(Goal1, Vars1, Default),
	subsumes(Vars1, Vars),
	Vars1 = Default,
	\+ (been_told(Goal1)).
get_default_answer(_, Vars, Default) :-
	copy_term(Vars, Default),
	set_list(Default, '').
get_default_answer(_, [], []) .

get_suggested_answer(Goal, Vars, Default) :-
	defined(suggested_answer/3),
	copy_term((Goal, Vars), (Goal1, Vars1)),
	suggested_answer(Goal1, Vars1, Default),
	subsumes(Vars1, Vars),
	Vars1 = Default,
	\+ (been_told(Goal1)).
get_suggested_answer(_, Vars, Default) :-
	copy_term(Vars, Default),
	set_list(Default, '').

set_list([], _) :- !.
set_list([Term|T], Term) :- !, set_list(T, Term).

make_ask_template(Goal, Vars, _, Template) :-
	defined(ask_template/3),
	copy_term((Goal, Vars), (Goal1, Vars1)),
	ask_template(Goal1, Vars1, Template),
	subsumes(Vars1, Vars), !.
make_ask_template(Goal, Vars, _, Template) :-
	defined(template/3),
	copy_term((Goal, Vars), (Goal1, Vars1)),
	template(Goal1, Vars1, Template),
	subsumes(Vars1, Vars), !.
make_ask_template(Goal, [], [], ['Is it true that:',Goal,?]) :- !.
make_ask_template(Goal, Vars, VarNames, ['What', VarNames, 'make ', Goal1, 'true?']) :-
	copy_term((Goal, Vars), (Goal1, Vars1)),
	Vars1 = VarNames.

check_validity(Answer, _, Vars) :-
	member(end_of_file, Answer),
	message(['Answer must match:', Vars]),
	!,
	fail.
check_validity(Answer, _, Vars) :-
	\+ (Answer = Vars),
	message(['Answer must match:', Vars]),
	!,
	fail.
check_validity(Answer, Goal, Answer) :-
	been_told(Goal),
	message(['Already given answer:', Answer]),
	!,
	fail.
check_validity(Answer, Goal, Answer) :-
	nonvar(Goal),
	told_status(Goal, complete),
	message(['Negative answerAlready given answer:', Answer]),
	!,
	fail.
check_validity(Answer, Goal, Vars) :-
	defined(valid_answer/2),
	copy_term((Goal,Vars), (Goal1,Answer)),
	clause(valid_answer(Goal1, Answer), Body), !,
	run_goals(Body).
check_validity(_, _, _).

run_goals(Goals) :-
	\+ \+ call(Goals).
run_goals(Goals) :-
	explain_failure(Goals),
	!,
	fail.

/* Verify that there isn't a negative assertion of Goal*/
check_consistency(Goal):-	
	nonvar(Goal), !,
	Goal =.. [Pred|Args], 
	\+ (
		defined('Told-Stop'/3),
		'Told-Stop'(Pred,Args,complete),
		message(['Inconsistency ! The told is ',not(Goal)])
	).

