%** explain_failure
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/

explain_failed_goal(G) :-
	clause(G, B),
	explain_failure(B).

explain_failure(Goals) :-
	delete_last(Goals,  Remainder, Last),
	maybe_explain_failure(Remainder, Last).

maybe_explain_failure(Remainder, Last) :-
	call(Remainder),
	\+ call(Last),
	display_failure_explanation(Remainder, Last).
maybe_explain_failure(Remainder, _) :-
	explain_failure(Remainder).
maybe_explain_failure(_, _) :-
	message(['No more explanations']).

delete_last(true, _, _) :- !, fail.
delete_last((First, (Second, Rest)), (First, Start), Last) :- !,
	delete_last((Second, Rest), Start, Last).
delete_last((First, Last), First, Last) :- !.
	delete_last((First, Last), First, Last) :- !.
delete_last(First, true, First).

display_failure_explanation(Remainder, Last) :-
	dialog('Failure Explanation',50,10,180,490,
		[
			button(150,10,20,60,'Ok'),
			button(150,90,20,60,'Another'),
			button(150,170,20,60,'More'),
			text(10,5,16,300, 'Successful Goal:'),
			text(30,20,32,300, writeq(Remainder)),
			text(70,5,16,160, 'Failed Goal:'),
			text(90,20,32,160, writeq(Last))
		],
		Btn
	), !,
	check_failure_explanation(Btn, Last).

check_failure_explanation(1,_).
check_failure_explanation(3, Goal) :-
	explain_failed_goal(Goal).
check_failure_explanation(3, Goal) :-
	message(['No more explanation for',Goal]), fail.

