%** icp_comp
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/
user_file_type('.sk', skilaki).

user_compile(skilaki, File, List) :-
	icp_translate(File, List).

user_consult(skilaki, File, List) :-
	icp_translate(File, List).

user_undefined(Call) :-
	undefinedHook(Call, Tatom), !,
	call(Tatom).
user_undefined(Goal) :- writeqnl(Goal), system_undefined(Goal).

icp_translate(File, List) :-
	current_input(Fp),
	translateFile(Fp, Xrefs, NewClauses, ''),
	make_icp_pred_list(NewClauses, List, Preds),
	set_prop(File, 'DEFINWIN', Preds).

add_stubs(Xrefs, List1, List) :-
	getCompilerOptions([error_handler], [Error]).

make_icp_pred_list([], [], []) :- !.
make_icp_pred_list([pred(Pred/Arity,Clauses)|Rest],
		[pr(Pred1/Arity1, GClauses)|RestNew], [Pred/Arity|Preds]) :-
	flatten_pred(Clauses, GClauses),
	skilakiName(Pred, Pred1),
	Arity1 is Arity+1,
	!,
	make_icp_pred_list(Rest, RestNew, Preds).

flatten_pred([], []) :- !.
flatten_pred([H|T], [V-GH|GT]) :-
	toground(H, GH, V),
	flatten_pred(T, GT).
