%** lemmas
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/

clear_told :-
	kill('Told-Yes'),
	kill('Told-Stop').

clear_told(Goal) :-
	delete_told(Goal),
	fail.
clear_told(Goal) :-
	delete_told_stop(Goal,_),
	fail.
clear_told(_).

delete_told(Goal) :-
	Goal =.. [Pred|Args],
	defined('Told-Yes'/2),
	retract('Told-Yes'(Pred, Args)).

delete_told_stop(Goal, Type) :-
	Goal =.. [Pred|Args],
	defined('Told-Stop'/3),
	retractall('Told-Stop'(Pred, Args, Type)).

/*
**  told_status/2
**	Relates a goal to the status of the askable goal.
**	Currently the status can be one of the following:
**		complete -	No more solutions to the goal possible
**		incomplete -	User may supply additional solutions.
*/

/* ======================================================================
We have added the first rule of told_status in order to admit the possibility
of "assume true" box in form

If within Args1 there is a var don't ask otherwise ask (it means that is a
"Told-Stop" asserted by "which answer")
If within Args1 there isn't vars ask (it means that it is a "Told-Stop"
asserted by a "yes no answer"
======================================================================*/

/*
told_status(Goal,assumable) :-
	Goal =.. [Pred|Args],
	defined('Told-Stop'/3),
	'Told-Stop'(Pred, Args1, assumable), 
	menu_form(_,ListPred,_,_),
	member(Goal,ListPred),
	test_with_told_stop(Args1),  % in order to spare side effect, see test3
	Args = Args1,!.

test_with_told_stop(Args):- varsin(Args,L),\+ (L=[]).
*/

/* ====================================================================*/

told_status(_,incomplete) :-
	\+ (defined('Told-Stop'/3)), !.
told_status(Goal,incomplete) :-
	Goal =.. [Pred|Args],
	\+ (defined('Told-Stop'/3), numbervars(Goal, 1, _),
		'Told-Stop'(Pred, Args,  _)), !.
told_status(Goal, complete) :-
	Goal =.. [Pred|Args],
	\+ \+ (defined('Told-Stop'/3), numbervars(Goal, 1, _),
		'Told-Stop'(Pred, Args, complete)),!.
told_status(Goal, assumable) :-
	Goal =.. [Pred|Args],
	\+ \+ (defined('Told-Stop'/3), numbervars(Goal, 1, _),
		'Told-Stop'(Pred, Args, assumable)),!.

been_told(Goal) :-
	nonvar(Goal), !,
	Goal =.. [Pred|Args], 
	defined('Told-Yes'/2),
	'Told-Yes'(Pred, Args).
been_told(Goal) :-
	defined('Told-Yes'/2),
	'Told-Yes'(Pred, Args),
	Goal =.. [Pred|Args].

assert_lemma(Goal, Vars, Told) :- 
	Goal =.. [Pred|Args], 
	\+ \+ (
		Vars = Told,
		(
			defined('Told-Yes'/2),
			'Told-Yes'(Pred, Args)
		;
			assert('Told-Yes'(Pred, Args))
		)
	).

ask_nomore(Goal, _) :-
	Goal =.. [Pred|Args],
	\+ \+ (
		defined('Told-Stop'/3),
		numbervars(Goal,1, _),
		retract('Told-Stop'(Pred, Args, _))
	),
	fail.
ask_nomore(Goal, Stop) :-
	Goal =.. [Pred|Args],
	assert('Told-Stop'(Pred, Args, Stop)).

predicateToldVal(Pred, Told) :-
	defined('Told-Yes'/2), !,
	findall(Goal, ('Told-Yes'(Pred, Args), Goal =.. [Pred|Args]), Told).
predicateToldVal(_, []).

predicateToldStop(Pred, Stop) :-
	defined('Told-Stop'/2), !,
	findall(Goal-St, ('Told-Stop'(Pred, Args, St), Goal =.. [Pred|Args]), Stop).
predicateToldStop(_, []).

commit_deletions(Told, Stop, StillTold, StillStop) :-
	remove_all(StillTold, Told, ToldDeleted),
	remove_all(StillStop, Stop, StopDeleted),
	deleteToldList(ToldDeleted),
	deleteStopList(StopDeleted).

deleteToldList([]) :- !.
deleteToldList([Goal|Rest]) :-
	delete_told(Goal), !,
	deleteToldList(Rest).

deleteStopList([]).
deleteStopList([Goal-Stop|Rest]) :-
	delete_told_stop(Goal,Stop), !,
	deleteStopList(Rest).

