%** query
/*******************************************************************************
Copyright (C) 1992, Yannis Cosmadopoulos and Marek Sergot. All rights reserved.
*******************************************************************************/

skilakiQuery :- 
	readQuery(Query,VarNames,Options),
	tohollow(Query,Goal,VarNames,Vars),
	reCompile, 
	set_prop(d_QUERY,d_COUNT,0),
	executeQuery(VarNames,Vars,Goal,Options).

executeQuery(VarNames,Vars,Goal,[IntX,QualX,_,LeashX|_]) :- 
	join_lists(Vars, VarNames, VN),
	write(find_residue(Goal,flags(IntX,QualX,LeashX),Quals,Proof, VN)), nl,
	find_residue(Goal,flags(IntX,QualX,LeashX),Quals,Proof, VN),
	get_prop(d_QUERY,d_COUNT,N),
	NN is N + 1,
	set_prop(d_QUERY,d_COUNT,NN),
	anotherSolution(Goal,VarNames,Vars,Quals,NN,Proof,[IntX,QualX]), !.
executeQuery(_,_,_,_) :- 
	get_prop(d_QUERY,d_COUNT,N),
	noMoreSolutions(N).

showQualifications(Channel, Goal,Quals,VarNames,Vars) :-
	toground((Goal, Quals),(Ggoal,Gquals),Vars,VarNames,UsedNames),
	write('QUALIFICATIONS for:'), writeq(Channel,Ggoal,UsedNames), nl(Channel),
	writeq(Channel,Gquals,UsedNames), !, nl(Channel).

showProof(Channel, Goal,Proof,VarNames,Vars) :-
	toground((Goal,Proof),(Ggoal,Gprf),Vars,VarNames,UsedNames),
	write('PROOF for:'), writeq(Channel,Ggoal,UsedNames), nl(Channel),
	printProof(Gprf,Channel,2,UsedNames), !, nl(Channel).

printProof([], _, _, _) :- !.
printProof([X|Rest], Channel, Tabs, Vars) :- 
	printPartProof(X, Channel, Tabs, Vars), !,
	printProof(Rest, Channel, Tabs, Vars).
printProof(Proof, Channel, Tabs, Vars) :- 
	printPartProof(Proof, Channel, Tabs, Vars).

printPartProof(p(Cond,Index,Rest), Channel, Tabs, Vars) :- 
	tab(Channel,Tabs), 
	writeq(Channel,Cond,Vars),tab(2), write(Channel,'CLAUSE'=Index), nl(Channel),
	Ntabs is Tabs + 2, !,
	printProof(Rest, Channel, Ntabs, Vars).
printPartProof(notp(Vars,Goal,Proofs), Channel, Tabs, Vars) :- 
	tab(Channel,Tabs), 
	write(Channel,'EXISTS '),writeq(Channel,Vars,Vars),
	write(Channel, ' NOT '), writeq(Channel, Goal,Vars), nl(Channel),
	Ntabs is Tabs + 2, !,
	printProof(Proofs, Channel, Ntabs, Vars).
printPartProof(Special, Channel, Tabs, Vars) :- 
	functor(Special, _, 1),
	tab(Channel,Tabs), writeq(Channel,Special,Vars), nl(Channel).

lastQuery(Query,Vars,IntX,QualX,ProofX,LeashX) :-    
	get_prop(d_QUERY,d_FIELDS,(Query,Vars,IntX,QualX,ProofX,LeashX)), !.
lastQuery(true,[],on,on,on,on).

rememberQuery(Query,Vars,IntX,QualX,ProofX,LeashX) :-
	set_prop(d_QUERY,d_FIELDS,(Query,Vars,IntX,QualX,ProofX,LeashX)).

makeAnswerTemplate(VarNames,Vars,Template) :-
	mergeList(VarNames,Vars,ListSub),
	\+ ListSub = [], !,
	de_listify(ListSub,Template).
makeAnswerTemplate(_,_,yes) .

mergeList([],[],[]) :- !.
mergeList([U|X],[_|Y],More) :-
	unnamedVar(U), !,
	mergeList(X,Y,More).
mergeList([U|X],[V|Y],[U=V|More]) :- 
	mergeList(X,Y,More).

noMoreSolutionsText(0, [], no) :- !.
noMoreSolutionsText(0, [_|_], 'No solution') :- !.
noMoreSolutionsText(_, _, 'No more solutions').

