/* Copyright (C) 1992 Imperial College */
#include <limits.h>

#ifdef _ANSI_
#	define PROTO(x)	x
#else
#	define PROTO(x)	()
#endif

#ifndef FAIL
#	define FAIL			0
#	define SUCCESS			1
#	define SUSPEND_FOR_EVENT	4
#endif

#define return_from_read(fd, value)		{read_select(fd); return(value); }
#define return_from_write(fd, value)		{write_select(fd); return(value); }
#define return_from_except(fd, value)		{except_select(fd); return(value); }

#define FD_READ	0
#define FD_WRITE	1
#define FD_EXCEPT	2

#define POLL	0
#define BLOCK	UINT_MAX

#define TIMEOUT_ERR		1
#define MEMORY_ERR		2

#define PARLOG			0
#define PROLOG			1

#define SYSTEM	1
#define USER	2

#define	procptr		void *

#define bool		int

typedef int	(*functptr) PROTO((int fd));

struct fd_request {
	struct fd_request       *next;
	unsigned        time;           /* BLOCK (max integer), poll (0), expira
	tion time */
	int             status;         /* OK    TIMEOUT */
	int             type;           /* FD_READ, FD_WRITE, FD_EXCEPT  */
	int             fd;
	procptr         proc_ptr;       /* ptr to request process */
	};


int	proc_waiting_for_events PROTO(());	/* for deadlock handler		  */
int	set_asynch PROTO((int fd, int type, functptr readfunct, functptr writefunct, functptr exceptfunct));		/* when a asynch device is opened */
int	set_synch PROTO((int fd));		/* 				  */
void	global_read_select PROTO(());
void	read_select PROTO((int fd));
int	c_init_fd_events PROTO(());		/* initialise the events handler  */
struct fd_request	*c_make_fd_request PROTO((int fd, int type, int timeout));
int	c_enqueue_fd_request PROTO((void *ptr, unsigned mach_type));
void	global_write_select PROTO(());
void	write_select PROTO((int fd));
void	global_except_select PROTO(());
void	except_select PROTO((int fd));

/*
 * read_req(Fd, TimeOut, X) :- 
 *	make_request(Fd, read, TimeOut, Req), enqueue_request(Req), read(Fd, X).
 */

bool	make_request PROTO(());		/* make_request(Fd?, Type?, TimeOut?, Req^) */
bool	enqueue_request PROTO(());	/* enqueue_request(Req?)		    */

/*	The I/O primitive, instead of use "return(value)", has to use:
 *			return_from_read(fd, value)	or
 *			return_from_write(fd, value)	or
 *			return_from_except(fd, value)
 *	depending on the kind of operation realised
 */

		/* about write poll	*/

