/* Copyright (C) 1992 Imperial College */
#include "ret.h"
#include "objs.h"
#include "macros.h"
#include "instr.h"
#include "proc.h"


#include "fd_events.h"

#define IsInt(x)	(IsShort(x)||IsLong(x))

static	Word	atom_read, atom_write, atom_except, atom_block, atom_poll;

int make_fd_request();
int enqueue_fd_request();

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
procptr GetParlogProcessPtr()
{
	return(PS);
}
/*---------------------------------------------------------------------------*/
resume_parlog_proc(proc)
procptr proc;
{
	enqueue_process(proc);
}
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
int init_fd_events()
{
	if (c_init_fd_events() == -1)
		return(FAIL);

	atom_read = make_atom("read");
	atom_write = make_atom("write");
	atom_except = make_atom("except");
	atom_block = make_atom("block");
	atom_poll = make_atom("poll");

	define_c_predicate("$make_fd_request", 		4, make_fd_request, 		enter_c, 1);
	define_c_predicate("$enqueue_fd_request", 	1, enqueue_fd_request, 		enter_c, 1);

	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
/*	make_fd_request(fd?, Op?, TimeOut?, Req^).				*/
/*---------------------------------------------------------------------------*/
int make_fd_request(Args)
Word *Args;
{
	void *req;
	unsigned	ti, ty;

	wait_for_argument(A0);
	if (! IsInt(A0)) {
		bu_error(A2, "make_fd_request/4: 1st arg incorrect");
		return(FAIL); }
	wait_for_argument(A1);
	if (A1 == atom_read)
		ty = FD_READ;
	else if (A1 == atom_write)
		ty = FD_WRITE;
	else if (A1 == atom_except)
		ty = FD_EXCEPT;
	else {
		bu_error(A2, "make_fd_request/4: 2nd arg incorrect");
		return(FAIL); }		
	wait_for_argument(A2);
	if (A2 == atom_block)
		ti = BLOCK;
	else if (A2 == atom_poll) 
		ti = POLL;
	else if (IsInt(A2))
		ti = int_val(A2);
	else {
		bu_error(A2, "make_fd_request/4: 3rd arg incorrect");
		return(FAIL); }
	if (req = c_make_fd_request(int_val(A0), ty, ti)) {
		return(unify(A3, make_int((int)req))); }
	return(FAIL);
}
/*---------------------------------------------------------------------------*/
/* A0 is assumed to be an integer */
int enqueue_fd_request(Args)
Word *Args;
{
	wait_for_argument(A0);
	return(c_enqueue_fd_request((void *)int_val(A0),PARLOG));
}
/*---------------------------------------------------------------------------*/

