/* Copyright (C) 1992 Imperial College */
#include <limits.h>

#include "primitives.h"

#include "fd_events.h"

extern	symbpo define_symbol();
static	symbpo	atom_read, atom_write, atom_except, atom_block, atom_poll;

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
procptr GetPrologProcessPtr()
{
	return(TH);
}
/*---------------------------------------------------------------------------*/
resume_prolog_proc(proc)
procptr proc;
{
	add_to_runq(proc,FALSE);
}
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
bool
pr_init_fd_events()
{
	if (c_init_fd_events() == -1)
		return(FAIL);

	atom_read = define_symbol("read");
	atom_write = define_symbol("write");
	atom_except = define_symbol("except");
	atom_block = define_symbol("block");
	atom_poll = define_symbol("poll");

	return(SUCCEED);
}
/*---------------------------------------------------------------------------*/
bool
pr_make_fd_request()
{
	register cellpo	arg1 = &A[1],
			arg2 = &A[2],
			arg3 = &A[3],
			arg4 = &A[4];
	void *req;
	unsigned	ti, ty;

	delnk(arg1);
	delnk(arg2);
	delnk(arg3);
	delnk(arg4);

	if (NotInt(arg1))
		return(FAIL);
	if (IsSymb(arg2))
		if (samesymb(symbvl(arg2), atom_read))
			ty = FD_READ;
		else if (samesymb(symbvl(arg2), atom_write))
			ty = FD_WRITE;
		else if (samesymb(symbvl(arg2), atom_except))
			ty = FD_EXCEPT;
		else
			return(FAIL);		
	else
		return(FAIL);
	if (IsSymb(arg3))
		if (samesymb(symbvl(arg3), atom_poll))
			ti = POLL;
		else if (samesymb(symbvl(arg3), atom_block))
			ti = BLOCK;
		else
			return(FAIL);		
	else if (IsInt(arg3))
		ti = intvl(arg3);
	else
		return(FAIL);
	if (NotVar(arg4))
		return(FAIL);
	if (req = c_make_fd_request(intvl(arg1), ty, ti)) {
		mkreset(arg4);
		mkint(arg4, (int)req);
		return(SUCCEED); }
	return(FAIL);
}
/*---------------------------------------------------------------------------*/
/* A[1] is assumed to be an integer */
bool
pr_enqueue_fd_request()
{
	register cellpo	arg1 = &A[1];

	return(c_enqueue_fd_request((void *)intvl(arg1),PROLOG));
}
/*---------------------------------------------------------------------------*/

