include(../../install/Makefile.incl)

OBJECTS	= mbx_kernel.o mbx_prolog.o mbx_parlog.o
CPPFLAGS= -I../prolog -I../parlog -I../fd_events -DFULL_REPORT_ERROR -DHERMES
SERVER	= mbx_server.c
DIFFS	= *.[ch]

TARGET	= mbx_server

all:: $(OBJECTS) $(TARGET)
	m4localinstall(bin/m4arch, $(TARGET))
	m4localinstall(prolog/m4arch, $(OBJECTS))

makefiles::

clean::
	$(RM_CMD) $(TARGET) $(OBJECTS)

diffs::
	m4diff(src/mailbox)

depend::
	$(MAKEDEPEND) -- $(CFLAGS) $(CPPFLAGS) -- *.c

changequote(,)
$(TARGET): $(SERVER)
	$(CC) $(CFLAGS) $(CPPFLAGS) $(LDFLAGS) $(SERVER) -o $(TARGET)
	$(CHMOD) `echo $(INSTBINFLAGS) | $(CUT) -d" " -f2` $(TARGET)
