/* Copyright (C) 1992 Imperial College */
#include <stdio.h>
#include <limits.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/time.h>
#include <string.h>
#include <netdb.h>
#include <netinet/in.h>

#include "mbx_interface.h"

/*
 *		ATTENTION:
 *			It's important to have all machines with the same or very aprox
 *			time. Because of TimeOut between different machines.
 *			If not, could be possible that each machine kept the time
 *			difference between those machines, and set up the timeout in
 *			case of remote request.
 */

/*
 *	Defines & structures to init the connections
 */
#define CONNECT_LIST		2
#define CONNECT_MSG		0
#define MTM_CONN_MSG		3

#define LIST_SIZE(buf)		(sizeof(struct list_conn)-sizeof(struct mi)+(((struct list_conn *)buf)->number_of_mach*sizeof(struct mi)))

struct msg_conn {
	int type;
	struct sockaddr_in mach_add;
	};
struct msg_mtm_conn {
	int type;
	int mach_number;
	};
struct mi {
	int mach_number;
	struct sockaddr_in mach_add;
	};
struct list_conn {
	int type;
	int number_given;
	int number_of_mach;
	struct mi mach_inf[1];
	};
/*
 *
 */
#ifdef GETSERVBYNAME
	struct servent spp;
#	define getservbyname(x,y)	(spp.s_port = 5000, &spp)
#endif

#define mbx_assign(target, source)		((target) = (source))
#define int_value_of_dataword(data)		(*((int*)(data)->buff))

#define is_a_parlog_process(proc_ptr)		(GET_PROC_TYPE(proc_ptr) == PARLOG_MACH)
#define is_a_prolog_process(proc_ptr)		(GET_PROC_TYPE(proc_ptr) == PROLOG_MACH)

#define TRUE				1
#define	FALSE				0

#define MAX_MACH		64
#define MAX_MBX			64
#define MBX_SERVER		0

#define	SERVICELEN		32
#define MACHNAMELEN		64

#ifdef USE_STACK
	PRIVATE unsigned stack[MAX_MBX];
	PRIVATE unsigned stackptr = 0;
#	define init_stack		(stackptr = 0)
#	define stack_empty		(stackptr == 0)
#	define push_stack(n)	(stack[stackptr++] = n)
#	define pop_stack(n)	(n = stack[--stackptr])
#endif

#define IS_DB_OPERATION(op)	(((op)==GETID)||((op)==GETNAME)||	\
							 ((op)==INIT)||((op)==GETIDNAME)||	\
							 ((op)==CLOSEDBPTR))

/*
 *		The next values are to send remote link msg 
 */
#define	SETOUT			0x00001000
#define	SETINC			0x00002000
#define	BREAKOUT		0x00003000
#define	BREAKINC		0x00004000

#define IS_LINK_MSG(op)	((op)&0x0000F000)

/*
 *		Mailbox Macros
 */
#define MACH_MASK			0x007F0000
#define MACH_SHIFT			16
#define NUMB_MASK			0x0000FFFF
#define NUMB_SHIFT			0
#define MK_MBX(numb)		(((machine_number)<<MACH_SHIFT)|((numb)<<NUMB_SHIFT))
#define GET_MBX_MACH(mbx)	(((mbx) & MACH_MASK) >> MACH_SHIFT)
#define GET_MBX_NUMB(mbx)	(((mbx) & NUMB_MASK) >> NUMB_SHIFT)

/*
 *		Process Macros
 */
#define PARLOG_MACH		0x00000000
#define PROLOG_MACH		0x80000000

#define PT_MASK			0x80000000
#define	PMACH_MASK		0x7F000000
#define PMACH_SHIFT		24
#define PPROC_MASC		0x00FFFFFF
#define PPROC_SHIFT		0
#define MK_PARLOG_PROC_PTR(proc)	((procptr)((PARLOG_MACH)|((machine_number)<<PMACH_SHIFT)|(((int)(proc))<<PPROC_SHIFT)))
#define MK_PROLOG_PROC_PTR(proc)	((procptr)((PROLOG_MACH)|((machine_number)<<PMACH_SHIFT)|(((int)(proc))<<PPROC_SHIFT)))
#define GET_PROC_NUMB(proc)		((procptr)(((unsigned)(proc)&PPROC_MASC)>>PPROC_SHIFT))
#define GET_PROC_MACH(proc)		(((unsigned)(proc)&PMACH_MASK)>>PMACH_SHIFT)
#define GET_PROC_TYPE(proc)		((unsigned)(proc)&PT_MASK)

/*
 *		Data Base Macros
 */
#define	DBMACH_MASK		0x007F0000
#define DBMACH_SHIFT		16
#define DBPTR_MASC		0x0000FFFF
#define DBPTR_SHIFT		0
#define MK_DBPTR(ptr)	(((machine_number)<<DBMACH_SHIFT)|(((ptr)&DBPTR_MASC)<<DBPTR_SHIFT))
#define GET_DBPTR(ptr)	(((ptr)&DBPTR_MASC)>>DBPTR_SHIFT)
#define GET_DBMACH(ptr)	(((ptr)&DBMACH_MASK)>>DBMACH_SHIFT)
/*
 *
 */

#define time_conversion(x)		(((x)==POLL)?POLL:((x)==BLOCK)?BLOCK:((x)+time(NULL)))

#define IS_LOCAL_MBX(mbx_num)		(GET_MBX_MACH(mbx_num) == machine_number)
#define IS_LOCAL_PROCESS(proc)		(GET_PROC_MACH(proc) == machine_number)

/*
 *			MAILBOX STATUS
 *								|....|....|....|....|
 */

#define DEFAULT_ST	0x00000000
#define MBXLOCKEDN	0x00001000
#define MBXLOCKEDO	0x00000800
#define MBXLINKED	0x00000400

/*
 *	#define MBXREADERR	0x00000200
 *	#define MBXWRITERR	0x00000100
 *	#define MBXERROR	0x000000FF
 */

#define SET_LOCKN(st)			(MBXLOCKEDN | (st))
#define SET_UNLOCKN(st)			(~MBXLOCKEDN & (st))
#define SET_LOCKO(st)			(MBXLOCKEDO | (st))
#define SET_UNLOCKO(st)			(~MBXLOCKEDO & (st))
#define SET_LINK(st)			(MBXLINKED | (st))
#define SET_UNLINK(st)			(~MBXLINKED & (st))
/*
 *	#define SET_ERROR(st,err,type)	((err) | (st) | (type))
 */
#define IS_LOCKEDN(st)			((st) & MBXLOCKEDN)
#define IS_LOCKEDO(st)			((st) & MBXLOCKEDO)
#define IS_LINKED(st)			((st) & MBXLINKED)
/*
 *	#define IS_READ_ERR(st)			((st) & MBXREADERR)
 *	#define IS_WRITE_ERR(st)		((st) & MBXWRITERR)
 *	#define GET_ERROR(st)			((st) & MBXERROR)
 */

/*
 *				MAILBOX	PERMISS
 *							|..uu|ggoo|
 *							|  rw|rwrw|
 */
 
#define USER_READ		0x00000020
#define USER_WRITE		0x00000010
#define GROUP_READ		0x00000008
#define GROUP_WRITE		0x00000004
#define OTHERS_READ		0x00000002
#define OTHERS_WRITE	0x00000001
#define DEFAULT_PERM	(USER_READ | USER_WRITE | GROUP_WRITE | OTHERS_WRITE)

/*
 *
 */
#define	IS_REMOTE_REQUEST(mbx)			IS_LOCAL_MBX(mbx)
#define	IS_REMOTE_REPLY(proc_ptr)		IS_LOCAL_PROCESS(proc_ptr)

/*
 *		PERMISS MACROS
 */
#define user_permiss(index,userid,pm)					\
		((euid == (userid))&&(mailboxes[index]->permiss & (pm)))
#define group_permiss(index,groupid,pm)					\
		((egid == (groupid))&&(mailboxes[index]->permiss & (pm)))
#define others_permiss(index,pm)						\
		(mailboxes[index]->permiss & (pm))
#define read_ps(index,ps)								\
		(mailboxes[index]->read_passwd == (ps))
#define write_ps(index,ps)								\
		(mailboxes[index]->write_passwd == (ps))
#define read_permiss(index,rpwd,userid,groupid)			\
		((user_permiss(index,userid,USER_READ) ||		\
		  group_permiss(index,groupid,GROUP_READ) ||	\
		  others_permiss(index,OTHERS_READ)) &&			\
		 read_ps(index,rpwd))
#define write_permiss(index,wrwd,userid,groupid)		\
		((user_permiss(index,userid,USER_WRITE) ||		\
		  group_permiss(index,groupid,GROUP_WRITE) ||	\
		  others_permiss(index,OTHERS_WRITE)) &&		\
		 write_ps(index,wrwd))


#define is_linked(mbx)		(IS_LINKED(mailboxes[mbx]->status))
#define is_locked(mbx,type)	(((type)==NORMAL) ?							\
								(IS_LOCKEDN(mailboxes[mbx]->status)) :	\
								(IS_LOCKEDO(mailboxes[mbx]->status)))
#define is_empty(mbx,type)	(mailboxes[mbx]?(((type)==NORMAL) ?			\
											(! mailboxes[mbx]->data) :	\
											(! mailboxes[mbx]->oob_data)):TRUE)

#define	send_allowed(mbx, type)		1
#define	recv_allowed(mbx, type)		((!is_empty((mbx),(type)))&&(!is_locked((mbx),(type))))
#define	look_allowed(mbx, type)		((!is_empty((mbx),(type)))&&(!is_locked((mbx),(type))))
#define	commit_allowed(mbx, type)	(is_locked((mbx),(type)))
#define	discard_allowed(mbx, type)	(is_locked((mbx),(type)))
#define	close_allowed(mbx)			((!is_locked((mbx),NORMAL))&&(!is_locked((mbx),OOB)))
#define	link_i_allowed(mbx)			((!is_locked((mbx),NORMAL))&&(!is_locked((mbx),OOB)))
#define	link_o_allowed(mbx)			1
#define	unlink_i_allowed(mbx)		1
#define	unlink_o_allowed(mbx)		1
#define	getlinks_allowed(mbx)		1
#define	clear_allowed(mbx, type)	(!is_locked((mbx),(type)))
#define	bind_allowed(mbx)			1

#define	lock_mbx(mbx,type)									\
			(((type)==NORMAL) ?							\
				(mailboxes[mbx]->status = SET_LOCKN(mailboxes[mbx]->status)) :	\
				(mailboxes[mbx]->status = SET_LOCKO(mailboxes[mbx]->status)))
#define	unlock_mbx(mbx,type)										\
			(((type)==NORMAL) ?								\
				(mailboxes[mbx]->status = SET_UNLOCKN(mailboxes[mbx]->status)) :	\
				(mailboxes[mbx]->status = SET_UNLOCKO(mailboxes[mbx]->status)))

#define push(head,data)		push_l((struct list **)(head),(struct list *)(data))
#define pop(head)			pop_l((struct list **)(head))
#define enqueue(head,data)	enqueue_l((struct list **)(head),(struct list *)(data))
#define dequeue(head)		dequeue_l((struct list **)(head))
#define look_queue(head)	look_queue_l((struct list *)(head))

#define	enqueue_data(mbx,type,req)								\
			(((type)==NORMAL) ?							\
				enqueue(& mailboxes[mbx]->data, alloc_data((req)->data)) :	\
				enqueue(& mailboxes[mbx]->oob_data, alloc_data((req)->data)))
#define	dequeue_data(mbx,type,req)								\
			{struct data_list *dl;							\
			 dl = (((type)==NORMAL) ?						\
					(struct data_list *)dequeue(& mailboxes[mbx]->data) :	\
					(struct data_list *)dequeue(& mailboxes[mbx]->oob_data));\
			 mbx_assign((req)->data, dl->data);					\
			 free(dl); }
#define	dequeue_data2(mbx,type)									\
			{struct data_list *dl;							\
			 dl = (((type)==NORMAL) ?						\
					(struct data_list *)dequeue(& mailboxes[mbx]->data) :	\
					(struct data_list *)dequeue(& mailboxes[mbx]->oob_data));\
			 remove_dw(dl->data);							\
			 free(dl); }
#define	get_data(mbx,type,req)									\
			{struct data_list *dl;							\
			 dl = (((type)==NORMAL) ?						\
					(struct data_list *)look_queue(mailboxes[mbx]->data) :	\
					(struct data_list *)look_queue(mailboxes[mbx]->oob_data));\
			 mbx_assign((req)->data, dl->data);					\
			 inc_dw_ref_count((req)->data);						\
			}

#define	enqueue_local_request(req)								\
			enqueue(& local_mbxs[GET_MBX_NUMB(req->mbx)], req)
#define	enqueue_remote_request(req)								\
			push(& remote_mbxs[GET_MBX_MACH(req->mbx)], req)
#define	enqueue_db_request(req)									\
			push(& db_req, req)

struct data_list {
	struct data_list *next;
	data_word data;
	};
struct link_list {
	struct link_list *next;
	unsigned mbx;
	};
struct mailbox {
	unsigned status;
	unsigned permiss;
	unsigned read_passwd;
	unsigned write_passwd;
	struct data_list *data;			/*	queue	*/
	struct data_list *oob_data;		/*	queue	*/
	struct link_list *inc_links;	/*	list	*/
	struct link_list *out_links;	/*	list	*/
	};

struct db_req {
	unsigned	operation;
	procptr		proc_ptr;
	unsigned	mbx;
	unsigned	permiss;
	unsigned	read_passwd;
	unsigned	write_passwd;
	int			euid;
	int			egid;
	char		service[SERVICELEN];
	};

struct db_res {
	procptr		proc_ptr;
	unsigned	status;
	unsigned	mbx;
	char		service[SERVICELEN];
	};

struct list {				/* Generic List Structure	*/
	struct list *next;
	/*
	 *	Specific Datas
	 */
	};

/*
 *	Functions Definitions
 */

/*
 *		low.c
 */

PRIVATE struct data_list	*alloc_data();
PRIVATE struct 	link_list	*alloc_link();
PRIVATE int			resume_queue_req_timeout();
PRIVATE int			resume_list_req_timeout();
PRIVATE struct link_list	*rem_link();
PRIVATE struct mbx_request	*get_process();
PRIVATE struct mbx_request	*get_first_op();
PRIVATE struct mbx_request	*get_all_op();
PRIVATE int			resume_all_request();
PRIVATE int			resume_all_list_request();
PRIVATE int			empty_list_l();
PRIVATE int			push_l();
PRIVATE struct list		*pop_l();
PRIVATE int			enqueue_l();
PRIVATE struct list		*dequeue_l();
PRIVATE struct list		*look_queue_l();

/*
 *		mbx.c
 */

PRIVATE int			set_out_link();
PRIVATE int			break_out_link();
PRIVATE int			set_inc_link();
PRIVATE int			break_inc_link();
PRIVATE int			resume_process();
PRIVATE int			resume_local_request();
PRIVATE int			local_mbx_operation();

/*
 *		msg.c
 */

PRIVATE int	send_rem_set_out_link();
PRIVATE int	send_rem_break_out_link();
PRIVATE int	send_rem_set_inc_link();
PRIVATE int	send_rem_break_inc_link();
PRIVATE int	send_remote_request();
PRIVATE int	send_res_msg();
PRIVATE int	process_normal_msg();
PRIVATE int	process_OOB_msg();
PRIVATE int	process_server_msg();
PRIVATE int	send_close_mbx_db_msg();
PRIVATE int	send_bind_msg();
PRIVATE int	send_getid_msg();
PRIVATE int	send_getname_msg();
PRIVATE int	send_init_msg();
PRIVATE int	send_getidname_msg();
PRIVATE int	send_closedbptr_msg();
