/* Copyright (C) 1992 Imperial College */
#include <sys/types.h>
#include <sys/times.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <netdb.h>
#include <string.h>

#define USE_STACK
#include "mbx.h"
#include "fd_events.h"

PRIVATE int get_mtm_conn_msg();

PRIVATE	int mbx_initialise = FALSE;
PRIVATE	int sock_list[MAX_MACH];
PRIVATE	int machine_number;
PRIVATE	int euid;
PRIVATE	int egid;

PRIVATE	struct mailbox *mailboxes[MAX_MBX];
PRIVATE	int mbx_count = 0;

PRIVATE	struct mbx_request *local_mbxs[MAX_MBX];
PRIVATE	struct mbx_request *remote_mbxs[MAX_MACH];
PRIVATE	struct mbx_request *db_req;

PRIVATE	int mbx_init_count = 0;

PRIVATE	char *oper[] = {
	"OPEN", "SEND", "LSEND", "RECV", "LOOK", "COMMIT", "DISCARD", "CHECKRECV",
	"CLOSE", "LINK_I", "LINK_O", "UNLINK_I", "UNLINK_O", "GETLINKS",
	"CLEAR", "BIND", "GETID", "GETNAME", "INIT", "GETIDNAME", "CLOSEDBPTR"
	};
PRIVATE	char *st[] = {
	"INIT", "OK", "TIMEOUT", "MCLOSED", "PERMISS", "LINKED", "LOCKED",
	"MEMPTY", "SEQUENCE", "CLOSED_MACH", "TCP_ERR", "DUPLICATE_SERV",
	"SERV_NOTFOUND", "ID_NOTFOUND", "ERROR", "EUNIFY"
	};


/*---------------------------------------------------------------------------*/

/*
 *				init.c
 *
 *	Functions to init the connection with the server and the other machines
 */

/*---------------------------------------------------------------------------*/
PRIVATE	int close_mach(mach_number)
int mach_number;
{
	set_synch(sock_list[mach_number]);
	close(sock_list[mach_number]);
	sock_list[mach_number] = 0;
	if (mach_number == MBX_SERVER)
		resume_all_list_request(& db_req, CLOSED_MACH);
	else
		resume_all_list_request(& remote_mbxs[mach_number], CLOSED_MACH);

	return(0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int process_connections(sock)
int sock;
{
	int i;

	if (process_normal_msg(sock) == 0) {
		for (i=0; /* (i< MAX_MACH)&& */ (sock_list[i] != sock); ++i)
			;
/*		if (i< MAX_MACH)	*/
			close_mach(i);
		return_from_read(sock,0); }
	return_from_read(sock, 0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int process_OOB_connections(sock)
int sock;
{
	int i;

	if (process_OOB_msg(sock) == 0) {
		for (i=0; /* (i< MAX_MACH)&& */ (sock_list[i] != sock); ++i)
			;
/*		if (i< MAX_MACH)	*/
			close_mach(i);
		return_from_except(sock, 0); }
	return_from_except(sock, 0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int process_server_connection(sock)
int sock;
{
	int i;

	if (process_server_msg(sock) == 0) {
		for (i=0; /* (i< MAX_MACH)&& */ (sock_list[i] != sock); ++i)
			;
/*		if (i< MAX_MACH)	*/
			close_mach(i);
		return_from_read(sock, 0); }
	return_from_read(sock, 0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int accept_new_connections(sock)
int sock;
{
	int new_sock,mach_number,nbytes;
	struct msg_mtm_conn buff;
	
	if ((new_sock = accept(sock, (struct sockaddr *)0, (int *)0)) == -1) {
		perror("accept");
		return(-1); }
	set_synch(new_sock);
	if ((nbytes=recv(new_sock,(char*)&buff,sizeof(struct msg_mtm_conn),0))<0) {
		perror("receiving mtm connect message");
		return_from_read(sock, -1); }
	if (nbytes == 0) {
		close(new_sock);
		return_from_read(sock, 0); }
	if (get_mtm_conn_msg(&buff, &mach_number) < 0) {
		return_from_read(sock, -1); }
	if (sock_list[mach_number] > 0) {
		set_synch(sock_list[mach_number]);
		close(sock_list[mach_number]); }
	sock_list[mach_number] = new_sock;
	set_asynch(sock_list[mach_number],SYSTEM,process_connections,NULL,process_OOB_connections);
	return_from_read(sock, 0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int getserveradd(machine,service,add)
char *machine, *service;
struct sockaddr_in *add;
{
	struct servent *sp;
	struct hostent *hp;
	
	if ((hp = gethostbyname(machine)) == NULL) {
		fprintf(stderr,"%s: unknown host\n", machine);
		return(-1); }
	if ((sp = getservbyname(service, "tcp")) == NULL) {
		fprintf(stderr,"%s: unknown service\n", service);
		return(-1); }
	bcopy((char *)hp->h_addr, (char *)&(add->sin_addr), hp->h_length);
	add->sin_port = sp->s_port;
	add->sin_family = AF_INET;
	return(0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int getsockadd(sock, add)
int sock;
struct sockaddr_in *add;
{
	int length = sizeof(struct sockaddr_in);
	struct hostent *hp;
	char mach_name[MACHNAMELEN];

	if (getsockname(sock, (struct sockaddr *)add, &length) < 0) {
		return(-1); }
	if (gethostname(mach_name, BUFCHARSIZE) < 0) {
		return(-1); }
	if ((hp = gethostbyname(mach_name)) == NULL) {
		return(-1); }
	bcopy((char*)(hp->h_addr), (char*)&(add->sin_addr), hp->h_length);
	return(0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int get_conn_list(buff, machine_number, sock_list, add_list)
struct list_conn *buff;
int *machine_number;
int *sock_list;
struct sockaddr_in *add_list;
{
	int i;

	if (buff->type != CONNECT_LIST)
		return(-1);
		
	*machine_number = buff->number_given;
	for (i=0; i<buff->number_of_mach; ++i) {
		bcopy(&buff->mach_inf[i].mach_add, &add_list[buff->mach_inf[i].mach_number], sizeof(struct sockaddr_in));
		if ((sock_list[buff->mach_inf[i].mach_number] = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
			perror("opening a socket");
			return(-1); }
		}
	return(0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int mk_conn_msg(buff, add)
struct msg_conn *buff;
struct sockaddr_in *add;
{
	buff->type = CONNECT_MSG;
	bcopy((char*)add,(char*)&buff->mach_add,sizeof(struct sockaddr_in));
	
	return(0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int get_mtm_conn_msg(buff, mach_number)
struct msg_mtm_conn *buff;
int *mach_number;
{
	if (buff->type != MTM_CONN_MSG) {
		return(-1); }
	*mach_number = buff->mach_number;
	
	return(0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int mk_mtm_conn_msg(buff, mach_number)
struct msg_mtm_conn *buff;
int mach_number;
{
	buff->type = MTM_CONN_MSG;
	buff->mach_number = mach_number;
	
	return(0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int connect_to(sock_list,add_list,mach_number)
int *sock_list;
struct sockaddr_in *add_list;
int mach_number;
{
	int i;
	int length = sizeof(struct sockaddr_in);
	struct msg_mtm_conn buff;

	for (i=1; i<MAX_MACH; ++i)
		if ((i != mach_number) && (sock_list[i] > 0)) {
			if (connect(sock_list[i], (struct sockaddr *)&(add_list[i]), length) < 0) {
				close(sock_list[i]);
				sock_list[i] = 0;
				perror("connecting");
				}
			else {
				if (mk_mtm_conn_msg(&buff,mach_number) < 0) {
					fprintf(stderr,"Error\n"); }
				if (send(sock_list[i], (char*)&buff, sizeof(struct msg_mtm_conn), 0) < 0) {
					perror("sending mtm connect message"); }
				}
			}
	return(0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int set_asynch_mode(sock_list,mach_number)
int *sock_list;
int mach_number;
{
	int i;

	set_asynch(sock_list[MBX_SERVER],SYSTEM,process_server_connection,NULL,NULL);
	for (i=1; i<MAX_MACH; ++i)
		if (i == mach_number)
			set_asynch(sock_list[i],SYSTEM,accept_new_connections,NULL,NULL);
		else if (sock_list[i] > 0)
			set_asynch(sock_list[i],SYSTEM,process_connections,NULL,process_OOB_connections);
	return(0);
}
/*---------------------------------------------------------------------------*/
PRIVATE	int init_connection(machine,service)
char *machine, *service;
{
	struct sockaddr_in add_list[MAX_MACH];
	int length = sizeof(struct sockaddr_in);
	int buff[BUFINTSIZE];

	if (getserveradd(machine,service,&add_list[0]) < 0) {
		return(-1); }
	if ((sock_list[MBX_SERVER] = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror("opening a socket");
		return(-1); }
	if (connect(sock_list[MBX_SERVER], (struct sockaddr *)&(add_list[0]), length) < 0) {
		perror("connecting to server");
		return(-1); }
	if (recv(sock_list[MBX_SERVER], (char*)buff, BUFCHARSIZE, 0) < 0) {
		perror("receiving connect list");
		return(-1); }
	if (get_conn_list((struct list_conn*)buff, &machine_number, sock_list, add_list) < 0) {
		return(-1); }
	if ((sock_list[machine_number] = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror("opening a socket");
		return(-1); }
	listen(sock_list[machine_number],5);
	if (getsockadd(sock_list[machine_number],&(add_list[machine_number])) < 0) {
		return(-1); }
	if (mk_conn_msg((struct msg_conn*)buff, &(add_list[machine_number])) < 0) {
		return(-1); }
	if (send(sock_list[MBX_SERVER], (char*)buff, sizeof(struct msg_conn), 0) < 0) {
		perror("sending connect message");
		return(-1); }
	if (connect_to(sock_list,add_list,machine_number) < 0) {
		return(-1); }
	if (set_asynch_mode(sock_list,machine_number) < 0) {
		return(-1); }
	return(0);
}
/*---------------------------------------------------------------------------*/
PUBLIC	int init_mbx(machine,service)
char *machine, *service;
{
	if (mbx_initialise) {
		return(SUCCESS); }
	euid = geteuid();
	egid = getegid();
	c_init_fd_events();
	if (init_connection(machine,service) < 0)
		return(FAIL);
	mbx_initialise = TRUE;
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------*/

/*
 *				low.c
 *
 *			Low level functions
 */

/*---------------------------------------------------------------------------*/
PUBLIC data_word alloc_dataword(size)
int size;
{
	data_word ptr;

	if (ptr = (data_word)malloc(size)) {
		ptr->size = size;
		ptr->links = 1; }
	return(ptr);
}
/*---------------------------------------------------------------------------*/
PUBLIC data_word alloc_int_dataword(num)
int num;
{
	data_word ptr;

	if (ptr = (data_word)malloc(3*sizeof(int))) {
		ptr->size = 3*sizeof(int);
		ptr->links = 1;
		int_value_of_dataword(ptr) = num; }
	return(ptr);
}
/*---------------------------------------------------------------------------*/
PUBLIC data_word alloc_str_dataword(str)
char *str;
{
	data_word ptr;

	if (ptr = (data_word)malloc(2*sizeof(int)+strlen(str)+1)) {
		ptr->size = 2*sizeof(int)+strlen(str)+1;
		ptr->links = 1;
		strcpy(ptr->buff,str); }
	return(ptr);
}
/*---------------------------------------------------------------------------*/
PUBLIC inc_dw_ref_count(data)
data_word data;
{
	if (data)
		++data->links;
}
/*---------------------------------------------------------------------------*/
#define d_remove_dw(data)	{ if ((data)&&(!(--(data)->links))) free(data); }
/*---------------------------------------------------------------------------*/
PUBLIC remove_dw(data)
data_word data;
{
	d_remove_dw(data);
}
/*---------------------------------------------------------------------------*/
PUBLIC remove_dataword(req)
struct mbx_request	*req;
{
	d_remove_dw(req->data);
	req->data = NULL;
}
/*---------------------------------------------------------------------------*/
PRIVATE data_word mk_links_dw(out_links, inc_links)
struct link_list *out_links, *inc_links;
{
	return(alloc_str_data("Links_list"));	/* ATTENTION */
}
/*---------------------------------------------------------------------------*/
PRIVATE struct	data_list	*alloc_data(data)
data_word	data;
{
	struct	data_list *rr;

	if (rr = (struct data_list *)malloc(sizeof(struct data_list))) {
		rr->data = data; }
	return(rr);

}

/*---------------------------------------------------------------------------*/
PRIVATE struct	link_list	*alloc_link(mbx)
unsigned	mbx;
{
	struct	link_list *rr;

	if (rr = (struct link_list *)malloc(sizeof(struct link_list))) {
		rr->mbx = mbx; }
	return(rr);

}
/*---------------------------------------------------------------------------*/
PRIVATE int resume_queue_req_timeout(headptr, timeout)
struct mbx_request **headptr;
int timeout;
{
	struct mbx_request *ptr,*ptr1;

	if (*headptr) {
		ptr = *headptr;
		while (ptr->next != *headptr) {
			if (ptr->next->timeout <= timeout) {
				ptr1 = ptr->next;
				ptr->next = ptr1->next;
				ptr1->status = TIMEOUT;
				resume_process(ptr1); }
			ptr = ptr->next; }
		if (ptr->next->timeout <= timeout) {
			ptr1 = ptr->next;
			if (ptr1 == ptr)
				*headptr = NULL;
			else {
				ptr->next = ptr1->next;
				*headptr = ptr; }
			ptr1->status = TIMEOUT;
			resume_process(ptr1); }
		}
	return;
}
/*---------------------------------------------------------------------------*/
PRIVATE int resume_list_req_timeout(headptr, timeout)
struct mbx_request **headptr;
int timeout;
{
	struct mbx_request *ptr;

	while (*headptr) {
		if ((*headptr)->timeout <= timeout) {
			ptr = *headptr;
			*headptr = ptr->next;
			ptr->status = TIMEOUT;
			resume_process(ptr); }
		else
			headptr = &((*headptr)->next);
		}
	return;
}
/*---------------------------------------------------------------------------*/
PRIVATE struct link_list *rem_link(headptr, mbx)
struct link_list **headptr;
unsigned mbx;
{
	struct link_list *ptr;
	
	while (*headptr) {
		if ((*headptr)->mbx == mbx) {
			ptr = *headptr;
			*headptr = ptr->next;
			return(ptr); }
		headptr = &((*headptr)->next); }
	return(NULL);
}
/*---------------------------------------------------------------------------*/
PRIVATE struct mbx_request *get_process(headptr, proc_ptr)
struct mbx_request **headptr;
procptr proc_ptr;
{
	struct mbx_request *ptr;

	while (*headptr) {
		if ((*headptr)->proc_ptr == proc_ptr) {
			ptr = *headptr;
			*headptr = ptr->next;
			return(ptr); }
		headptr = &((*headptr)->next); }
	return(NULL);
}
/*---------------------------------------------------------------------------*/
PRIVATE struct mbx_request *get_first_op(headptr, data1, data2)
struct mbx_request **headptr;
unsigned data1, data2;
{
	struct mbx_request *ptr,*ptr1;

	if (*headptr) {
		ptr = *headptr;
		while (ptr->next != *headptr) {
			if ((ptr->next->operation == data1)||
				(ptr->next->operation == data2)) {
				ptr1 = ptr->next;
				ptr->next = ptr1->next;
				return(ptr1); }
			ptr = ptr->next; }
		if ((ptr->next->operation == data1)||
			(ptr->next->operation == data2)) {
			ptr1 = ptr->next;
			if (ptr1 == ptr)
				*headptr = NULL;
			else {
				ptr->next = ptr1->next;
				*headptr = ptr; }
			return(ptr1); }
		}
	return(NULL);
}
/*---------------------------------------------------------------------------*/
PRIVATE struct mbx_request *get_all_op(headptr, data1)
struct mbx_request **headptr;
unsigned data1;
{
	struct mbx_request *ptr, *ptr1;
	struct mbx_request *h = NULL;

	if (*headptr) {
		ptr = *headptr;
		while (ptr->next != *headptr) {
			if (ptr->next->operation == data1) {
				ptr1 = ptr->next;
				ptr->next = ptr1->next;

				ptr1->next = h;
				h = ptr1;
				}
			ptr = ptr->next; }
		if (ptr->next->operation == data1) {
			ptr1 = ptr->next;
			if (ptr1 == ptr)
				*headptr = NULL;
			else {
				ptr->next = ptr1->next;
				*headptr = ptr; }

			ptr1->next = h;
			h = ptr1;
			}
		}
	return(h);
}
/*---------------------------------------------------------------------------*/
PRIVATE int resume_all_request(local_mbx,error)
unsigned local_mbx, error;
{
	struct	mbx_request	*p, *q;

	if (local_mbxs[local_mbx]) {
		q = local_mbxs[local_mbx]->next;
		while ((p=q) != local_mbxs[local_mbx]) {
			q = q->next;
			p->status = error;
			resume_process(p);
			}
		local_mbxs[local_mbx]->status = error;
		resume_process(local_mbxs[local_mbx]);
		local_mbxs[local_mbx] = NULL;
		}
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int resume_all_list_request(headptr,error)
struct mbx_request **headptr;
unsigned error;
{
	struct mbx_request *ptr;

	while (*headptr) {
		ptr = *headptr;
		*headptr = ptr->next;
		ptr->status = error;
		resume_process(ptr); }
	return;
}
/*---------------------------------------------------------------------------*/

/*
 *		Generic Functions to manage queues and stacks
 */

/*---------------------------------------------------------------------------*/
PRIVATE int empty_list_l(headptr)
struct list *headptr;
{
	return(! headptr);
}
/*---------------------------------------------------------------------------*/
PRIVATE int push_l(headptr, data)
struct list **headptr;
struct list *data;
{
	if (data) {
		data->next = *headptr;
		*headptr = data; }
}
/*---------------------------------------------------------------------------*/
PRIVATE struct list *pop_l(headptr)
struct list **headptr;
{
	struct list *data;
	
	if (*headptr) {
		data = *headptr;
		*headptr = data->next;
		return(data); }
	return(NULL);
}
/*---------------------------------------------------------------------------*/
PRIVATE int enqueue_l(headptr, data)
struct list **headptr;
struct list *data;
{
	if (data)
		if (*headptr) {
			data->next = (*headptr)->next;
			(*headptr)->next = data;
			*headptr = data; }
		else {
			data->next = data;
			*headptr = data; }
}
/*---------------------------------------------------------------------------*/
PRIVATE struct list *dequeue_l(headptr)
struct list **headptr;
{
	struct list *ptr;

	if (*headptr) {
		if ((*headptr)->next == (*headptr)) {	/* there is only one	*/
			ptr = *headptr;
			*headptr = NULL;
			return(ptr); }
		ptr = (*headptr)->next;
		(*headptr)->next = ptr->next;
		return(ptr); }
	return(NULL);
}
/*---------------------------------------------------------------------------*/
PRIVATE struct list *look_queue_l(headptr)
struct list *headptr;
{
	if (headptr)
		return(headptr->next);
	return(NULL);
}
/*---------------------------------------------------------------------------*/

/*
 *					msg.c
 *
 *	Functions to manage messages between machines and server
 */


#define closed_machine(x)	(x)

/*---------------------------------------------------------------------------*/
PRIVATE send_rem_set_out_link(mbx_i, mbx_o)
unsigned mbx_i, mbx_o;
{
	struct mbx_request req;

	if (GET_MBX_MACH(mbx_i) == MBX_SERVER) {
		closed_machine(NULL);
		return; }
	req.operation = SETOUT;
	req.mbx = mbx_i;
	req.status = mbx_o;
	if (send(sock_list[GET_MBX_MACH(mbx_i)],(char*)(&req),sizeof(struct mbx_request),0) < 0) {
		if (sock_list[GET_MBX_MACH(mbx_i)] == 0) {
			closed_machine(NULL);
			return; }
		perror("sending a set_out_link message");
		return; }
}
/*---------------------------------------------------------------------------*/
PRIVATE send_rem_break_out_link(mbx_i, mbx_o)
unsigned mbx_i, mbx_o;
{
	struct mbx_request req;

	if (GET_MBX_MACH(mbx_i) == MBX_SERVER) {
		closed_machine(NULL);
		return; }
	req.operation = BREAKOUT;
	req.mbx = mbx_i;
	req.status = mbx_o;
	if (send(sock_list[GET_MBX_MACH(mbx_i)],(char*)(&req),sizeof(struct mbx_request),0) < 0) {
		if (sock_list[GET_MBX_MACH(mbx_i)] == 0) {
			closed_machine(NULL);
			return; }
		perror("sending a break_out_link message");
		return; }
}
/*---------------------------------------------------------------------------*/
PRIVATE send_rem_set_inc_link(mbx_o, mbx_i)
unsigned mbx_o, mbx_i;
{
	struct mbx_request req;

	if (GET_MBX_MACH(mbx_o) == MBX_SERVER) {
		closed_machine(NULL);
		return; }
	req.operation = SETINC;
	req.mbx = mbx_o;
	req.status = mbx_i;
	if (send(sock_list[GET_MBX_MACH(mbx_o)],(char*)(&req),sizeof(struct mbx_request),0) < 0) {
		if (sock_list[GET_MBX_MACH(mbx_o)] == 0) {
			closed_machine(NULL);
			return; }
		perror("sending a set_inc_link message");
		return; }
}
/*---------------------------------------------------------------------------*/
PRIVATE send_rem_break_inc_link(mbx_o, mbx_i)
unsigned mbx_o, mbx_i;
{
	struct mbx_request req;

	if (GET_MBX_MACH(mbx_o) == MBX_SERVER) {
		closed_machine(NULL);
		return; }
	req.operation = BREAKINC;
	req.mbx = mbx_o;
	req.status = mbx_i;
	if (send(sock_list[GET_MBX_MACH(mbx_o)],(char*)(&req),sizeof(struct mbx_request),0) < 0) {
		if (sock_list[GET_MBX_MACH(mbx_o)] == 0) {
			closed_machine(NULL);
			return; }
		perror("sending a break_inc_link message");
		return; }
}
/*---------------------------------------------------------------------------*/
PRIVATE int send_remote_request(req)
struct mbx_request *req;
{
#ifdef _DEBUG_
	printf("Send_Remote_Request [0x%04X]->%s Mbx: %d\n",
				req->proc_ptr,oper[GET_TYPE(req->operation)],req->mbx);
#endif

	if (GET_MBX_MACH(req->mbx) == MBX_SERVER) {
		return(FAIL); }
	if (send(sock_list[GET_MBX_MACH(req->mbx)],(char*)req,sizeof(struct mbx_request),0) < 0) {
		return(FAIL); }
	if ((GET_TYPE(req->operation) == SEND)||
		(GET_TYPE(req->operation) == LSEND)||
		(GET_TYPE(req->operation) == BIND)||
		(GET_TYPE(req->operation) == LINK_I)||
		(GET_TYPE(req->operation) == LINK_O)||
		(GET_TYPE(req->operation) == UNLINK_I)||
		(GET_TYPE(req->operation) == UNLINK_O)) {

			if (send(sock_list[GET_MBX_MACH(req->mbx)],(char*)req->data,req->data->size,0) < 0) {
				return(FAIL);}
			}
	remove_dataword(req);
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int send_res_msg(req)
struct mbx_request *req;
{
#ifdef _DEBUG_
	printf("Send_Remote_Result [0x%04X]->%s Mbx: %d\n",
				req->proc_ptr,oper[GET_TYPE(req->operation)],req->mbx);
#endif

	if (GET_PROC_MACH(req->proc_ptr) == MBX_SERVER) {
		return(FAIL); }
	if (send(sock_list[GET_PROC_MACH(req->proc_ptr)],(char*)req,sizeof(struct mbx_request),0) < 0) {
		return(FAIL); }
	if (((GET_TYPE(req->operation) == RECV)||
		(GET_TYPE(req->operation) == LOOK)||
		(GET_TYPE(req->operation) == GETLINKS))&&
		(req->status == OK)) {

			if (send(sock_list[GET_PROC_MACH(req->proc_ptr)],(char*)req->data,req->data->size,0) < 0) {
				return(FAIL);}
			}
	remove_dataword(req);
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE process_normal_msg(sock)
int sock;
{
	int nbytes, size;
	static struct mbx_request *req = NULL;
	struct mbx_request *req1;
	

	if (! req)
		req = (struct mbx_request *)malloc(sizeof(struct mbx_request));

	if ((nbytes = recv(sock, (char*)req, sizeof(struct mbx_request), 0)) == 0)
		return(0);
	if (nbytes != sizeof(struct mbx_request)) {
		perror("receiving a normal msg");
		return(-1); }

	if (IS_LINK_MSG(req->operation))
		switch (req->operation) {
			case SETOUT:
				set_out_link(req->mbx, req->status);
				return(1);
			case SETINC:
				set_inc_link(req->mbx, req->status);
				return(1);
			case BREAKOUT:
				break_out_link(req->mbx, req->status);
				return(1);
			case BREAKINC:
				break_inc_link(req->mbx, req->status);
				return(1);
			}
	
	if (IS_REMOTE_REQUEST(req->mbx)) {
		if ((GET_TYPE(req->operation) == SEND)||
			(GET_TYPE(req->operation) == LSEND)||
			(GET_TYPE(req->operation) == BIND)||
			(GET_TYPE(req->operation) == LINK_I)||
			(GET_TYPE(req->operation) == LINK_O)||
			(GET_TYPE(req->operation) == UNLINK_I)||
			(GET_TYPE(req->operation) == UNLINK_O)) {

				if ((nbytes = recv(sock, (char*)&size, sizeof(int), 0)) == 0)
					return(0);
				if (nbytes != sizeof(int)) {
					perror("receiving a normal msg");
					return(-1); }
				req->data = alloc_p_data(size);

				if ((nbytes = recv(sock, (char*)&req->data->links, size-sizeof(int), 0)) == 0)
					return(0);
				if (nbytes != size-sizeof(int)) {
					perror("receiving a normal msg");
					return(-1); }

				req->data->size = size;
				req->data->links = 1;
				}
		else
				req->data = NULL;
#ifdef _DEBUG_
	printf("Received_Remote_Request [0x%04X]->%s Mbx: %d\n",
				req->proc_ptr,oper[GET_TYPE(req->operation)],req->mbx);
#endif

		resume_local_request(req);
		req = NULL;
		return(1);
		}

	if (IS_REMOTE_REPLY(req->proc_ptr)) {
		if (((GET_TYPE(req->operation) == RECV)||
			(GET_TYPE(req->operation) == LOOK)||
			(GET_TYPE(req->operation) == GETLINKS))&&
			(req->status == OK)) {

				if ((nbytes = recv(sock, (char*)&size, sizeof(int), 0)) == 0)
					return(0);
				if (nbytes != sizeof(int)) {
					perror("receiving a normal msg");
					return(-1); }
				req->data = alloc_p_data(size);

				if ((nbytes = recv(sock, (char*)&req->data->links, size-sizeof(int), 0)) == 0)
					return(0);
				if (nbytes != size-sizeof(int)) {
					perror("receiving a normal msg");
					return(-1); }

				req->data->size = size;
				req->data->links = 1;
				}
		else
				req->data = NULL;

#ifdef _DEBUG_
		printf("Received_Remote_Result [0x%04X]->%s Mbx: %d\n",
					req->proc_ptr,oper[GET_TYPE(req->operation)],req->mbx);
#endif

		if (req1 = get_process(& remote_mbxs[GET_MBX_MACH(req->mbx)],req->proc_ptr)) {
			mbx_assign(req1->data,req->data);
			req->data = NULL;
			req1->status = req->status;
			resume_process(req1);
			return(1); }
		remove_dataword(req);
		return(1);
		}
	return(1);
}
/*---------------------------------------------------------------------------*/
PRIVATE process_OOB_msg(sock)
int sock;
{
	int nbytes;
	char buff[BUFCHARSIZE];

	if ((nbytes = recv(sock, (char*)buff, BUFCHARSIZE, 0)) == 0)
		return(0);
	if (nbytes < 0) {
		perror("receiving an OOB msg");
		return(-1); }

	/*	Process OOB Message	*/

	return(1);
}
/*---------------------------------------------------------------------------*/

/*
 *		Data Base Messages
 */

/*---------------------------------------------------------------------------*/
/*	ATTENTION:
 *		GETID:
 *			'req->data' will keep 'Atom?'
 *		('id')	'req->mbx' will keep 'Id^' as returned value, in unsigned format
 *		GETNAME:
 *			'req->mbx' will keep 'Id?' in unsigned format
 *			'req->data' will keep 'Atom^' as returned valued, in data_word format
 *		INIT:
 *			'req->mbx' will keep 'Pt^' as returned valued, in unsigned format
 *		GETIDNAME:
 *			'req->mbx' will keep 'Pt?' in unsigned format
 *			'req->data' will keep 'Atom^' as returned valued, in PROLOG format
 *		('id')	'req->mbx' will keep 'Id^' as returned value, in unsigned format
 *		CLOSEDBPTR:
 *			'req->mbx' will keep 'Pt?', in unsigned format
 */
/*---------------------------------------------------------------------------*/
PRIVATE process_server_msg(sock)
int sock;
{
	int nbytes;
	struct db_res dbr;
	struct mbx_request *req;

	if ((nbytes = recv(sock, (char*)&dbr, sizeof(struct db_res), 0)) == 0)
		return(0);
	if (nbytes != sizeof(struct db_res)) {
		perror("receiving a server msg");
		return(-1); }

	if (req = get_process(& db_req, dbr.proc_ptr)) {
		switch (dbr.status) {
			case BIND:
				req->status = OK;
				break;
			case GETID:
				req->mbx = dbr.mbx;
				req->status = OK;
				break;
			case GETNAME:
				req->data = alloc_str_data(dbr.service);
				req->status = OK;
				break;
			case INIT:
				req->status = OK;
				break;
			case GETIDNAME:
				req->mbx = dbr.mbx;
				req->data = alloc_str_data(dbr.service);
				req->status = OK;
				break;
			case CLOSEDBPTR:
				req->status = OK;
				break;
			case DUPLICATE_SRV:
			case SERV_NOTFOUND:
			case ID_NOTFOUND:
			case ERRCOND:
				req->status = dbr.status;
				break;
			}
		resume_process(req); }

	return(1);
}
/*---------------------------------------------------------------------------*/
PRIVATE int	send_close_mbx_db_msg(req)
struct mbx_request *req;
{
	struct db_req dbr;

	dbr.operation = CLOSE;
	dbr.proc_ptr = req->proc_ptr;
	dbr.mbx = req->mbx;
	dbr.read_passwd = req->passwd;
	dbr.write_passwd = req->passwd;
	dbr.euid = euid;
	dbr.egid = egid;
/*	strcpy(dbr.service, req->data->buff);	*/
	if (send(sock_list[MBX_SERVER],(char*)&dbr,sizeof(struct db_req),0) < 0) {
		return(FAIL); }
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int	send_bind_msg(req)
struct mbx_request *req;
{
	struct db_req dbr;

	dbr.operation = BIND;
	dbr.proc_ptr = req->proc_ptr;
	dbr.mbx = req->mbx;
	dbr.permiss = mailboxes[GET_MBX_NUMB(req->mbx)]->permiss;
	dbr.read_passwd = mailboxes[GET_MBX_NUMB(req->mbx)]->read_passwd;
	dbr.write_passwd = mailboxes[GET_MBX_NUMB(req->mbx)]->write_passwd;
	dbr.euid = euid;
	dbr.egid = egid;
	strcpy(dbr.service, req->data->buff);
	if (send(sock_list[MBX_SERVER],(char*)&dbr,sizeof(struct db_req),0) < 0) {
		return(FAIL); }
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int	send_getid_msg(req)
struct mbx_request *req;
{
	struct db_req dbr;

	dbr.operation = GETID;
	dbr.proc_ptr = req->proc_ptr;
/*	dbr.mbx = req->mbx;		*/
	dbr.read_passwd = req->passwd;
	dbr.write_passwd = req->passwd;
	dbr.euid = req->euid;
	dbr.egid = req->egid;
	strcpy(dbr.service, req->data->buff);
	if (send(sock_list[MBX_SERVER],(char*)&dbr,sizeof(struct db_req),0) < 0) {
		return(FAIL); }
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int	send_getname_msg(req)
struct mbx_request *req;
{
	struct db_req dbr;

	dbr.operation = GETNAME;
	dbr.proc_ptr = req->proc_ptr;
	dbr.mbx = req->mbx;
	dbr.read_passwd = req->passwd;
	dbr.write_passwd = req->passwd;
	dbr.euid = req->euid;
	dbr.egid = req->egid;
/*	strcpy(dbr.service, req->data->buff);	*/
	if (send(sock_list[MBX_SERVER],(char*)&dbr,sizeof(struct db_req),0) < 0) {
		return(FAIL); }
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int	send_init_msg(req)
struct mbx_request *req;
{
	struct db_req dbr;

	dbr.operation = INIT;
	dbr.proc_ptr = req->proc_ptr;
	dbr.mbx = req->mbx;
/*	dbr.read_passwd = req->passwd;						*/
/*	dbr.write_passwd = req->passwd;						*/
/*	dbr.euid = req->euid;								*/
/*	dbr.egid = req->egid;								*/
/*	strcpy(dbr.service, req->data->buff);	*/
	if (send(sock_list[MBX_SERVER],(char*)&dbr,sizeof(struct db_req),0) < 0) {
		return(FAIL); }
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int	send_getidname_msg(req)
struct mbx_request *req;
{
	struct db_req dbr;

	dbr.operation = GETIDNAME;
	dbr.proc_ptr = req->proc_ptr;
	dbr.mbx = req->mbx;
	dbr.read_passwd = req->passwd;
	dbr.write_passwd = req->passwd;
	dbr.euid = req->euid;
	dbr.egid = req->egid;
/*	strcpy(dbr.service, req->data->buff);	*/
	if (send(sock_list[MBX_SERVER],(char*)&dbr,sizeof(struct db_req),0) < 0) {
		return(FAIL); }
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int	send_closedbptr_msg(req)
struct mbx_request *req;
{
	struct db_req dbr;

	dbr.operation = CLOSEDBPTR;
	dbr.proc_ptr = req->proc_ptr;
	dbr.mbx = req->mbx;
/*	dbr.read_passwd = req->passwd;						*/
/*	dbr.write_passwd = req->passwd;						*/
/*	dbr.euid = req->euid;								*/
/*	dbr.egid = req->egid;								*/
/*	strcpy(dbr.service, req->data->buff);	*/
	if (send(sock_list[MBX_SERVER],(char*)&dbr,sizeof(struct db_req),0) < 0) {
		return(FAIL); }
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/

/*
 *					mbx.c
 *
 *		Functions to manage the mailboxes implementation
 */

/*---------------------------------------------------------------------------*/
PRIVATE struct mailbox *alloc_mailbox(status,permiss,read_passwd,write_passwd)
unsigned status, permiss, read_passwd, write_passwd;
{
	struct mailbox *ptr;

	if (ptr = (struct mailbox *)malloc(sizeof(struct mailbox))) {
		ptr->status = status;
		ptr->permiss = permiss;
		ptr->read_passwd = read_passwd;
		ptr->write_passwd = write_passwd;
		ptr->data = NULL;
		ptr->oob_data = NULL;
		ptr->inc_links = NULL;
		ptr->out_links = NULL; }
	return(ptr);
}
/*---------------------------------------------------------------------------*/
PUBLIC int open_mailbox(permiss, read_passwd, write_passwd)
unsigned permiss, read_passwd, write_passwd;
{
	int mbx_number;
	
	if (! mbx_initialise) {
		return(-1); }
	if (stack_empty)
		if (mbx_count < MAX_MBX)
			mbx_number = mbx_count++;
		else
			return(-1);
	else
		pop_stack(mbx_number);
	if (mailboxes[mbx_number] = alloc_mailbox(DEFAULT_ST, permiss, read_passwd, write_passwd))
		return(MK_MBX(mbx_number));
	push_stack(mbx_number);
	return(-1);
}
/*---------------------------------------------------------------------------*/
/*	ATTENTION:
 *		GETID:
 *			'req->data' will keep 'Atom?'
 *		('id')	'req->mbx' will keep 'Id^' as returned value, in unsigned format
 *		GETNAME:
 *			'req->mbx' will keep 'Id?' in unsigned format
 *			'req->data' will keep 'Atom^' as returned valued, in PROLOG format
 *		INIT:
 *			'req->mbx' will keep 'Pt^' as returned valued, in unsigned format
 *		GETIDNAME:
 *			'req->mbx' will keep 'Pt?' in unsigned format
 *			'req->data' will keep 'Atom^' as returned valued, in PROLOG format
 *		('id')	'req->mbx' will keep 'Id^' as returned value, in unsigned format
 *		CLOSEDBPTR:
 *			'req->mbx' will keep 'Pt?', in unsigned format
 */
/*---------------------------------------------------------------------------*/
PUBLIC struct	mbx_request	*alloc_mbx_request(timeout,mbx,passwd,operation,data)
unsigned	timeout;
unsigned	mbx;
unsigned	passwd;
unsigned	operation;
data_word	data;
{
	struct	mbx_request	*rr;
	unsigned	ti;
	if (! mbx_initialise) {
		return(NULL); }
	ti = time_conversion(timeout);

	if (rr = (struct mbx_request *)malloc(sizeof(struct mbx_request))) {
		rr->timeout = ti;
		rr->mbx = mbx;
		rr->passwd = passwd;
		rr->operation = operation;
		rr->data = data;
		rr->euid = euid;
		rr->egid = egid;
		rr->status = INIT_STATUS;
		}
	return(rr);
}
/*---------------------------------------------------------------------------*/
PRIVATE int is_rem_enq_op(operation)
unsigned operation;
{
	switch (operation) {
		case	RECV:
		case	LOOK:
		case	CHECKRECV:
		case	GETLINKS:
							return(TRUE);
/*
 *		case	SEND:
 *		case	LSEND:
 *		case	COMMIT:
 *		case	DISCARD:
 *		case	CLOSE:
 *		case	LINK_I:
 *		case	LINK_O:
 *		case	UNLINK_I:
 *		case	UNLINK_O:
 *		case	CLEAR:
 *		case	BIND:
 */
		default:
							return(FALSE);
		}
}
/*---------------------------------------------------------------------------*/
/*	ATTENTION:	the next function is duplicated in mbx_server.c
/*---------------------------------------------------------------------------*/
PRIVATE int is_db_enq_op(operation)
unsigned operation;
{
	switch (operation) {
		case	GETID:
		case	GETNAME:
		case	GETIDNAME:
							return(TRUE);
/*
 *		case	CLOSE:
 *		case	BIND:
 *		case	INIT:
 *		case	CLOSEDBPTR:
 */
		default:
							return(FALSE);
		}
}
/*---------------------------------------------------------------------------*/
PRIVATE int check_local_mbx_timeout()		/*	queues	*/
{
	int i;

	for (i = 0; i < MAX_MBX; ++i)
		resume_queue_req_timeout(& local_mbxs[i], time(NULL));
}
/*---------------------------------------------------------------------------*/
PRIVATE int check_remote_mbx_timeout()		/*	list	*/
{
	int i;

	for (i = 0; i < MAX_MACH; ++i)
		resume_list_req_timeout(& remote_mbxs[i], time(NULL));
}
/*---------------------------------------------------------------------------*/
PRIVATE int check_db_mbx_timeout()			/*	list	*/
{
	resume_list_req_timeout(& db_req, time(NULL));
}
/*---------------------------------------------------------------------------*/
PUBLIC int check_mbx_timeout()
{
	check_local_mbx_timeout();
/*
 *	check_remote_mbx_timeout();		ATTENTION
 */
/*
 *	check_db_mbx_timeout();			ATTENTION
 */
}
/*---------------------------------------------------------------------------*/
PRIVATE int set_out_link(mbx_i, mbx_o)
unsigned mbx_i, mbx_o;
{
	struct link_list *ptr;

	if (IS_LOCAL_MBX(mbx_i)) {			/*	Local Mbx			*/
		if (mailboxes[GET_MBX_NUMB(mbx_i)]) {
			if (ptr = rem_link(&(mailboxes[GET_MBX_NUMB(mbx_i)]->out_links), mbx_o)) {
				push(&(mailboxes[GET_MBX_NUMB(mbx_i)]->out_links), ptr);
				return; }
			push(&(mailboxes[GET_MBX_NUMB(mbx_i)]->out_links), alloc_link(mbx_o));
			mailboxes[GET_MBX_NUMB(mbx_i)]->status = SET_LINK(mailboxes[GET_MBX_NUMB(mbx_i)]->status);
			}
		return; }
										/*	Remote Mbx			*/
	send_rem_set_out_link(mbx_i, mbx_o);
}
/*---------------------------------------------------------------------------*/
PRIVATE int break_out_link(mbx_i, mbx_o)
unsigned mbx_i, mbx_o;
{
	struct link_list *ptr;

	if (IS_LOCAL_MBX(mbx_i)) {			/*	Local Mbx			*/
		if (mailboxes[GET_MBX_NUMB(mbx_i)])
			if (ptr = rem_link(&(mailboxes[GET_MBX_NUMB(mbx_i)]->out_links), mbx_o))
				free(ptr);
		if (! mailboxes[GET_MBX_NUMB(mbx_i)]->out_links)
			mailboxes[GET_MBX_NUMB(mbx_i)]->status = SET_UNLINK(mailboxes[GET_MBX_NUMB(mbx_i)]->status);
		return; }
										/*	Remote Mbx			*/
	send_rem_break_out_link(mbx_i, mbx_o);
}
/*---------------------------------------------------------------------------*/
PRIVATE int set_inc_link(mbx_o, mbx_i)
unsigned mbx_o, mbx_i;
{
	struct link_list *ptr;

	if (IS_LOCAL_MBX(mbx_o)) {			/*	Local Mbx			*/
		if (mailboxes[GET_MBX_NUMB(mbx_o)]) {
			if (ptr = rem_link(&(mailboxes[GET_MBX_NUMB(mbx_o)]->inc_links), mbx_i)) {
				push(&(mailboxes[GET_MBX_NUMB(mbx_o)]->inc_links), ptr);
				return; }
			push(&(mailboxes[GET_MBX_NUMB(mbx_o)]->inc_links), alloc_link(mbx_i));
			}
		return; }
										/*	Remote Mbx			*/
	send_rem_set_inc_link(mbx_o, mbx_i);
}
/*---------------------------------------------------------------------------*/
PRIVATE int break_inc_link(mbx_o, mbx_i)
unsigned mbx_o, mbx_i;
{
	struct link_list *ptr;

	if (IS_LOCAL_MBX(mbx_o)) {			/*	Local Mbx			*/
		if (mailboxes[GET_MBX_NUMB(mbx_o)])
			if (ptr = rem_link(&(mailboxes[GET_MBX_NUMB(mbx_o)]->inc_links), mbx_i))
				free(ptr);
		return; }
										/*	Remote Mbx			*/
	send_rem_break_inc_link(mbx_o, mbx_i);
}
/*---------------------------------------------------------------------------*/
PRIVATE int resume_process(req)
struct	mbx_request	*req;
{
	if (IS_LOCAL_PROCESS(req->proc_ptr)) {
#ifdef HERMES
		if (is_a_parlog_process(req->proc_ptr))
			resume_parlog_proc(GET_PROC_NUMB(req->proc_ptr));
		else
#endif
			resume_prolog_proc(GET_PROC_NUMB(req->proc_ptr));
		return(SUCCESS); }

#ifdef	FULL_REPORT_ERROR

	if (GET_TYPE(req->operation) == LSEND) {
		remove_dataword(req);
		free(req);
		return(SUCCESS); }

#else

	if (is_rem_enq_op(GET_TYPE(req->operation)))

#endif
		send_res_msg(req);

	remove_dataword(req);
	free(req);
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int resume_local_request(req)
struct	mbx_request	*req;
{
	int aux;

	if ((aux = local_mbx_operation(req)) == SUSPEND_FOR_EVENT)
		return(SUSPEND_FOR_EVENT);
	resume_process(req);
	return(aux);
}
/*---------------------------------------------------------------------------*/
PRIVATE int resume_first_recv_look(local_mbx,type)
unsigned local_mbx, type;
{
	struct	mbx_request	*p;

	if (p = get_first_op(&local_mbxs[local_mbx],type|RECV,type|LOOK))
		return(resume_local_request(p));
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int resume_close_linki(local_mbx)
unsigned local_mbx;
{
	struct	mbx_request	*p,*q;

	if (p = get_first_op(&local_mbxs[local_mbx],CLOSE,NULL))
		return(resume_local_request(p));
	q = get_all_op(&local_mbxs[local_mbx],LINK_I);
	while ((p=q) != NULL) {
		q = q->next;
		resume_local_request(p); }
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int mbx_send(req)
struct	mbx_request	*req;
{
	struct link_list *ptr;
	unsigned err,id;
	data_word data;

	if (is_linked(GET_MBX_NUMB(req->mbx))) {		/*	linked Mailbox	*/
		ptr = mailboxes[GET_MBX_NUMB(req->mbx)]->out_links;
		while(ptr != NULL) {
			inc_dw_ref_count(req->data);
			make_mbx_request(alloc_mbx_request(BLOCK,ptr->mbx,0,MK_OPERATION(GET_OOB(req->operation),LSEND),req->data),
					GET_PROC_TYPE(req->proc_ptr),&err,&id,&data);
			remove_dw(data);
			ptr = ptr->next;
			}
		req->status = OK;
		return(SUCCESS); }

	enqueue_data(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation),req);
	req->data = NULL;

	if (! is_locked(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation))) {
		resume_first_recv_look(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation));}
	req->status = OK;
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int mbx_recv(req)
struct	mbx_request	*req;
{
	dequeue_data(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation),req);

	if (! is_empty(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation))) {
		resume_first_recv_look(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation));}
	req->status = OK;
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int mbx_look(req)
struct	mbx_request	*req;
{
	get_data(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation),req);
	lock_mbx(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation));

	req->status = OK;
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int mbx_commit(req)
struct	mbx_request	*req;
{
	dequeue_data2(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation));
	unlock_mbx(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation));

	resume_close_linki(GET_MBX_NUMB(req->mbx));
	
	if (! is_empty(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation))) {
		resume_first_recv_look(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation));}
	req->status = OK;
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int mbx_discard(req)
struct	mbx_request	*req;
{
	unlock_mbx(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation));

	resume_close_linki(GET_MBX_NUMB(req->mbx));
	
	if (! is_empty(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation))) {
		resume_first_recv_look(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation));}
	req->status = OK;
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int  mbx_close(req)
struct	mbx_request *req;
{
	struct link_list *ptr,*aux;
	struct data_list *p, *pp;

	send_close_mbx_db_msg(req);
	resume_all_request(GET_MBX_NUMB(req->mbx),MCLOSED);
			/*	freeing incoming links	*/
	ptr = mailboxes[GET_MBX_NUMB(req->mbx)]->inc_links;
	while (ptr != NULL) {
		break_out_link(ptr->mbx,req->mbx);
		aux = ptr;
		ptr = ptr->next;
		free(aux); }
			/*	freeing outgoing links	*/
	ptr = mailboxes[GET_MBX_NUMB(req->mbx)]->out_links;
	while (ptr != NULL) {
		break_inc_link(ptr->mbx,req->mbx);
		aux = ptr;
		ptr = ptr->next;
		free(aux); }
			/*	freeing data queue	*/
	if (mailboxes[GET_MBX_NUMB(req->mbx)]->data) {
		p = mailboxes[GET_MBX_NUMB(req->mbx)]->data->next;
		while (p != mailboxes[GET_MBX_NUMB(req->mbx)]->data) {
			pp = p;
			p = p->next;
			remove_dw(pp->data);
			free(pp); }
		remove_dw(mailboxes[GET_MBX_NUMB(req->mbx)]->data->data);
		free(mailboxes[GET_MBX_NUMB(req->mbx)]->data); }
			/*	freeing OOB data queue	*/
	if (mailboxes[GET_MBX_NUMB(req->mbx)]->oob_data) {
		p = mailboxes[GET_MBX_NUMB(req->mbx)]->oob_data->next;
		while (p != mailboxes[GET_MBX_NUMB(req->mbx)]->oob_data) {
			pp = p;
			p = p->next;
			remove_dw(pp->data);
			free(pp); }
		remove_dw(mailboxes[GET_MBX_NUMB(req->mbx)]->oob_data->data);
		free(mailboxes[GET_MBX_NUMB(req->mbx)]->oob_data); }
			/*	freeing mailbox	*/
	free(mailboxes[GET_MBX_NUMB(req->mbx)]);
	mailboxes[GET_MBX_NUMB(req->mbx)] = NULL;
	push_stack(GET_MBX_NUMB(req->mbx));
	req->status = OK;
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int mbx_link_i(req)
struct	mbx_request	*req;
{
	unsigned mbx_2 = int_value_of_dataword(req->data);

	if (req->mbx != mbx_2) {
		set_out_link(req->mbx, mbx_2);
		req->status = OK;
		return(SUCCESS); }
	req->status = ERRCOND;
	return(FAIL);
}
/*---------------------------------------------------------------------------*/
PRIVATE int mbx_link_o(req)
struct	mbx_request	*req;
{
	set_inc_link(req->mbx, (unsigned)int_value_of_dataword(req->data));
	req->status = OK;
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int mbx_unlink_i(req)
struct	mbx_request	*req;
{
	unsigned mbx_2 = int_value_of_dataword(req->data);

	if (req->mbx != mbx_2) {
		break_out_link(req->mbx, mbx_2);
		req->status = OK;
		return(SUCCESS); }
	req->status = ERRCOND;
	return(FAIL);
}
/*---------------------------------------------------------------------------*/
PRIVATE int mbx_unlink_o(req)
struct	mbx_request	*req;
{
	break_inc_link(req->mbx, (unsigned)int_value_of_dataword(req->data));
	req->status = OK;
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int mbx_getlinks(req)
struct	mbx_request	*req;
{
	req->data = mk_links_dw(mailboxes[GET_MBX_NUMB(req->mbx)]->out_links,
				mailboxes[GET_MBX_NUMB(req->mbx)]->inc_links);
	req->status = OK;
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int  mbx_clear(req)
struct	mbx_request *req;
{
	struct data_list *p, *pp;

			/*	freeing data queue	*/
	if ((GET_OOB(req->operation) == NORMAL)&&
		(mailboxes[GET_MBX_NUMB(req->mbx)]->data)) {
		p = mailboxes[GET_MBX_NUMB(req->mbx)]->data->next;
		while (p != mailboxes[GET_MBX_NUMB(req->mbx)]->data) {
			pp = p;
			p = p->next;
			remove_dw(pp->data);
			free(pp); }
		remove_dw(mailboxes[GET_MBX_NUMB(req->mbx)]->data->data);
		free(mailboxes[GET_MBX_NUMB(req->mbx)]->data);
		mailboxes[GET_MBX_NUMB(req->mbx)]->data = NULL;
		req->status = OK;
		return(SUCCESS); }

			/*	freeing OOB data queue	*/
	if ((GET_OOB(req->operation) == OOB)&&
			(mailboxes[GET_MBX_NUMB(req->mbx)]->oob_data)) {
		p = mailboxes[GET_MBX_NUMB(req->mbx)]->oob_data->next;
		while (p != mailboxes[GET_MBX_NUMB(req->mbx)]->oob_data) {
			pp = p;
			p = p->next;
			remove_dw(pp->data);
			free(pp); }
		remove_dw(mailboxes[GET_MBX_NUMB(req->mbx)]->oob_data->data);
		free(mailboxes[GET_MBX_NUMB(req->mbx)]->oob_data);
		mailboxes[GET_MBX_NUMB(req->mbx)]->oob_data = NULL;
		}
	req->status = OK;
	return(SUCCESS);
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_send(req)
struct	mbx_request	*req;
{
	if (send_allowed(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation))) {
		return(mbx_send(req)); }
/*
 *	enqueue_local_request(req);
 *	return(SUSPEND_FOR_EVENT);
 */
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_recv(req)
struct	mbx_request	*req;
{
	if (recv_allowed(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation))) {
		return(mbx_recv(req)); }

	enqueue_local_request(req);
	return(SUSPEND_FOR_EVENT);
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_look(req)
struct	mbx_request	*req;
{
	if (look_allowed(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation))) {
		return(mbx_look(req)); }

	enqueue_local_request(req);
	return(SUSPEND_FOR_EVENT);
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_commit(req)
struct	mbx_request	*req;
{
	if (commit_allowed(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation))) {
		return(mbx_commit(req)); }

	req->status = SEQUENCE;
	return(FAIL);
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_discard(req)
struct	mbx_request	*req;
{
	if (discard_allowed(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation))) {
		return(mbx_discard(req)); }

	req->status = SEQUENCE;
	return(FAIL);
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_checkrecv(req)
struct	mbx_request	*req;
{
	if (recv_allowed(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation))) {
		req->status = OK;
		return(SUCCESS); }

	if (is_empty(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation)))
		req->status = MEMPTY;
	else
		req->status = LOCKED;
	return(FAIL);
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_close(req)
struct	mbx_request	*req;
{
	if (close_allowed(GET_MBX_NUMB(req->mbx))) {
		return(mbx_close(req)); }

	enqueue_local_request(req);
	return(SUSPEND_FOR_EVENT);
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_link_i(req)
struct	mbx_request	*req;
{
	if (link_i_allowed(GET_MBX_NUMB(req->mbx))) {
		return(mbx_link_i(req)); }

	enqueue_local_request(req);
	return(SUSPEND_FOR_EVENT);
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_link_o(req)
struct	mbx_request	*req;
{
	if (link_o_allowed(GET_MBX_NUMB(req->mbx))) {
		return(mbx_link_o(req)); }
/*
 *	enqueue_local_request(req);
 *	return(SUSPEND_FOR_EVENT);
 */
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_unlink_i(req)
struct	mbx_request	*req;
{
	if (unlink_i_allowed(GET_MBX_NUMB(req->mbx))) {
		return(mbx_unlink_i(req)); }
/*
 *	enqueue_local_request(req);
 *	return(SUSPEND_FOR_EVENT);
 */
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_unlink_o(req)
struct	mbx_request	*req;
{
	if (unlink_o_allowed(GET_MBX_NUMB(req->mbx))) {
		return(mbx_unlink_o(req)); }
/*
 *	enqueue_local_request(req);
 *	return(SUSPEND_FOR_EVENT);
 */
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_getlinks(req)
struct	mbx_request	*req;
{
	if (getlinks_allowed(GET_MBX_NUMB(req->mbx))) {
		return(mbx_getlinks(req)); }
/*
 *	enqueue_local_request(req);
 *	return(SUSPEND_FOR_EVENT);
 */
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_clear(req)
struct	mbx_request	*req;
{
	if (clear_allowed(GET_MBX_NUMB(req->mbx),GET_OOB(req->operation))) {
		return(mbx_clear(req)); }

	enqueue_local_request(req);
	return(SUSPEND_FOR_EVENT);
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_bind(req)
struct	mbx_request	*req;
{
	if (bind_allowed(GET_MBX_NUMB(req->mbx))) {
		if (send_bind_msg(req) == FAIL) {
			req->status = TCP_ERR;
			return(FAIL); }

#ifndef	FULL_REPORT_ERROR

		if (is_db_enq_op(GET_TYPE(req->operation)))
#endif
			{
			enqueue_db_request(req);
			return(SUSPEND_FOR_EVENT);
			}

#ifndef FULL_REPORT_ERROR

		req->status = OK;
		return(SUCCESS);
#endif
		}
/*
 *	enqueue_local_request(req);
 *	return(SUSPEND_FOR_EVENT);
 */
}
/*---------------------------------------------------------------------------*/
PRIVATE int db_operation(req)
struct	mbx_request	*req;
{
	unsigned	aux;

	switch (GET_TYPE(req->operation)) {
		case	GETID:
			if (send_getid_msg(req) == FAIL) {
				req->status = TCP_ERR;
				return(FAIL); }
			break;
		case	GETNAME:
			if (send_getname_msg(req) == FAIL) {
				req->status = TCP_ERR;
				return(FAIL); }
			break;
		case	INIT:
			aux = MK_DBPTR(mbx_init_count);
			++mbx_init_count;
			req->mbx = aux;
			if (send_init_msg(req) == FAIL) {
				req->status = TCP_ERR;
				return(FAIL); }
			break;
		case	GETIDNAME:
			if (send_getidname_msg(req) == FAIL) {
				req->status = TCP_ERR;
				return(FAIL); }
			break;
		case	CLOSEDBPTR:
			if (send_closedbptr_msg(req) == FAIL) {
				req->status = TCP_ERR;
				return(FAIL); }
			break;
		}

#ifndef	FULL_REPORT_ERROR

		if (is_db_enq_op(GET_TYPE(req->operation)))
#endif
			{
			enqueue_db_request(req);
			return(SUSPEND_FOR_EVENT);
			}

#ifndef FULL_REPORT_ERROR

		req->status = OK;
		return(SUCCESS);
#endif
}
/*---------------------------------------------------------------------------*/
PRIVATE int local_mbx_operation(req)
struct	mbx_request	*req;
{
	if (! mailboxes[GET_MBX_NUMB(req->mbx)]) {
		req->status = MCLOSED;
		return(FAIL); }
	switch (GET_TYPE(req->operation)) {
		case	SEND:
			if (write_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				return(local_mbx_send(req)); }
			req->status = PERMISS;
			return(FAIL);
		case	LSEND:
			return(local_mbx_send(req));
		case	RECV:
			if (read_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				if (is_linked(GET_MBX_NUMB(req->mbx))) {
					req->status = LINKED;
					return(FAIL); }
				return(local_mbx_recv(req)); }
			req->status = PERMISS;
			return(FAIL);
		case	LOOK:
			if (read_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				if (is_linked(GET_MBX_NUMB(req->mbx))) {
					req->status = LINKED;
					return(FAIL); }
				return(local_mbx_look(req)); }
			req->status = PERMISS;
			return(FAIL);
		case	COMMIT:
			if (read_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				if (is_linked(GET_MBX_NUMB(req->mbx))) {
					req->status = LINKED;
					return(FAIL); }
				return(local_mbx_commit(req)); }
			req->status = PERMISS;
			return(FAIL);
		case	DISCARD:
			if (read_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				if (is_linked(GET_MBX_NUMB(req->mbx))) {
					req->status = LINKED;
					return(FAIL); }
				return(local_mbx_discard(req)); }
			req->status = PERMISS;
			return(FAIL);
		case	CHECKRECV:
			if (read_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				if (is_linked(GET_MBX_NUMB(req->mbx))) {
					req->status = LINKED;
					return(FAIL); }
				return(local_mbx_checkrecv(req)); }
			req->status = PERMISS;
			return(FAIL);
		case	CLOSE:
			if (read_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				return(local_mbx_close(req)); }
			req->status = PERMISS;
			return(FAIL);
		case	LINK_I:
			if (read_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				return(local_mbx_link_i(req)); }
			req->status = PERMISS;
			return(FAIL);
		case	LINK_O:
			if (write_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				return(local_mbx_link_o(req)); }
			break_out_link((unsigned)int_value_of_dataword(req->data), req->mbx);		/*	since the set_out_link() function was called	*/
			req->status = PERMISS;
			return(FAIL);
		case	UNLINK_I:
			if (read_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				return(local_mbx_unlink_i(req)); }
			req->status = PERMISS;
			return(FAIL);
		case	UNLINK_O:
			if (write_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				return(local_mbx_unlink_o(req)); }
			set_out_link((unsigned)int_value_of_dataword(req->data), req->mbx);		/*	since the break_out_link() function was called	*/
			req->status = PERMISS;
			return(FAIL);
		case	GETLINKS:
			if (read_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				return(local_mbx_getlinks(req)); }
			req->status = PERMISS;
			return(FAIL);
		case	CLEAR:
			if (read_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				if (is_linked(GET_MBX_NUMB(req->mbx))) {
					req->status = LINKED;
					return(FAIL); }
				return(local_mbx_clear(req)); }
			req->status = PERMISS;
			return(FAIL);
		case	BIND:
			if (read_permiss(GET_MBX_NUMB(req->mbx),req->passwd,req->euid,req->egid)) {
				return(local_mbx_bind(req)); }
			req->status = PERMISS;
			return(FAIL);
		}
	req->status = ERRCOND;
	return(FAIL);
}
/*---------------------------------------------------------------------------*/
/*	ATTENTION:
 *		GETID:
 *			'req->data' will keep 'Atom?'
 *		('id')	'req->mbx' will keep 'Id^' as returned value, in unsigned format
 *		GETNAME:
 *			'req->mbx' will keep 'Id?' in unsigned format
 *			'req->data' will keep 'Atom^' as returned valued, in PROLOG format
 *		INIT:
 *			'req->mbx' will keep 'Pt^' as returned valued, in unsigned format
 *		GETIDNAME:
 *			'req->mbx' will keep 'Pt?' in unsigned format
 *			'req->data' will keep 'Atom^' as returned valued, in PROLOG format
 *		('id')	'req->mbx' will keep 'Id^' as returned value, in unsigned format
 *		CLOSEDBPTR:
 *			'req->mbx' will keep 'Pt?', in unsigned format
 */
/*---------------------------------------------------------------------------*/
PUBLIC int make_mbx_request(req,type,err,id,data)
struct	mbx_request	*req;
unsigned	type;		/* PARLOG || PROLOG	*/
unsigned	*err;
unsigned	*id;
data_word	*data;
{
	int aux;

	if (! mbx_initialise) {
		*data = NULL;
		*err = ERRCOND;
		return(FAIL); }
	if (! req) {
		*data = NULL;
		*err = ERRCOND;
		return(FAIL); }
	if (req->status != INIT_STATUS)
		switch (req->status) {
			case OK:			/*	Resumed: Ok	*/
				/* Data is Ok	*/
				dec_pwec(FD_READ);	/* Decrement Processes Waiting for Events Counter	*/
				*id = req->mbx;
				*data = req->data;
				*err = OK;
				free(req);
				return(SUCCESS);
			default:			/*	Resumed: Error	*/
				dec_pwec(FD_READ);	/* Decrement Processes Waiting for Events Counter	*/
				*data = req->data;
				*err = req->status;
				free(req);
				return(FAIL);
			}

#ifdef HERMES
	if (type == PARLOG)
		req->proc_ptr = MK_PARLOG_PROC_PTR(GetParlogProcessPtr(0));
	else
#endif
		req->proc_ptr = MK_PROLOG_PROC_PTR(GetPrologProcessPtr(0));

	if (IS_DB_OPERATION(GET_TYPE(req->operation))) {
		if ((aux = db_operation(req)) != SUSPEND_FOR_EVENT) {
			*id = req->mbx;
			*data = req->data;
			*err = req->status;
			free(req);
			return(aux); }
		inc_pwec(FD_READ);
		return(SUSPEND_FOR_EVENT);
		}

	if (IS_LOCAL_MBX(req->mbx)) {			/*	Local Mbx			*/
		if (mailboxes[GET_MBX_NUMB(req->mbx)]) {
			if ((aux = local_mbx_operation(req)) != SUSPEND_FOR_EVENT) {
					/* Data is Ok	*/
				*id = req->mbx;
				*data = req->data;
				*err = req->status;
				free(req);
				return(aux); }
			inc_pwec(FD_READ);
			return(SUSPEND_FOR_EVENT); }
		if (GET_TYPE(req->operation) == LINK_O)
			break_out_link((unsigned)int_value_of_dataword(req->data), req->mbx);		/*	since the set_out_link() function was called	*/
		if (GET_TYPE(req->operation) == UNLINK_O)
			set_out_link((unsigned)int_value_of_dataword(req->data), req->mbx);		/*	since the break_out_link() function was called	*/
		*data = req->data;;
		*err = MCLOSED;
		free(req);
		return(FAIL);
		}
											/*	Remote Mbx			*/
	if (send_remote_request(req) == FAIL) {
		*data = req->data;
		*err = CLOSED_MACH;
		free(req);
		return(FAIL); }


#ifdef	FULL_REPORT_ERROR

	if (GET_TYPE(req->operation) == LSEND) {
		*id = req->mbx;
		*data = req->data;
		*err = OK;
		free(req);
		return(SUCCESS); }

#else

	if (is_rem_enq_op(GET_TYPE(req->operation)))

#endif
		{
		enqueue_remote_request(req);
		inc_pwec(FD_READ);
		return(SUSPEND_FOR_EVENT);
		}

#ifndef FULL_REPORT_ERROR

	*id = req->mbx;
	*data = req->data;
	*err = OK;
	free(req);
	return(SUCCESS);

#endif

}
/*---------------------------------------------------------------------------*/


