/*  Copyright (C) 1990, Jim Crammond, Imperial College. All rights reserved.  */

/*
 *  builtin predicate table
 */
extern	Word	(*bu_table[])();


/*
 *  Builtin Predicates and Functions
 */
extern	int	bu_var();
extern	int	bu_nonvar();
extern	int	bu_atom();
extern	int	bu_integer();
extern	int	bu_float();
extern	int	bu_number();
extern	int	bu_atomic();
extern	int	bu_lex_eq();
extern	int	bu_lex_ne();
extern	int	bu_lex_lt();
extern	int	bu_lex_gt();
extern	int	bu_lex_le();
extern	int	bu_lex_ge();
extern	int	bu_compare();

extern	int	bu_arith_eq();
extern	int	bu_arith_ne();
extern	int	bu_arith_lt();
extern	int	bu_arith_gt();
extern	int	bu_arith_le();
extern	int	bu_arith_ge();

extern	Word	fu_plus();
extern	Word	fu_minus();
extern	Word	fu_not();
extern	Word	fu_integer();
extern	Word	fu_float();
extern	Word	fu_add();
extern	Word	fu_subtract();
extern	Word	fu_multiply();
extern	Word	fu_fdivide();
extern	Word	fu_idivide();
extern	Word	fu_modulus();
extern	Word	fu_and();
extern	Word	fu_or();
extern	Word	fu_lshift();
extern	Word	fu_rshift();

extern	Word	fu_add_const();
extern	Word	fu_sub_const();
extern	Word	fu_mul_const();
extern	Word	fu_fdiv_const();
extern	Word	fu_idiv_const();
extern	Word	fu_mod_const();

extern	int	bu_term_to_list();
extern	int	bu_list_to_term();
extern	int	bu_st_to_list();
extern	int	bu_list_to_st();
extern	int	bu_term_to_na();
extern	int	bu_na_to_term();
extern	int	bu_arg();
extern	int	bu_list_to_atom();
extern	int	bu_clock();


/*
 *  Builtin "C" predicates
 */
extern	int	c_module();
extern	int	c_curr_module();
extern	int	c_public();
extern	int	c_export();
extern	int	c_import();
extern	int	c_load();
extern	int	c_load1();

extern	int	io_open();
extern	int	io_close();
extern	int	io_set_input();
extern	int	io_set_output();
extern	int	io_curr_input();
extern	int	io_curr_output();
extern	int	io_flush();

extern	int	io_get0();
extern	int	io_st_get0();
extern	int	io_get();
extern	int	io_st_get();
extern	int	io_skip();
extern	int	io_st_skip();
extern	int	io_gets();
extern	int	io_st_gets();

extern	int	io_put();
extern	int	io_st_put();
extern	int	io_nl();
extern	int	io_st_nl();
extern	int	io_tab();
extern	int	io_st_tab();

extern	int	io_display();
extern	int	io_st_display();
extern	int	io_write();
extern	int	io_st_write();

extern	int	c_unix();
extern	int	c_load_foreign();

extern	int	c_set_op_prec();
extern	int	c_get_op_prec();
extern	int	c_ground();
extern	int	c_copy_term();
extern	int	c_create_channel();
extern	int	c_write_channel();
extern	int	c_get_channel();
extern	int	c_close_channel();

extern	int	c_synch();
extern	int	c_gc();

extern	int	c_spy();
extern	int	c_nospy();

extern	int	c_runtime();
extern	int	c_counts();
extern	int	c_mem_usage();

extern	int	c_getenv();
extern	int	c_setenv();
extern	int	c_concat_atom();
extern	int	c_stat();
extern	int	c_defined();
extern	int	c_varoccurs();

#define	FNULL	( (int(*)()) NULL )
#ifdef HERMES
extern	int	c_resume();
extern	int	c_new_thread();
extern	int	c_fork();
extern	int	c_pipe();
extern	int	c_write_pipe();
extern	int	c_commit_read();
extern	int	c_unlock();
extern	int	c_look_pipe();
extern	int	c_read_pipe();
extern	int	c_close_port();
extern	int	c_release_port();
extern	int	c_debug();
extern	int	c_empty_pipe();
extern	int	c_is_iport();
extern	int	c_is_oport();
extern	int	c_prolog();
extern	int	c_timeslice();
extern	int	c_set_port();
extern	int	c_get_port();
#endif
