/*  Copyright (C) 1990, Jim Crammond, Imperial College. All rights reserved.  */

#include "objs.h"
#include "proc.h"
#include "mem.h"
#include "synch.h"
#include "macros.h"
#include "instr.h"
#include "ret.h"
#include "trace.h"

extern	Word	*stack_base;
extern	int	Nsuspensions;

unify(t1, t2)
Word	t1, t2;
{
	int	tag1;
	int	i, n, ret;
	Word	*p1, *p2;

	deref(t1);
	deref(t2);

	/*  if terms are identical, return successfully  */
	if (t1 == t2)
		return(SUCCESS);

	tag1 = u_tag(t1);

	switch(tag1)
	{
	case U_REF:
		if (IsRef(t2) && t2 > t1)
			assign(t2, t1)		/* ; */
		else
			assign(t1, t2)		/* ; */
		break;

	case U_CONST:
		if (IsRef(t2))
			assign(t2, t1)		/* ; */
		else /* t1 != t2 */
			return(FAIL);
		break;

	case U_LIST:
		if (IsRef(t2))
			assign(t2, t1)		/* ; */
		else if (IsList(t2))
		{	/*  move to head of list and unify  */
			p1 = ListVal(t1);
			p2 = ListVal(t2);

			if ((ret = unify((Word)p1, (Word)p2)) != SUCCESS)	/*  head  */
				return(ret);

			return( unify((Word)++p1, (Word)++p2) );		/*  tail  */
		}
		else
			return(FAIL);
		break;

	case U_STRUCT:
		if (IsRef(t2))
			assign(t2, t1)		/* ; */
		else if (IsStruct(t2))
		{	/*  move to structure and unify functor + args  */
			p1 = StructVal(t1);
			p2 = StructVal(t2);

			if (*p1 == *p2)				/*  functor  */
			{	n = (FunctVal(*p1))->f_arity;
				for (i=0; i<n; i++)		/*  & args  */
				{	if ((ret = unify((Word)++p1, (Word)++p2)) != SUCCESS)
						return(ret);
				}
			}
			else
				return(FAIL);
		}
		else
			return(FAIL);
		break;
	}

	return(SUCCESS);
}

match(t1, t2)
Word	t1, t2;
{
	int	tag1;
	int	i, n, ret;
	Word	*p1, *p2;

	deref(t1);
	deref(t2);

	/*  if terms are identical, return successfully  */
	if (t1 == t2)
		return(SUCCESS);

	if (IsRef(t2))
	{	if (IsRef(t1) && t1 > t2)
			t2 = t1;

		for (i=0; i<Nsuspv; i++)
		{	if (VarTbl[i] == t2)
				return(SUSPEND);
		}
		VarTbl[Nsuspv++] = t2;
		return(SUSPEND);
	}

	tag1 = u_tag(t1);

	switch(tag1)
	{
	case U_REF:
		for (i=0; i<Nsuspv; i++)
		{	if (VarTbl[i] == t1)
				return(SUSPEND);
		}
		VarTbl[Nsuspv++] = t1;
		return(SUSPEND);

	case U_CONST:
		/* t1 != t2 */
		return(FAIL);

	case U_LIST:
		if (IsList(t2))
		{	/*  move to head of list and unify  */
			p1 = ListVal(t1);
			p2 = ListVal(t2);

			if ((ret = match((Word)p1, (Word)p2)) != SUCCESS)	/*  head  */
				return(ret);

			return( match((Word)++p1, (Word)++p2) );		/*  tail  */
		}
		else
			return(FAIL);
		break;

	case U_STRUCT:
		if (IsStruct(t2))
		{	/*  move to structure and unify functor + args  */
			p1 = StructVal(t1);
			p2 = StructVal(t2);

			if (*p1 == *p2)				/*  functor  */
			{	n = (FunctVal(*p1))->f_arity;
				for (i=0; i<n; i++)		/*  & args  */
				{	if ((ret = match((Word)++p1, (Word)++p2)) != SUCCESS)
						return(ret);
				}
			}
			else
				return(FAIL);
		}
		else
			return(FAIL);
		break;
	}

	return(SUCCESS);
}


/*
 *  SUSPEND  --  suspend a process on a variable.
 */
suspend(var)
register Word	*var;
{
	Nsuspensions++;

	PS->link = (Process *) *ToPtr(var);
	*ToPtr(var) = AsUnb(PS);

}


/*
 *  MULTI_SUSPEND  --  suspend a process on multiple variables
 *			Create a "hanger" that points to the process
 *			and a series of "suspension notes" for each variable
 */
multi_suspend(vars, nv)
Word	*vars;
int	nv;
{
	register Word *HP;
	Word	var, *hanger;
	int	i;

	Nsuspensions++;

	/*  create hanger on heap  */
	HP = m_ht->m_top;
	hanger = HP;
	*HP++ = AsShort(PS);		/*  constant type, for gc purposes  */

	/*
	 *  create suspension notes, also on the heap
	 */
	for (i=0; i<nv; i++)
	{	HP[1] = ToRef(hanger);
		var = vars[i];

		HP[0] = *ToPtr(var);
		*ToPtr(var) = AsUnb(HP);

		HP += 2;
	}

	m_ht->m_top = HP;

}



/*
 *  WAKE  --  wake processes in suspension list pointed to by ps_list.
 *		all processes in list are added to the local run queue.
 */
wake(ps_list)
Process	*ps_list;
{
	register Process *p;
	register Word plink;
	Word	*hngp;
	char	*lck;

	/*
	 *  the ps_list arg to wake is guaranteed to be from an unbound var;
	 *  however, its suspension list may be terminated by a value
	 *  instead of PNULL.
	 */
	for (p=ps_list; p; p=UnbVal(plink))
	{	if (ProcessPtr(p))
		{	plink = (Word) p->link;
			while (plink == AsUnb(p))    /*  wait while "locked" */
				plink = (Word) p->link;
		}
		else
		{	/*
			 *  an indirect ps cell;  2nd arg points to a ps ptr
			 *  on heap. Get ps pointer from this and reset it to
			 *  prevent any further wake signals to this process.
			 */
			plink = (Word) ((Word *)p)[0];
			while (plink == AsUnb(p))    /*  wait while "locked" */
				plink = (Word) ((Word *)p)[0];

			hngp = (Word *) ((Word *)p)[1];
			lck = ptrtolck(hngp);
			lock(lck);
			p = (Process *) ShortVal(*hngp);
			*hngp = ToShort(0);
			unlock(lck);

			if (p == PNULL)	    /*  someone else got here first  */
				continue;
		}

		TRACE_wake(p);

		enqueue_process(p);
	}
}
