/*  Copyright (C) 1990, Jim Crammond, Imperial College. All rights reserved.  */

/*
 *  process  and  processor  structure definitions
 */
typedef	struct	process	Process;
typedef	struct	processor Processor;

/*
 *  process structure
 */
struct	process
{	Process	*parent;		/*  parent pointer	*/
	short	refcount;		/*  reference count	*/
	short	nargs;			/*  no. of arguments	*/
	Word	*args;			/*  arguments pointer	*/
	Word	*env;			/*  environment pointer	*/
	Code	*cont;			/*  continuation ptr	*/
	Code	*nextcl;		/*  next clause ptr	*/
	Process	*link;			/*  process list	*/
	Process	*root;			/*  top level of guard	*/
};

#define dead(ps)	(ps && ps->nargs < 0)
#define	REFWGT		256
#define	PNULL		(Process *) 0

/*
 *  processor structure   - contains all public processor "registers"
 */
struct processor
{	int	pr_state;		/*  processor state	*/
	int	pr_lock;		/*  processor lock	*/
	Process	**q_front;
	Process	**q_back;
	Process	**q_bot;		/*  run queue pointer	*/
	Process	**q_end;
	Word	*gc_bot;		/*  indirect ptr stack  */
	Word	*gc_top;
	Word	*gc_end;
	int	st_ncalls;		/*  statistics - calls	*/
	int	st_nsusps;		/*  	   suspensions  */
	int	st_h_used;		/*  	     heap used  */
	int	st_h_free;		/*  	     heap free  */
	int	st_s_used;		/*	    stack used  */
	int	st_s_free;		/*	    stack free  */
	int	st_p_used;		/*	     proc used  */
	int	st_p_free;		/*	     proc free  */
	int	st_c_free;		/*	     code free  */
	int	st_cnts[8];		/*  miscellaneous cnts	*/
	Process	*pr_q[2022];		/*  the run queue 	*/
};

/*
 *  processor states
 */
#define	PR_EXECUTE	0		/*  executing work	*/
#define	PR_SEARCH	1		/*  search for work 	*/
#define PR_DEADLOCK	2		/*  deadlock		*/
#define	PR_EVENT	3		/*  executing event	*/
#define	PR_INPUT	4		/*  blocking on input   */
#define	PR_SLEEP	5		/*  blocking on pause	*/


#define PRtolck(pr)  ptrtolck(pr>>10)	/*  better lck hash fn	*/


extern	Processor *PR;			/*  this processor 	*/
extern	Processor *Pr0, *PrN;		/*  1st & last pr's	*/
extern	int	NPR;			/*  no. of processors	*/

extern	Process	*PS;			/*  current process 	*/
extern	Process *Parent_PS;		/*  current parent	*/
extern	int	Parent_Refwgt;		/*  local refs to parent*/

extern	Process	*p_top,*p_end;		/*  process stack ptrs	*/
extern	Process	*p_free;		/*  process freelist	*/

extern  Process **q_back;		/*  local q back ptr	*/
extern	Process	**io_q_front;		/*  front of I/O queue	*/
extern	Process	**io_q_back;		/*  back of I/O queue	*/
