/*  Copyright (C) 1990, Jim Crammond, Imperial College. All rights reserved.  */

#ifdef TRACE

#define VERIFY_ps()		if (verifyflag) verify_ps()
#define VERIFY_instr(c,sp,hp)	if (verifyflag) verify_instr(c,sp,hp)

#define	TRACE_execute()		if (traceflag)	   trace_execute()
#define TRACE_instr(c)		if (tracing(*c))   trace_instr(c)
#define	TRACE_suspend()		if (tracing(call)) trace_suspend()
#define	TRACE_fail()		if (tracing(fail)) trace_fail()
#define	TRACE_wake(ps)		if (tracing(call)) trace_wake(ps)

#define TRACE_event(msg)	if (traceflag) printf("%d# %s event (%x)\n", PR-Pr0, msg, *event)
#define TRACE_msg(msg)		printf("%d# %s\n", PR-Pr0, msg)
#define TRACE_icount(c)		instr_count[*c]++

/*
 *  instruction tracing
 */
struct	instruction
{	char	*i_opname;
	char	*i_argtypes;
	short	i_trace;
};

extern	struct	instruction instructions[];	/*  instruction table   */
extern	int	verifyflag;			/*  instr verification	*/
extern	int	traceflag;			/*  tracing level	*/
extern	int	instr_count[];			/*  instruction stats	*/

#define tracing(op)	(traceflag >= instructions[op].i_trace)

#define verify_msg(msg, arg)			\
	{	printf("%d# verify: ", PR-Pr0);	\
		printf(msg, arg);		\
		traceflag = 5;			\
		return;				\
	}


/*
 *  instruction argument types
 */
#define	A_REGISTER	'a'
#define	X_REGISTER	'x'
#define	Y_REGISTER	'y'
#define	INTEGER		'n'
#define	CONSTANT	'c'
#define	STRUCTURE	's'
#define PROCEDURE	'p'
#define BUILTIN		'b'
#define LABEL		'l'

#else TRACE

#define VERIFY_ps()
#define VERIFY_instr(c,sp,hp)

#define	TRACE_execute()
#define TRACE_instr(c)
#define	TRACE_suspend()
#define	TRACE_fail()
#define	TRACE_wake(ps)
#define TRACE_event(msg)
#define TRACE_msg(msg)
#define TRACE_icount(c)

#endif TRACE
