include(../../install/Makefile.incl)

CPPFLAGS	= -DHERMES -DHEAPSIZE=$(HEAPSIZE) -DSTACKSIZE=$(STACKSIZE) -DARCH=\"m4arch\"

OBJECTS		= \
	abolish.o arith.o cg.o debug.o dynamic.o encode.o events.o foreign.o \
	fork.o gc.o icp.o interrupt.o io.o loader.o main.o metalogical.o \
	operators.o predicates.o primitives.o properties.o saver.o select.o \
	stats.o term.o termin.o token.o unify.o unix.o cursor.o filenames.o \
	tcp_prolog.o

HEADERS=ICprolog.h icp.h io.h primitives.h

TARGET		= libprolog.a

DIFFS	= *.[ch]

undefine(`include')
all:: $(TARGET)
	m4localinstall(include, $(HEADERS))

makefiles::

depend::
	$(MAKEDEPEND) -- $(CFLAGS) $(CPPFLAGS) -- *.c

clean::
	$(RM_CMD) $(TARGET) $(OBJECTS)

diffs::
	m4diff(src/prolog)

$(TARGET): $(OBJECTS)
	$(AR_CMD) $@ $?
	$(RANLIB) $@

ifelse(m4arch m4cc, sun3 cc,
icp.o:		icp.c
	$(CC) $(CFLAGS) $(CPPFLAGS) -c -J $<
)

