/* Copyright (C) 1992 Imperial College */
#include "primitives.h"
#include "symtab.h"

#ifdef ANSI
#else
extern char *memset();
#endif

void abolish_one(dict)
dictionary dict;
{	
    segment	seg = dict->seg;

    dict->addr = 0;
    dict->type = 0;
    if (dict->entry != 0) {
	dict->entry = 0; 	/* Mark it as abolished */
	segPred(seg)--; 	/* Decrement predicate count */
    }
}


reclaim_seg(seg)
segment	seg;
{
	/*
	 * In the final system, we cannot actually free the space
	 * here.  We would need to check that the constant symbols
	 * are not referenced, and that no choicepoint can backtrack
	 * into code in this segment.
	 */
	free((char *)segStart(seg));

	if (segNext(seg))
		segPrev(segNext(seg)) = segPrev(seg);
	if (segPrev(seg))
		segNext(segPrev(seg)) = segNext(seg);
	else
		seglist = segNext(seg);

	free((char *)seg);
}


/*
 * Removes references to a predicate from a specified segment.  This
 * is done just before the space for the segment is reclaimed.
 */
remove_reference(dict, segstart, type)
dictionary	dict;
codepo		segstart;
int		type;
{
    dlist	ref = dict->d,
		prev = NULL;

    while (ref && (segStart(ref->segptr) != segstart)) {
	prev = ref;
	ref = ref->next;
    }

    if (ref) {
	if (prev == NULL)
	    dict->d = ref->next;
	else
	    prev->next = ref->next;

	free((char *)ref);

	if (type == DYNAMIC)
	    reclaim_seg(ref->segptr);
    }
}


/*
 * Ensure that the constant for the predicate of this dictionary entry
 * is in a current segment.  The dictionary entry is blanked out if
 * there are no current references.
 */
update_reference(dict)
dictionary	dict;
{
    short	link;

    if (dict->d == NULL) {	/* Blank predicate's entry in symtab */
	link = dict->link;
	(void)memset((char*)dict, 0, (SIZE_TYPE)sizeof(struct dict));
	dict->link = link;
    }
    else			/* Use constant from some other segment */
	dict->con = (dict->d)->con;		
}


void abolish(dict) 
dictionary dict;
{
    register
    codepo	entry,
		end;				
    segment	seg = dict->seg;
	
    abolish_one(dict);
    remove_reference(dict, segStart(seg), STATIC);
    update_reference(dict);

    if (segPred(seg) == 0) {
	/* All the predicates have been abolished */
	entry = segExt(seg);
	end = segLoc(seg);
	while (entry < end) {
	    if (dict = find_entry(ext_pred(entry), ext_arity(entry))) {
		remove_reference(dict, segStart(seg), STATIC);
		update_reference(dict);
	    }
	    entry += EXT_SIZE;
	}

	reclaim_seg(seg);
    }
}


/* abolish a static predicate */
bool pr_abolish()
{
    cellpo 	name   	= &A[1],
		arit	= &A[2];

    dictionary	dict;
	
    delnk(name);
    delnk(arit);

    if ((dict=find_entry(symbvl(name), (twoBytes)intvl(arit))) && dict->addr) 
	abolish(dict);
    return(SUCCEED);
}


/*
 * abolishes the whole segment containing the specified predicate.  Note
 * that this abolishes all other predicates defined in the same segment
 */
bool pr_kill()
{
    cellpo	name   	= &A[1],
		arit	= &A[2];
    codepo	entry, end;
    dictionary	dict;
    segment	seg;
	
    delnk(name);
    delnk(arit);

    if ((dict=find_entry(symbvl(name), (twoBytes)intvl(arit))) && dict->addr) {
	seg = dict->seg;

	/* first remove all entries other than the first */
	entry = segLoc(seg);
	end = segCon(seg);
	for (entry += ENT_SIZE; entry < end; entry += ENT_SIZE)
	    if (dict = find_entry(ent_pred(entry), ent_arity(entry))) {
		if (dict->seg == seg && dict->addr)
		    abolish_one(dict);
		remove_reference(dict, segStart(seg), STATIC);
		update_reference(dict);
	    }

	/* finally, remove the first entry (removes the whole segment) */
	entry = segLoc(seg);
	dict = find_entry(ent_pred(entry), ent_arity(entry));
	abolish(dict);
    }
    return(SUCCEED);
}
