/* Copyright (C) 1992 Imperial College */
#include "primitives.h"
#include "symtab.h"
#include "dynamic.h"
#include "opcodes.h"

extern bool	samesymb();

init_dynamic()
{
    /* initialise clock */
    C = 0;
}

bool pr_link()
{
    register
    dictionary	dict;
    register
    codepo	clause;
    cellpo	N	= &A[1];
    codepo  	entry,
		clause1;
    twoBytes	index,
		arit;
    symbpo	pred;

    delnk(N);

    index = intvl(N);

    link_segment(newseg);

    entry = segLoc(newseg);
    clause = segStart(newseg) + HEAD_SIZE;
    arit = ent_arity(entry);
    pred = ent_pred(entry);
    dict = get_entry(pred, arit);

    new_dictionary_list(dict, newseg, pred);

    if ((clause1 = dict->addr) == 0) {
	dict->addr = clause;
	dict->seg = newseg;
	dict->entry = entry;
	dict->type = DYNAMIC;

	*clause = fdynamic;
	nextcl(clause) = 0;

    } else {
    	if (index < 0) {
	    short count;
	    for (count=0; nextcl(clause1); clause1 += nextcl(clause1))
	    	if (live(clause1, C))
		    count++;
	    if (live(clause1, C))
	    	count++;
	    if (-index > count)
		index = 1;
	    else
		    index += count + 1;
	    clause1 = dict->addr;
    	}
	switch (index) {
	    case 0: {
		while (nextcl(clause1))
		    clause1 += nextcl(clause1);
		nextcl(clause1) = clause - clause1;
		nextcl(clause) = 0;
		break;
	    }
	    case 1: {
		nextcl(clause) = clause1 - clause;
		*clause = fdynamic;
		*clause1 = dynamic;
		dict->addr = clause;
		break;
	    }
	    default: {
		index -= 2;
		while ((nextcl(clause1)) && (index > 0)) {
			if (live(clause1, C))
				index--;
			clause1 += nextcl(clause1);
		}
		if (nextcl(clause1) == 0) {
			nextcl(clause1) = clause - clause1;
			nextcl(clause) = 0;
		}
		else {
			nextcl(clause) = clause1 + nextcl(clause1) - clause;
			nextcl(clause1) = clause - clause1;
		}
	    }
	}
    }

    birth(clause) = C++;
    death(clause) = MAXDEATH;

    segPred(newseg) = 1;
    fix_externs(segExt(newseg), segLoc(newseg));

    return(SUCCEED);
}


codepo find_clause(name1, arity1, name2, arity2, index)
symbpo 	name1,
	name2;
short	arity1,
	arity2,
	*index;
{
    dictionary	dict;
    codepo	clause, extrn, entry, base;
    short	count;
    bool	found = FALSE;

    if ((dict = find_entry(name1, arity1))) {
	clause = dict->addr;
	findFirst(clause, C);
    }
    else clause = NULL;

    for(count=1; !found; count++) {
	if (clause == NULL) { /* no more live clauses */
	    count = 0;
	    break;
	}

	base = clause - HEAD_SIZE;
	extrn = clause + seg_ext(base);
	entry = clause + seg_ent(base);

	while (!found && extrn < entry) {
	    found = (samesymb(name2, ext_pred(extrn)) &&
		arity2 == ext_arity(extrn));
	    extrn += EXT_SIZE;
	}
	    
	if (found)
	    break;

	findNext(clause, C);
    }
    *index = count;
    return(clause);
}

/* Instantiates index with the index of the first live clause of dynamic
predicate name1/arity1 whose segment contains name2/arity2 as an external.
 It assumes  name1/arity1 is defined and returns an index of zero if the
 desired segment is not found.
*/
bool pr_find_clause()
{
    cellpo 	reg1 = &A[1], /* name1  */
    		reg2 = &A[2], /* arity1 */
    		reg3 = &A[3], /* name2  */
    		reg4 = &A[4], /* arity2 */
    		reg5 = &A[5]; /* index  */

    short n;

    delnk(reg1);
    delnk(reg2);
    delnk(reg3);
    delnk(reg4);
    delnk(reg5);

    mkreset(reg5);
    (void)find_clause(symbvl(reg1), (short)intvl(reg2), symbvl(reg3),
			(short)intvl(reg4), &n);
    mkint(reg5, (fourBytes)n);
    return(SUCCEED);
}

/* retract the indexth live clause for dynamic predicate name/arity */
bool pr_retract()
{
    register
    codepo	clause;
    cellpo 	reg1 = &A[1], /* name */
    		reg2 = &A[2], /* arity */
    		reg3 = &A[3]; /* index */

    twoBytes	n;
    bool	alive;
    dictionary	d;

    delnk(reg1);
    delnk(reg2);
    delnk(reg3);

    n = intvl(reg3);
    d = find_entry(symbvl(reg1), (twoBytes)intvl(reg2));
    if (d && (clause = d->addr)) {
    	if (n < 0) {
	    short count;
	    for (count=0; nextcl(clause); clause+=nextcl(clause))
	    	if (live(clause, C))
		    count++;
	    n += count;
    	}
        else n--;
        clause = d->addr;
	while (nextcl(clause) && (!(alive=live(clause, C)) || n > 0)) {
	    if (alive)
		n--;
	    clause += nextcl(clause);
	}
	death(clause) = C++;
    }
    return(SUCCEED);
}

bool pr_delete()
{
    register
    codepo	clause,
    		next,
		segstart;
    cellpo 	reg1 = &A[1], /* name */
    		reg2 = &A[2]; /* arity */
    dictionary	dict;

    delnk(reg1);
    delnk(reg2);

    dict = find_entry(symbvl(reg1), (twoBytes)intvl(reg2));

    if (!dict || !(clause = dict->addr))
	return(SUCCEED);

    next = clause + nextcl(clause);

    dict->addr = 0;
    dict->type = 0;
    dict->entry= 0;

    for (;;) {
	segstart = clause - HEAD_SIZE;
	remove_reference(dict, segstart, DYNAMIC);

	if (clause == next)
	    break;
	clause = next;
	next += nextcl(clause);
    }

    update_reference(dict);

    return(SUCCEED);
}

/* A[1] must be instantiated to a singleton list whose element is some
    integer N. The 'inc%f' primitive simply increments N by one. */
bool pr_inc()
{
    register
    cellpo reg1 = &A[1];
    delnk(reg1);
    reg1 = hd(reg1);
    delnk(reg1);
    mkint1(reg1, intvl(reg1)+1);
    return(SUCCEED);
}

/* A[1] must be instantiated to a singleton list whose element is some
    integer N. The 'dec%f' primitive simply decrements N by one. */
bool pr_dec()
{
    register
    cellpo reg1 = &A[1];
    delnk(reg1);
    reg1 = hd(reg1);
    delnk(reg1);
    mkint1(reg1, intvl(reg1)-1);
    return(SUCCEED);
}
