/* Copyright (C) 1992 Imperial College */
/* these are the Prolog primitives implemented in C */

	{
	    register bool status;
	    switch (*P++) {
	    case PR_halt:
#ifdef GNUDOS
		MARK(ESC_halt);
		icp_exit(0);
		break;
#else
	    {	long block = 0;
		extern double usertime();

		MARK(ESC_halt);
                /* reset to blocking I/O for shell */
                (void)ioctl(0, FIONBIO, &block);
		(void) fprintf(stderr,
			"\n{ End of IC-Prolog execution, user time %.3f }\n",
			usertime() - prolog_th->stats.starttime);
		icp_exit(0);
		break;
	    }
#endif
	    case PR_debugicp:
		MARK(ESC_debugicp);
		debugger(P);	
		status = SUCCEED;
		break;
	    case PR_noref:
		MARK(ESC_noref);
		noref();
		status = SUCCEED;
		break;

	    case PR_add:
		MARK(ESC_add);
		status = pr_add();
		break;
	    case PR_subtract:
		MARK(ESC_subtract);
		status = pr_subtract();
		break;
	    case PR_multiply:
		MARK(ESC_multiply);
		status = pr_multiply();
		break;
	    case PR_divide:
		MARK(ESC_divide);
		status = pr_divide();
		break;
	    case PR_mod:
		MARK(ESC_mod);
		status = pr_mod();
		break;
	    case PR_cmp:
		MARK(ESC_cmp);
		status = pr_cmp();
		break;
	    case PR_integer:
		MARK(ESC_integer);
		status = pr_integer();
		break;
	    case PR_atom:
		MARK(ESC_atom);
		status = pr_atom();
		break;
	    case PR_var:
		MARK(ESC_var);
		status = pr_var();
		break;
	    case PR_list:
		MARK(ESC_list);
		status = pr_list();
		break;
	    case PR_tpl:
		MARK(ESC_tpl);
		status = pr_tpl();
		break;
	    case PR_getarg:
		MARK(ESC_getarg);
		status = pr_getarg();
		break;
	    case PR_tpl_to_list:
		MARK(ESC_tpl_to_list);
		status = pr_tuple_to_list();
		break;
	    case PR_name:
		MARK(ESC_name);
		status = pr_name();
		break;
	    case PR_open_stream:
		MARK(ESC_open_stream); 
		status = pr_open_stream();
		break;
	    case PR_close_stream:
		MARK(ESC_close_stream); 
		status = pr_close_stream();
		break;
	    case PR_open_ram:
		MARK(ESC_open_ram); 
		status = pr_open_ram();
		break;
	    case PR_close_ram:
		MARK(ESC_close_ram); 
		status = pr_close_ram();
		break;
	    case PR_set_input:
		MARK(ESC_set_input); 
		status = pr_set_input();
		break;
	    case PR_set_output:
		MARK(ESC_set_output); 
		status = pr_set_output();
		break;
	    case PR_increment:
		MARK(ESC_increment);
		status = pr_increment();
		break;
	    case PR_put_q_atom:
		MARK(ESC_put_q_atom);
		status = pr_put_q_atom();
		break;
	    case PR_charin:
		MARK(ESC_charin);
	    {
		register CHARTYPE ch;
		register cellpo ptr = &A[1];
    		delnk(ptr);
		if (ended(current_input))
		    status = FAIL;
		else {
		    sP = P;		/* in case of callback */
		    if ((ch=(*charin)()) == EOF)
		 	ch = 26;	/* Ctrl-Z is Prolog EOF */
		    mkreset(ptr);
		    mkint(ptr, ch);
		    status = SUCCEED;
		}
		break;
	    }
	    case PR_charout:
		MARK(ESC_charout);
	    {
		register cellpo ptr = &A[1];
    		delnk(ptr);
		status = (*charout)((CHARTYPE)intvl(ptr));
		break;
	    }
	    case PR_charback:
		MARK(ESC_charback);
	    {
		register cellpo ptr = &A[1];
    		delnk(ptr);
		status = (*charback)((CHARTYPE)intvl(ptr));
		break;
	    }
	    case PR_flush:
		MARK(ESC_flush);
		status = pr_flush();
		break;
	    case PR_addr:
		MARK(ESC_addr);
		status = pr_addr(TH);
		break;
	    case PR_deepcut:
		MARK(ESC_deepcut);
	    {
		register cellpo ptr = &A[1];
		delnk(ptr);
		if (IsInt(ptr)) {
		    SB = (choicepo)intvl(ptr);
		    goto L_cut;
		}
		status = FAIL;
		break;
	    }
	    case PR_back:
		MARK(ESC_back);
	    {
		register cellpo ptr = &A[1];
		delnk(ptr);
		if (status = (IsVar(ptr)))
		    mkint1(ptr, (fourBytes)SB);
		break;
	    }
	    case PR_meta:
		MARK(ESC_meta);
		SB = B;
		if (!(status = pr_meta(&PP))) {
		    /* meta-calling foreign code, A[0] contains goal term */
		    status = (*(bool (*) ())PP)();
		    A[1] = A[0];	/* restore goal term */
		}
		else P = PP;
		break;
	    case PR_eq:
		MARK(ESC_eq);
		status = pr_eq();
		break;
	    case PR_ne:
		MARK(ESC_ne);
		status = pr_ne();
		break;
	    case PR_lt:
		MARK(ESC_lt);
		status = pr_lt();
		break;
	    case PR_le:
		MARK(ESC_le);
		status = pr_le();
		break;
	    case PR_gt:
		MARK(ESC_gt);
		status = pr_gt();
		break;
	    case PR_ge:
		MARK(ESC_ge);
		status = pr_ge();
		break;
	    case PR_syntax_error:
		MARK(ESC_syntax_error);
		status = pr_syntax_error();
		break;
	    case PR_link:
		MARK(ESC_link);
		status = pr_link();
		break;
	    case PR_retract:
		MARK(ESC_retract);
		status = pr_retract();
		break;
	    case PR_dec:
		MARK(ESC_dec);
		status = pr_dec();
		break;
	    case PR_inc:
		MARK(ESC_inc);
		status = pr_inc();
		break;
	    case PR_find_clause:
		MARK(ESC_find_clause);
		status = pr_find_clause();
		break;
	    case PR_time:
		MARK(ESC_time);
		status = pr_time();
		break;
	    case PR_arity:
		MARK(ESC_arity);
		status = pr_arity();
		break;
	    case PR_funct:
		MARK(ESC_funct);
		status = pr_funct();
		break;
	    case PR_interm:
		MARK(ESC_interm);
		status = pr_interm();
		break;
	    case PR_not:
		MARK(ESC_not);
		status = pr_not();
		break;
	    case PR_ntpl:
		MARK(ESC_ntpl);
		status = pr_ntpl();
		break;
	    case PR_lshift:
		MARK(ESC_lshift);
		status = pr_lshift();
		break;
	    case PR_rshift:
		MARK(ESC_rshift);
		status = pr_rshift();
		break;
	    case PR_and:
		MARK(ESC_and);
		status = pr_and();
		break;
	    case PR_or:
		MARK(ESC_or);
		status = pr_or();
		break;
	    case PR_op_prefix:
		MARK(ESC_op_prefix);
		status = pr_op_prefix();
		break;
	    case PR_op_postfix:
		MARK(ESC_op_postfix);
		status = pr_op_postfix();
		break;
	    case PR_op_infix:
		MARK(ESC_op_infix);
		status = pr_op_infix();
		break;
	    case PR_op_look:
		MARK(ESC_op_look);
		status = pr_op_look();
		break;
	    case PR_op_get:
		MARK(ESC_op_get);
		status = pr_op_get();
		break;
	    case PR_put_str:
		MARK(ESC_put_str);
		status = pr_put_str();
		break;
	    case PR_put_atom:
		MARK(ESC_put_atom);
		status = pr_put_atom();
		break;
	    case PR_put_number:
		MARK(ESC_put_number);
		status = pr_put_number();
		break;
	    case PR_atom_type:
		MARK(ESC_atom_type);
		status = pr_atom_type();
		break;
	    case PR_defined:
		MARK(ESC_defined);
		status = pr_defined();
		break;
	    case PR_read_catch:
		MARK(ESC_read_catch);
	    {
		register cellpo ptr = &A[1];
		delnk(ptr);
		mkreset(ptr);
		mkint(ptr, CATCH);
		status = SUCCEED;
		break;
	    }
	    case PR_set_catch:
		MARK(ESC_set_catch);
	    {
		register cellpo ptr = &A[1];
		delnk(ptr);
		CATCH = (choicepo)intvl(ptr);
		status = SUCCEED;
		break;
	    }
	    case PR_read_error:
		MARK(ESC_read_error);
	    {
		register cellpo ptr = &A[1];
		delnk(ptr);
		mkreset(ptr);
		mkint(ptr, ERROR);
		ERROR = 0;
		status = SUCCEED;
		break;
	    }
	    case PR_catch:
		MARK(ESC_catch);
	    {
		register cellpo ptr = &A[1];
		CATCH = B;
		delnk(ptr);
		mkreset(ptr);
		mkint(ptr, CATCH);
		status = SUCCEED;
		break;
	    }
	    case PR_throw:
		MARK(ESC_throw);
	    {
		register cellpo ptr = &A[1];
		delnk(ptr);
		ERROR = (IsInt(ptr)) ? (twoBytes)intvl(ptr) : 207;
		B = CATCH;
		status = FAIL;
		break;
	    }
	    case PR_cg_init:
		MARK(ESC_cg_init);
		status = pr_cg_init();
		break;
	    case PR_cg_fixup:
		MARK(ESC_cg_fixup);
		status = pr_cg_fixup();
		break;
	    case PR_cg:
		MARK(ESC_cg);
		status = pr_cg();
		break;
	    case PR_system:
		MARK(ESC_system);
		status = pr_system();
		break;
	    case PR_ram_const:
		MARK(ESC_ram_const);
		status = pr_ram_const();
		break;
	    case PR_load:
		MARK(ESC_load);
		status = pr_load();
		break;
	    case PR_varsin:
		MARK(ESC_varsin);
		status = pr_varsin();
		break;
	    case PR_fix_tables:
		MARK(ESC_fix_tables);
		status = pr_fix_tables();
		break;
	    case PR_save:
		MARK(ESC_save);
		status = pr_save();
		break;  
	    case PR_pred_look:
		MARK(ESC_pred_look);
		status = pr_pred_look();
		break;
	    case PR_pred_get:
		MARK(ESC_pred_get);
		status = pr_pred_get();
		break;  
	    case PR_abolish:
		MARK(ESC_abolish);
		status = pr_abolish();
		break;  
	    case PR_validate:
		MARK(ESC_validate);
		status = pr_validate();
		break;  
	    case PR_undo_seg:
		MARK(ESC_undo_seg);
		status = pr_undo_seg();
		break;
	    case PR_kill:
		MARK(ESC_kill);
		status = pr_kill();
		break;
	    case PR_write_term:
		MARK(ESC_write_term);
		status = pr_write_term();
		break;
	    case PR_read_term:
		MARK(ESC_read_term);
		/* assumes sufficient heap space */
		status = pr_read_term();
		break;
	    case PR_tag:
		MARK(ESC_tag);
		status = pr_tag();
		break;
	    case PR_grnd_funct:
		MARK(ESC_grnd_funct);
		status = pr_grnd_funct();
		break;
	    case PR_tab:
		MARK(ESC_tab);
		status = pr_tab();
		break;
	    case PR_concat:
		MARK(ESC_concat);
		status = pr_concat();
		break;
	    case PR_prefix:
		MARK(ESC_prefix);
		status = pr_prefix();
		break;
	    case PR_suffix:
		MARK(ESC_suffix);
		status = pr_suffix();
		break;
	    case PR_to_ground:
		MARK(ESC_to_ground);
		status = pr_to_ground();
		break;
	    case PR_to_hollow:
		MARK(ESC_to_hollow);
		status = pr_to_hollow();
		break;
	    case PR_delete:
		MARK(ESC_delete);
		status = pr_delete();
		break;
	    case PR_cg_out:
		MARK(ESC_cg_out);
		status = pr_cg_out();
		break;
	    case PR_set_up_seg:
		MARK(ESC_set_up_seg);
		status = pr_set_up_seg();
		break;
	    case PR_tty:
		MARK(ESC_tty);
		status = pr_tty();
		break;
	    case PR_ram_pipe:
		MARK(ESC_ram_pipe);
		status = pr_ram_pipe();
		break;
	    case PR_close_port:
		MARK(ESC_close_port);
		status = pr_close_port();
		break;
	    case PR_read_pipe:
		MARK(ESC_read_pipe);
		status = pr_read_pipe();
		break;
	    case PR_write_pipe:
		MARK(ESC_write_pipe);
		status = pr_write_pipe();
		break;
	    case PR_new_thread:
		MARK(ESC_new_thread);
		status = pr_new_thread();
		break;
	    case PR_kill_thread:
		MARK(ESC_kill_thread);
		status = pr_kill_thread();
		break;
	    case PR_fork:
		MARK(ESC_fork);
		status = pr_fork();
		break;
	    case PR_resume:
		MARK(ESC_resume);
		sP = P;			/* load shadow reg */
		status = pr_resume();
		if (status) {
		    h_deadlock = 0;
		    return(-1);		/* EXIT FROM FUNCTION 'SOLVE' */
		}
		break;
	    case PR_suspend:
		MARK(ESC_suspend);
		status = pr_suspend();
		break;
	    case PR_rpc:
		MARK(ESC_rpc); 
		sP = P;			/* load shadow reg */
		status = pr_rpc();
		if (status) {
		    h_deadlock = 0;
		    return(-1);		/* EXIT FROM FUNCTION 'SOLVE' */
		}
		break;
	    case PR_pipe:
		MARK(ESC_pipe);
		status = pr_pipe();
		break;
	    case PR_thread:
		MARK(ESC_thread);
		status = pr_thread();
		break;
	    case PR_set_prop:
		MARK(ESC_set_prop);
		status = pr_set_prop();
		break;
	    case PR_get_prop:
		MARK(ESC_get_prop);
		status = pr_get_prop();
		break;
	    case PR_del_prop:
		MARK(ESC_del_prop);
		status = pr_del_prop();
		break;
	    case PR_get_props:
		MARK(ESC_get_props);
		status = pr_get_props();
		break;
	    case PR_del_props:
		MARK(ESC_del_props);
		status = pr_del_props();
		break;
	    case PR_get_cons:
		MARK(ESC_get_cons);
		status = pr_get_cons();
		break;
	    case PR_del_cons:
		MARK(ESC_del_cons);
		status = pr_del_cons();
		break;
	    case PR_float:
		MARK(ESC_float);
		status = pr_float();
		break;
	    case PR_put_float:
		MARK(ESC_put_float);
		status = pr_put_float();
		break;
	    case PR_number:
		MARK(ESC_number);
		status = pr_number();
		break;
	    case PR_fadd:
		MARK(ESC_fadd);
		status = pr_fadd();
		break;
	    case PR_fsub:
		MARK(ESC_fsub);
		status = pr_fsub();
		break;
	    case PR_fmul:
		MARK(ESC_fmul);
		status = pr_fmul();
		break;
	    case PR_fdiv:
		MARK(ESC_fdiv);
		status = pr_fdiv();
		break;
	    case PR_int:
		MARK(ESC_int);
		status = pr_int();
		break;
	    case PR_sin:
		MARK(ESC_sin);
		status = pr_sin();
		break;
	    case PR_cos:
		MARK(ESC_cos);
		status = pr_cos();
		break;
	    case PR_tan:
		MARK(ESC_tan);
		status = pr_tan();
		break;
	    case PR_asin:
		MARK(ESC_asin);
		status = pr_asin();
		break;
	    case PR_acos:
		MARK(ESC_acos);
		status = pr_acos();
		break;
	    case PR_atan:
		MARK(ESC_atan);
		status = pr_atan();
		break;
	    case PR_atan2:
		MARK(ESC_atan2);
		status = pr_atan2();
		break;
	    case PR_sinh:
		MARK(ESC_sinh);
		status = pr_sinh();
		break;
	    case PR_cosh:
		MARK(ESC_cosh);
		status = pr_cosh();
		break;
	    case PR_tanh:
		MARK(ESC_tanh);
		status = pr_tanh();
		break;
	    case PR_exp:
		MARK(ESC_exp);
		status = pr_exp();
		break;
	    case PR_log:
		MARK(ESC_log);
		status = pr_log();
		break;
	    case PR_log10:
		MARK(ESC_log10);
		status = pr_log10();
		break;
	    case PR_sqrt:
		MARK(ESC_sqrt);
		status = pr_sqrt();
		break;
	    case PR_pow:
		MARK(ESC_pow);
		status = pr_pow();
		break;
	    case PR_abs:
		MARK(ESC_abs);
		status = pr_abs();
		break;
	    case PR_sign:
		MARK(ESC_sign);
		status = pr_sign();
		break;
	    case PR_ceil:
		MARK(ESC_ceil);
		status = pr_ceil();
		break;
	    case PR_floor:
		MARK(ESC_floor);
		status = pr_floor();
		break;
	    case PR_pi:
		MARK(ESC_pi);
		status = pr_pi();
		break;
	    case PR_rand:
		MARK(ESC_rand);
		status = pr_rand();
		break;
	    case PR_deg2rad:
		MARK(ESC_deg2rad);
		status = pr_deg2rad();
		break;
	    case PR_rad2deg:
		MARK(ESC_rad2deg);
		status = pr_rad2deg();
		break;
	    case PR_interrupt:
		MARK(ESC_interrupt);
	    {
		register cellpo ptr = &A[1];
		delnk(ptr);
		*ptr = *A;
		status = SUCCEED;
		break;
	    }
	    case PR_unix:
		MARK(ESC_unix);
		status = pr_unix();
		break;
	    case PR_stat:
		MARK(ESC_stat);
		status = pr_stat();
		break;
	    case PR_look_pipe:
		MARK(ESC_look_pipe);
		status = pr_look_pipe();
		break;
	    case PR_commit_read:
		MARK(ESC_commit_read);
		status = pr_commit_read();
		break;
	    case PR_unlock:
		MARK(ESC_unlock);
		status = pr_unlock();
		break;
	    case PR_init_parlog:
		MARK(ESC_init_parlog);
		status = pr_init_parlog();
		break;
	    case PR_tty_get0:
		MARK(ESC_tty_get0);
		status = pr_tty_get0();
		break;
	    case PR_curr_input:
		MARK(ESC_curr_input);
		status = pr_curr_input();
		break;
	    case PR_curr_output:
		MARK(ESC_curr_output);
		status = pr_curr_output();
		break;
	    case PR_release_port:
		MARK(ESC_release_port);
		status = pr_release_port();
		break;
	    case PR_empty_pipe:
		MARK(ESC_empty_pipe);
		status = pr_empty_pipe();
		break;
	    case PR_is_iport:
		MARK(ESC_is_iport);
		status = pr_is_iport();
		break;
	    case PR_is_oport:
		MARK(ESC_is_oport);
		status = pr_is_oport();
		break;
	    case PR_runtime:
		MARK(ESC_runtime);
		status = pr_runtime();
		break;
	    case PR_decrement:
		MARK(ESC_decrement);
		status = pr_decrement();
		break;
	    case PR_exit:
		MARK(ESC_exit);
	    {
		register cellpo ptr = &A[1];
    		delnk(ptr);
		return(intvl(ptr));	/* return from emulator */
		break;
	    }
	    case PR_set_port:
		MARK(ESC_set_port);
		status = pr_set_port();
		break;
	    case PR_get_port:
		MARK(ESC_get_port);
		status = pr_get_port();
		break;
	    case PR_gensym:
		MARK(ESC_gensym);
		status = pr_gensym();
		break;
	    case PR_ar_int:
		MARK(ESC_ar_int);
		status = pr_ar_int();
		break;
	    case PR_ar_float:
		MARK(ESC_ar_float);
		status = pr_ar_float();
		break;
	    case PR_copy:
		MARK(ESC_copy);
		status = pr_copy();
		break;
	    case PR_load_foreign:
		MARK(ESC_load_foreign);
		status = pr_load_foreign();
		break;
	    case PR_realtime:
		MARK(ESC_realtime);
		status = pr_realtime();
		break;
	    case PR_errno:
		MARK(ESC_errno);
		status = pr_errno();
		break;
	    case PR_getenv:
		MARK(ESC_getenv);
		status = pr_getenv();
		break;
	    case PR_timeslice:
		MARK(ESC_timeslice);
		status = pr_timeslice();
		break;
	    case PR_cursor:
		MARK(ESC_cursor);
		status = pr_cursor();
		break;
	    case PR_ctime:
		MARK(ESC_ctime);
		status = pr_ctime();
		break;
	    case PR_gc_usage:
		MARK(ESC_gc_usage);
		status = pr_gc_usage();
		break;
	    case PR_format_print_float:
		MARK(ESC_format_print_float);
		status = pr_format_print_float();
		break;
	    case PR_format_print_integer:
		MARK(ESC_format_print_integer);
		status = pr_format_print_integer();
		break;
	    case PR_line_position:
		MARK(ESC_line_position);
		status = pr_line_position();
		break;
	    case PR_line_count:
		MARK(ESC_line_count);
		status = pr_line_count();
		break;
	    case PR_setenv:
		MARK(ESC_setenv);
		status = pr_setenv();
		break;
	    case PR_suspend_th:
		MARK(ESC_suspend_th);
		status = pr_suspend_th();
		break;
	    case PR_tcp_init:
		status = pr_tcp_init();
		break;
	    case PR_socket:
		status = pr_socket();
		break;
	    case PR_setsockopt:
		status = pr_setsockopt();
		break;
	    case PR_getsockopt:
		status = pr_getsockopt();
		break;
	    case PR_bind:
		status = pr_bind();
		break;
	    case PR_listen:
		status = pr_listen();
		break;
	    case PR_accept:
		status = pr_accept();
		break;
	    case PR_connect1:
		status = pr_connect1();
		break;
	    case PR_connect2:
		status = pr_connect2();
		break;
	    case PR_send:
		status = pr_send();
		break;
	    case PR_recv:
		status = pr_recv();
		break;
	    case PR_sendto:
		status = pr_sendto();
		break;
	    case PR_recvfrom:
		status = pr_recvfrom();
		break;
	    case PR_sendbr:
		status = pr_sendbr();
		break;
	    case PR_checkrecv:
		status = pr_checkrecv();
		break;
	    case PR_checkconn:
		status = pr_checkconn();
		break;
	    case PR_tcp_close:
		status = pr_tcp_close();
		break;
	    case PR_getsockaddr:
		status = pr_getsockaddr();
		break;
	    case PR_getpeeraddr:
		status = pr_getpeeraddr();
		break;
	    case PR_gethost:
		status = pr_gethost();
		break;
	    case PR_getport:
		status = pr_getport();
		break;
	    case PR_real_socket:
		status = pr_real_socket();
		break;

	    default:
		MARK(ESC_overhead);
		(void)printf("escape %d : no such service function.\n", *(P-1));
		status = FAIL;
	    }

	    MARK(ESC_prologue);
	    switch (status) {
		case SUCCEED:	continue;
		case FAIL:	ERR_PT = (codepo) 0; goto fail_label;
		case AR_ERROR:	P = ERR_PT; ERR_PT = (codepo) 0; continue;
		case REQUEUE:
		    h_deadlock = 0;
		case WAIT:
		    P -= 2;	/* redo the escape code when resumed */

		    /* simulate a 'resume(0)' call */
		    sP = P;		/* load shadow reg */
		    if (resume((threadpo)NULL, FALSE))
			return(-1);	/* EXIT FROM FUNCTION 'SOLVE' */
		    else if (nonempty_fdset())
			wait_for_user();
		    continue;
		    break;
		case SUSPEND:
		case SUSPEND_FOR_EVENT:
		    if (h_debug)
			(void)fprintf(stderr, "[ suspend %ld ]\n", TH);
		    P -= 2;	/* redo the escape code when resumed */
		    if (!remove_from_runq(TH))
			continue;
		    h_deadlock = 0;
		    /* simulate a 'resume(0)' call */
		    sP = P;		/* load shadow reg */
		    if (resume((threadpo)NULL, FALSE))
			return(-1);	/* EXIT FROM FUNCTION 'SOLVE' */
#ifndef HERMES
		    else if (TH == prolog_th)
			longjmp(icp_interrupt, 408);
#endif
		    else {
			save_thread(TH);
			(void)fprintf(stderr, "[ forcing prolog supervisor ]\n");
			(void) resume(prolog_th, TRUE);
			return(-1);	/* EXIT FROM FUNCTION 'SOLVE' */
		    }
		    break;
		default:
		    longjmp(icp_interrupt, 409);
	    }
	}
