/* Copyright (C) 1992 Imperial College */
#include "icp.h"
#include "events.h"
#include "symtab.h"

runqpt RQ = NULL;

extern codepo	search_symbol();
extern void	interrupt_handler();
extern jmp_buf	icp_interrupt;

extern int	h_deadlock;
#ifdef HERMES
extern void	global_read_select(),
		global_select_select();
#endif

extern symbpo	interrupt_sym;
extern threadpo prolog_th, parlog_th;
extern threadpo TH;
extern choicepo B, SB, CSB;
extern codepo sP, CP;
extern int	signal_mask;

eventpt eventq = NULL;

threadpo next_thread(th)
threadpo th;
{
	return(RQ->th);
}

bool add_to_runq(th, after)
threadpo th;
bool after;
{
	runqpt rq;

	if (th->rq)
		return(SUCCEED);

	if (!(rq = (runqpt) malloc((size_t) (sizeof(struct runq)))))
		longjmp(icp_interrupt, 613);

	if (!RQ) {
		RQ = rq;
		RQ->next = RQ->prev = rq;
	}
	/* rq->event = ??? */
	th->rq = rq;
	rq->th = th;
	if (after) {
		rq->prev = RQ;
		rq->next = RQ->next;
		(rq->next)->prev = rq;
		RQ->next  = rq;
	} else {
		rq->next = RQ;
		rq->prev = RQ->prev;
		(rq->prev)->next = rq;
		RQ->prev  = rq;
	}

	h_deadlock = 0;
	return(SUCCEED);
}

bool remove_from_runq(del_th)
threadpo	del_th;
{
	runqpt	rq = del_th->rq;
	int	old_mask;

	if (!rq)	/* may have been removed from run queue already */
		return(SUCCEED);

	del_th->rq = NULL;

	if (rq->next == rq) {	/* run queue contains only myself */
		/* block interrupts */
		old_mask = sigblock(signal_mask);
		free((char *)rq);
		RQ = NULL;
		while (RQ == NULL) {
			/* fprintf(stderr, "\nPotential Deadlock.  Waiting for signals ...\n"); */
			(void) sigpause(0);
			/* relying on event processing to add to run queue */
			if (eventq && (event_handler(TRUE) == INTERRUPT))
				interrupt_handler();
		}
		/* unblock interrupts */
		(void) sigsetmask(old_mask);
		return(FAIL);
	} else {
		(rq->prev)->next = rq->next;
		(rq->next)->prev = rq->prev;
		if (RQ == rq)
			RQ = RQ->prev;
		free((char *)rq);
		return(SUCCEED);
	}
}

event_handler(in_thread)
bool	in_thread;
{
	eventpt e, newq = NULL;
	int	old_mask,
		ret = PROCEED;

	old_mask = sigblock(signal_mask);

	while ((e = eventq)) {
		eventq = e->next;
		switch (e->type) {
			case EVENT_TIME_SLICE:
			case EVENT_CTRLC:
				e->next = newq;
				newq = e;
				continue;
				break;
			case EVENT_IO_READ:
				global_read_select();
				break;
			case EVENT_IO_EXCEPT:
				global_except_select();
				break;
		}
		free_event(e);
	}

	eventq = newq;

	if (eventq && in_thread) {
		if (newq->type == EVENT_CTRLC)
			ret = INTERRUPT;
		else if (newq->type == EVENT_TIME_SLICE && RQ->next != RQ)
			ret = RETURN;
		eventq = newq->next;
		free_event(newq);
	}

	(void) sigsetmask(old_mask);
	return(ret);
}
