/* Copyright (C) 1992 Imperial College */
#include "primitives.h"
#include "events.h"

#if defined(THINK_C) || defined(GNUDOS)
/* Think C does not know about SIGVTALRM, so set it to some other signal */
#define SIGVTALRM	SIGFPE
#endif

#ifdef HERMES
#define E_PROLOG	64	/* parlog event flag to switch to prolog */
extern void	catch_intrpt();
extern int	*event;
#endif
extern void	icp_exit();
extern int	h_deadlock;
extern threadpo	prolog_th;
extern eventpt	eventq;

/* forward reference */
void	interrupt_handler();

int	signal_mask = ( sigmask(SIGINT) | sigmask(SIGVTALRM) | sigmask(SIGIO) |
			sigmask(SIGURG) );

#define MAXEVENT 100

struct event_s events[MAXEVENT];
eventpt ev_free = NULL;
int	ev_top = 0;

eventpt
new_event()
{
	eventpt next = ev_free;

	if (ev_free)
		ev_free = ev_free->next;
	else {
		next = &events[ev_top];
		if (ev_top++ == MAXEVENT) {
			(void) fprintf(stderr, "ERROR: too many events\n");
			icp_exit(1);
		}
	}
	return(next);
}

free_event(e)
eventpt e;
{
	free(e->value);
	e->next = ev_free;
	ev_free = e;
}

void
sig_int()
{
	register	old_mask = sigblock(signal_mask);
	eventpt	e, prev;

#ifdef HERMES
	if (TH && !(TH->prolog)) {
		catch_intrpt();
		goto end_int;
	}
#endif
	/* assume to be a prolog thread */
	if (eventq) {
		e = eventq;
		prev = NULL;
		while (e) {
			if (e->type == EVENT_CTRLC) {
				if (prev)
					prev->next = e->next;
				else
					eventq = e->next;
				free_event(e);
				interrupt_handler();
				goto end_int;
			}
			else {
				prev = e;
				e = e->next;
			}
		}
	}
	e = new_event();
	e->next = eventq;
	e->value = NULL;
	e->type = EVENT_CTRLC;
	eventq = e;

end_int:
	(void) sigsetmask(old_mask);
}

void
sig_vtalrm()
{
	register	old_mask = sigblock(signal_mask);
	eventpt e;

#ifdef HERMES
	if (TH && !(TH->prolog)) {
		*event |= E_PROLOG;
		goto end_vtalrm;
	}
#endif
	/* assume to be a prolog thread */
	e  = eventq;

	while (e) {
		if (e->type == EVENT_TIME_SLICE)
			break;
		e = e->next;
	}
	if (!e) {
		e = new_event();
		e->next = eventq;
		e->value = NULL;
		e->type = EVENT_TIME_SLICE;
		eventq = e;
	}

end_vtalrm:
	(void) sigsetmask(old_mask);
}

void
sig_io()
{
	register	old_mask = sigblock(signal_mask);
	eventpt e;
	e = new_event();
	e->next = eventq;
	e->value = NULL;
	e->type = EVENT_IO_READ;
	eventq = e;
	h_deadlock = 0;
	(void) sigsetmask(old_mask);
}

void
sig_urg()
{
	register	old_mask = sigblock(signal_mask);
	eventpt e;
	e = new_event();
	e->next = eventq;
	e->value = NULL;
	e->type = EVENT_IO_EXCEPT;
	eventq = e;
	h_deadlock = 0;
	(void) sigsetmask(old_mask);
}

void timeslice(on)
int on;
{
	register	old_mask;
	static int	counter = 0;
	eventpt		ev, prev;
	if (on) {	/* allow timeslice signals */
		if (--counter <= 0) {
			counter = 0;
			(void)signal(SIGVTALRM, sig_vtalrm);
		}
	}
	else {
		counter++;
		(void)signal(SIGVTALRM, SIG_IGN);

		old_mask = sigblock(signal_mask);
		/* remove entry (if any) from event queue */
		ev  = eventq;
		prev = NULL;
		while (ev) {
			if (ev->type == EVENT_TIME_SLICE)
				break;
			prev = ev;
			ev = ev->next;
		}
		if (ev) {
			if (prev)
				prev->next = ev->next;
			else
				eventq = ev->next;
			free_event(ev);
		}
		(void) sigsetmask(old_mask);
	}
}

bool pr_timeslice()
{
	cellpo arg1 = &A[1];

	delnk(arg1);
	if (NotInt(arg1))
		return(FAIL);
	timeslice((int) intvl(arg1));
	return(SUCCESS);
}

void
interrupt_handler()
{
    CHARTYPE ch;
    int old_mask;

    /* switch off interrupts */
    old_mask = sigblock(signal_mask);

    (void)fprintf(stderr, "\n\nbreak !\ntype ? for help\n");

prompt:
	(void)fprintf(stderr, "\nSystem interruption ? [n] ");

	if ((ch = getchar()) == EOF)		/* read first char and ...  */
	    icp_exit(0);

	if (ch == '\n')
	    (void)ungetc(ch, stdin);
	while (getchar() != '\n');		/* skip rest of line */

	switch (ch) {
	    case 'a':
	    case 'c':
	    case 'y':
	    case 'n':
	    case '\n':
		break;
	    case 'd':
		debugger(CP);
		break;
	    case 'e':
		icp_exit(0);
		break;
	    default:
		(void)fprintf(stderr, "\nOptions :\n");
		(void)fprintf(stderr, "   y,a    abort    - abort this query\n");
		(void)fprintf(stderr, "   n,c    continue - do nothing\n");
		(void)fprintf(stderr, "    d     debug    - enter ICP debugger\n");
		(void)fprintf(stderr, "    e     exit     - exit IC Prolog ][\n");
		(void)fprintf(stderr, "    ?     help     - display this list\n");
		goto prompt;
        }

    /* restore interrupts */
    (void) sigsetmask(old_mask);

    if (ch == 'a' || ch == 'y') {
	/* first make sure the prolog top level query handler is in the run queue */
	(void) add_to_runq(prolog_th, FALSE);
	(void)fprintf(stderr, "\n--- ABORTED ---\n\n");
	longjmp(icp_interrupt, 999);
    }
}
