/* Copyright (C) 1992 Imperial College */
/* pjs 12.9.90 the size of the dictionary is now doubled whenever necessary */
/* pjs 24.7.90 increased SYMTABSIZE by 50 */
/* pjs 24.5.90 changed pr_defined and search_symbol */
/* pjs 22.5.90 added pr_inc() */

#include "primitives.h"
#include "symtab.h"
#include "dynamic.h"
#include "opcodes.h"
#include "foreign.h"

#ifdef ANSI
#else
extern char	*memset();
#endif

extern void	printName();
extern bool	samesymb();

#define MEMORY_MAP	"memory.map"
#define	SYMTABSIZE	1000
#define LOAD_FACTOR	0.859
#define GROW_FACTOR	2

extern codepo		boot;
extern int		debugLevel;
extern codepo 		grab_code();
extern symbpo		undef_sym;

dictionary	symtab,		/* the symbol table */
		symtab_top;	/* the end of the table */
static
dictionary	nextFree;	/* the next free entry 	*/
int		divisor;	/* The Address Size */
int		symtabsize;	/* The Table Size */

segment	seglist;	/* The segment list */
segment	newseg;		/* The last segment loaded */

bool loadicp();


#define add_pred(name, ar) {		\
		alloc_list(next, next);	\
		mksymb(next, name);	\
		next++;			\
		alloc_list(next, next);	\
		mkint(next, ar);	\
		next++; }



dictionary
alloc_dict()
{
    while (nextFree->con && nextFree >= symtab)
	nextFree--;
    if (nextFree < symtab)
	return(NULL);
    return(nextFree);
}

bool
init_loader()
{
    /* initialise symbol table */
    symtabsize = SYMTABSIZE;
    divisor = symtabsize * LOAD_FACTOR;
    symtab = (dictionary) alloc(symtabsize, sizeof(struct dict));
	(void) memset((char *) symtab, 0, (int) (symtabsize*sizeof(struct dict)));
    if (!symtab)
    	return(FAIL);
    symtab_top = nextFree = symtab + symtabsize - 1;
    return(SUCCEED);
}

/* this searches the symbol table */
codepo
search_symbol(symbol, arit)
symbpo	symbol;
twoBytes arit;
{
    register
    dictionary	probe = symtab + symbhashval(symbol) % divisor;

    if (probe < symtab)
	probe += divisor;

    for (;;) {
	if (probe->con && arit == probe->ar && samesymb(symbol, probe->con)) {
	    if (!probe->addr) /* not defined yet */
		return(NULL);
	    else return(probe->addr);	/* found it ! */
	}
	else if (!probe->link) {	/* if end of chain, then not in table */
	    return(NULL);
	}
	else probe += probe->link;	/* otherwise follow the chain */
    }
}


/* find non-existing references */
noref()
{
    register
    dictionary probe = symtab + SYMTABSIZE;

    (void) fprintf(stderr, "\npredicates which are referenced but not defined :\n\n");
    while (--probe >= symtab) {
	if (probe->con && !probe->addr && probe->type != EXTERNAL) {
	    printName(probe->con, stderr);
	    (void) fprintf(stderr, "/%d\n", probe->ar);
	}
    }
}

/* list all predicates */
refs()
{
    register
    dictionary	probe = symtab + SYMTABSIZE;
    FILE	*listing;

    listing = fopen(MEMORY_MAP, "w");

    while (--probe >= symtab) {
	if (probe->con && probe->addr) {
	    (void) fprintf(listing, "%8ld ", PC(probe->addr));
	    printName(probe->con, listing);
	    (void) fprintf(listing, "/%d\n", probe->ar);
	}
    }

    (void) fclose(listing);
}

/* constructs a new dictionary which is twice the size of the current one
   and deletes the latter after rehashing its contents into the new table */
void
resize_dict()
{
    dictionary	probe,
		p = symtab + symtabsize - 1;
    segment	s;
    int		i = symtabsize;

    symtabsize *= GROW_FACTOR;
    if (!(symtab = (dictionary) alloc(symtabsize, sizeof(struct dict))))
	longjmp(icp_interrupt, 608);
    (void) memset((char *) symtab, 0, (int) (symtabsize*sizeof(struct dict)));
    symtab_top = nextFree = symtab + symtabsize - 1;
    divisor = symtabsize * LOAD_FACTOR;

    /*
     * go through the current dictionary and hash 
     * each of its entries into the new one
     */
    for (; i--; p--) {
	if (p->con) {
	    probe = symtab +  symbhashval(p->con) % divisor;
	    if (probe < symtab)
	    	probe += divisor;
	    for (;;) {
		if (!probe->link) {	/* if end of chain, add symbol to new table */
		    if (probe->con) {
			while (nextFree->con)
			    nextFree--;
			*nextFree = *p;
			nextFree->link = 0;
			probe->link = nextFree - probe;
			break;
	            }
	            else {
			*probe = *p;
			probe->link = 0;
	            	break;
	            }
	    	}
	        probe += probe->link; /* otherwise follow the chain */
            }
	}
    }

    /* release the space occupied by the current dictionary */
    free((char*)++p);

    /*
     * re-fix the external table of each live segment 
     * so that it refers to the new dictionary
     */
    s = seglist;
    while (s) {
	fix_externs(segExt(s), segLoc(s));
	s = segNext(s);
    }
}

dictionary get_entry(pred, arit)
symbpo pred;
twoBytes arit;
{
    register
    dictionary	probe, entry, empty = NULL;

    probe = symtab + symbhashval(pred) % divisor;

    if (probe < symtab)
	probe += divisor;

    for (;;) {
	if (probe->con && probe->ar == arit && samesymb(pred, probe->con)) {
	    return(probe); /* entry already in table */
	}
	if (!probe->link) { /* if end of chain, add new symbol to table */
	    if (empty) { /* if an empty record was found then re-use that */
    		empty->ar = (short)arit;
    		empty->con = pred;
    		return(empty);
	    } else { /* get a new record and initialise that */
	    	if (!(entry = probe->con ? alloc_dict() : probe)) {
	    	    resize_dict();
	    	    return(get_entry(pred, arit));
	    	}
	    	entry->ar = (short)arit;
	    	entry->con = pred;
	    	probe->link = entry - probe;
	    	return(entry);
	    } 
	}
	if (probe->con == NULL) { /* record the address of an empty record */ 
	    empty = probe;
	}
	probe += probe->link;	/* otherwise follow the chain */
    }
}

dictionary find_entry(pred, arit)
symbpo pred;
twoBytes arit;
{
    register
    dictionary	probe;
    probe = symtab + symbhashval(pred) % divisor;

    if (probe < symtab)
	probe += divisor;

    for (;;) {
	if (probe->con && probe->ar == arit && samesymb(pred, probe->con))
	    return(probe);		/* already in table */
	if (probe->link)
	    probe += probe->link;	/* otherwise follow the chain */
	else return(NULL);
    }
}

/* A[2] is assumed to be a variable */
bool
pr_defined()
{
    register
    cellpo	pred = &A[1],
		address = &A[2],
		func, arit;

    codepo	addr = NULL;
    dictionary	dict;

    delnk(pred);
    delnk(address);

    if (IsSymb(pred) &&
	(dict = find_entry(symbvl(pred), 0)) &&
	(addr = dict->addr) &&
	(dict->type == DYNAMIC)) {
	codepo p = addr; /* p points to opcode field of fdynamic instr */
	findFirst(p, C);
	if (p==NULL) addr = NULL;
    }
    else if (IsTpl(pred) && arity(pred) == 3) {
	func = arg(pred, 1);
	delnk(func);
	arit = arg(pred, 2);
	delnk(arit);
	if (IsSymb(func) &&
	    IsInt(arit) &&
	    (dict = find_entry(symbvl(func), (twoBytes)intvl(arit))) &&
	    (addr = dict->addr) &&
	    (dict->type == DYNAMIC)) {
	codepo p = addr; /* p points to opcode field of fdynamic instr */
	findFirst(p, C);
	if (p==NULL) addr = NULL;
	}
    }
    if (addr) {
	mkreset(address);
	mkint(address, PC(addr));
	return(SUCCEED);
    }
    return(FAIL);

}



twoBytes
load_code(where, count)
codepo		where;
twoBytes	count;
{
    if (io_type(current_input) == IN_STREAM)
	return(fread((char *)where, 2, (SIZE_TYPE)count, fdes(current_input)));

    else if (io_type(current_input) == IN_RAM) {
	int i = 2*count;
	if (count == 1 && (char)*(ramd(current_input)->current) == EOF)
	    return(0);		/* end of memory file */
	(void)memcpy((char *)where, (char *)(ramd(current_input)->current),
		     (SIZE_TYPE)i);
	ramd(current_input)->current += i;
	return(count);
    }

    else {
	(void) fprintf(stderr, "don't know where to load from !\n");
	return(0);
    }
}



/* Load a unit of binary code from current input */
bool
pr_load()
{
	cellpo arg1 = &A[1];
	short file_type;
	int ret;

	delnk(arg1);
	if (IsSymb(arg1) && !strcmp(string_val(arg1), "system"))
		file_type = SYSTEM;
	else
		file_type = USER;

	timeslice(0);
	ret = loadicp(file_type);
	timeslice(1);
	return(ret);
}

bool loadicp(file_type)
short file_type;
{
    twoBytes	len;
    codepo 	start, temp;

    if (load_code((codepo)&len, 1) != 1)
	return(FAIL);		/* end of file */


    if(!(start = (codepo) alloc(len+1, 2)))
	throw(613);

    if (!(newseg = (segment) malloc(sizeof(struct segmnt))))
	throw(613);

    *start = len;

    if (load_code(start+1, len) != len) {
	free((char *)start);
	throw(304);
    }

    temp = start + HEAD_SIZE;

    segStart(newseg) = start;
    segSize(newseg)  = seg_len(start);
    segLoc(newseg)   = temp + seg_ent(start);
    segCon(newseg)   = temp + seg_con(start);
    segExt(newseg)   = temp + seg_ext(start);
    segType(newseg)  = file_type;
    segSaved(newseg) = 0;

    return(SUCCEED);
}

bool pr_undo_seg()
{
    free((char *)segStart(newseg));
    free((char *)newseg);
    return(SUCCEED);
}

bool pr_set_up_seg()
{
    register
    cellpo	ramfile = &A[1];
    codepo	start, base;
    delnk(ramfile);
    start  = grab_code((int)intvl(ramfile));
    base   = start + HEAD_SIZE;

    if (!(newseg = (segment) malloc(sizeof(struct segmnt))))
	throw(613);

    segStart(newseg) = start;
    segSize(newseg)  = seg_len(start);
    segLoc(newseg)   = base + seg_ent(start);
    segCon(newseg)   = base + seg_con(start);
    segExt(newseg)   = base + seg_ext(start);
    segType(newseg)  = USER;
    segSaved(newseg) = 0;
    
    return(SUCCEED);
}

/*
 * fix externals recording information about the location of predicate constants
 */
fix_externals(segno, extrn, endextrn)
segment segno;
codepo 	extrn, endextrn;
{
    register
    dlist	new;
    twoBytes 	arit;
    symbpo 	pred;
    dictionary	dict;

    for (; extrn < endextrn; extrn += EXT_SIZE) {
	arit = ext_arity(extrn);
	pred = ext_pred(extrn);
	dict = get_entry(pred, arit);
	ext_dict(extrn) = dict;
	if (!(new = (dlist)malloc(sizeof(struct d_entry))))
	    longjmp(icp_interrupt, 608);
	new->segptr = segno;
	new->con = pred;
	if (dict->d) {
	    new->next = dict->d->next;
	    dict->d->next = new;
	}
	else {
	    new->next = dict->d;
	    dict->d = new;
	}
    }
}

fix_externs(extrn, endextrn) /* fix externals */
codepo 	extrn, endextrn;
{
    register
    twoBytes 	arit;
    symbpo 	pred;
    dictionary	dict;

    for (; extrn < endextrn; extrn += EXT_SIZE) {
	arit = ext_arity(extrn);
	pred = ext_pred(extrn);
	dict = get_entry(pred, arit);
	ext_dict(extrn) = dict;
    }
}

bool
pr_validate()
/*
ASSUMPTIONS:Defined and Flag are both unbound variables.
EFFECTS:[1]  Defined is instantiated to a list of the form [P1,A1,...,
	Pn,An] where the Pi's and Ai's are the names and arities of
	the local predicates of the last segment segment to be
	loaded via pr_load. The list can be used to make explicit
	the redefinition of these predicates.
	[2]  Flag is instantiated to one if the segment is static, zero if
	the segment is static and its principal predicate is already
	defined, and two if the segment is dynamic.
NOTES:	Dynamic segments have exactly one local predicate. This is
	either a dynamic predicate (<foo>/<n> say) or a system
	predicate of the form '$c$<foo>'/<n>+1, or the system
	predicate '$c$'/2. When the segment to be validated is that
	for a clause of either of these system predicates,
	pr_validate instantiates Defined to the empty list.
*/
{
    register
    cellpo	next;
    cellpo	Defined = &A[1],
		Flag	= &A[2];
    codepo	start,
		entry,
		entries,
		constants,
		clause = NULL;
    twoBytes 	ar;
    symbpo	name;
    dictionary	d;

    entries = segLoc(newseg);
    constants = segCon(newseg);

    (void) gc_test((fourBytes)(constants-entries)/ENT_SIZE * 4, 2);

    delnk(Defined);
    delnk(Flag);

    mkreset(Defined);
    mkreset(Flag);

    next = Defined;
    start = segStart(newseg) + HEAD_SIZE;

    if (*start == dynamic || *start == fdynamic) {
	*start = dynamic;
	mkint(Flag, 2);
	name  = ent_pred(entries);
	ar = ent_arity(entries);
	if ((d = find_entry(name, ar)) && d->addr) {
	    if (d->type == DYNAMIC) {
	    	clause = d->addr;
	    	findFirst(clause, C);
		if (clause && strncmp("$c$", symbname(name), 3))
	    	    add_pred(name, ar);
	    } else add_pred(name, ar);
	}
    } else {
	mkint(Flag, 0);
	for (entry = entries; entry < constants; entry += ENT_SIZE) {
	    name  = ent_pred(entry);
	    ar = ent_arity(entry);
	    if ((d = find_entry(name, ar)) && (clause = d->addr)) {
	    	if (d->type == DYNAMIC)
	    	   findFirst(clause, C);
		if (clause) {
	    	   if(entry == entries)
		   	mkint(Flag, 1);
	    	   add_pred(name, ar);
	    	}
	    }
	}
    }
    mknil(next);
    return(SUCCEED);
}


new_dictionary_list(dict, seg, pred)
dictionary	dict;
segment		seg;
symbpo		pred;
{
	dlist	new;

	dict->con = pred;

	if (!(new = (dlist)malloc(sizeof(struct d_entry))))
	    longjmp(icp_interrupt, 608);
	new->segptr = seg;
	new->con = pred;
	new->next = dict->d;
	dict->d = new;
}


void fix_entries(segno, start, entry, endentry)
segment segno;
codepo start, entry, endentry;
{
    register
    dictionary	dict;
    twoBytes 	arit,
		predcount;
    symbpo 	pred;

    for (predcount = 0; entry < endentry; entry += ENT_SIZE, predcount++) {
	arit = ent_arity(entry);
	pred = ent_pred(entry);
	dict = get_entry(pred, arit);

	new_dictionary_list(dict, segno, pred);

	dict->addr = start + HEAD_SIZE + ent_addr(entry);
	dict->seg = segno;
	dict->entry = entry;
	dict->type = STATIC;
    }
    segPred(segno) = predcount;
}

link_segment(seg)
segment	seg;
{
    segPrev(seg) = NULL;
    segNext(seg) = seglist;
    if (seglist)
	segPrev(seglist) = seg;
    seglist = seg;
}

bool pr_fix_tables()
{
    link_segment(newseg);

    fix_externals(newseg, segExt(newseg), segLoc(newseg));
    fix_entries(newseg, segStart(newseg), segLoc(newseg), segCon(newseg));

    return(SUCCEED);
}

/*------------------------------------------------------------*/
/*			meta-calls			      */
/*------------------------------------------------------------*/

bool
pr_meta(Pptr)
codepo	*Pptr;
{
    cell	c;
    register	cellpo	goal = &c, temp;
    fourBytes	i;
    twoBytes	ar = 0;
    bool	(*funct)();

    c = A[1];
    delnk(goal);

    if (IsTpl(goal)) {		/* does the goal have arguments ? */
	for (i=1; i<arity(goal); i++) {	/* if so, unpack them */
	    temp = arg(goal, i);
	    delnk(temp);
	    A[i] = *temp;
	}
	/* get the predicate symbol */
	ar = arity(goal) - 1;
	goal = arg(goal, 0);
	delnk(goal);
    }

    debug(1, fprintf(stderr, "meta-call: ");
	     printName(symbvl(goal), stderr);
	     fprintf(stderr, "/%d\n", ar));

    if (NotSymb(goal))
	return(FAIL);
    if (!(*Pptr=search_symbol(symbvl(goal), ar))) {
	if (IsSymb(goal) && (funct = search_foreign(symbvl(goal), ar))) {
	    /* save the goal term in case function returns SUSPEND or REQUEUE */
	    A[0] = c;
	    *Pptr = (codepo) funct;
	    return(FAIL);
	}
	else {
	    A[0] = c;
	    *Pptr = search_symbol(undef_sym, 0);
	}
    }
    return(SUCCEED);
}
