/* Copyright (C) 1992 Imperial College */
#include "primitives.h"
#include "symtab.h"
#include "dynamic.h"

extern dictionary symtab_top;

static int no_system_preds = 0;
#define predicate_type(entry) ((no_system_preds || entry->type == EXTERNAL) \
					? USER : segType(entry->seg))

extern symbpo system_sym, user_sym, dynamic_sym, static_sym, external_sym;

bool pr_pred_look()
{
    register
    dictionary	entry;
    cellpo	name		= &A[1],
		arit		= &A[2],
		segtype		= &A[3],
		storetype	= &A[4];
    codepo	addr;

    delnk(name);
    delnk(arit);

    entry = find_entry(symbvl(name),(twoBytes)intvl(arit));
    if(entry && (entry->addr || entry->type == EXTERNAL)) {
        delnk(segtype);
	mkreset(segtype);
	delnk(storetype);
	mkreset(storetype);
	if (entry->type == DYNAMIC) {
	    addr = entry->addr;
	    findFirst(addr, C);
	    if (!addr)
		return(FAIL);
	    if (strncmp("$c$",(char*)symbname(entry->con),3))
		mksymb(segtype, user_sym);
	    else
		mksymb(segtype, system_sym);
	} else if (predicate_type(entry) == SYSTEM)
		mksymb(segtype, system_sym);
	else
		mksymb(segtype, user_sym);
	if (entry->type == STATIC)
		mksymb(storetype, static_sym);
	else if (entry->type == DYNAMIC)
		mksymb(storetype, dynamic_sym);
	else if (entry->type == EXTERNAL)
		mksymb(storetype, external_sym);
	return(SUCCEED);
    }
    return(FAIL);
}

dictionary get_pred(in,segtype,storetype)
fourBytes in;
short *segtype, *storetype;
{
    register
    dictionary entry = symtab + ++in;

    for (;;) {
	if (entry > symtab_top) /* reached end of table */
	    return(NULL);
	if ((*storetype == ANY_PRED || *storetype == entry->type) &&
		(entry->addr || entry->type == EXTERNAL)) {
	    switch (entry->type) {
		    case STATIC:
			switch (*segtype) {
				case USER:
				    if (predicate_type(entry) ==  USER) {
					*storetype = STATIC;
					return(entry);
				    }
				    break;
				case SYSTEM:
				    if (predicate_type(entry) == SYSTEM) {
					*storetype = STATIC;
					return(entry);
				    }
				    break;
				case ANY_SEG:
				    *segtype = predicate_type(entry);
				    *storetype = STATIC;
				    return(entry);
				    break;
			}
			break;
		    case DYNAMIC: {
			codepo addr = entry->addr;
			findFirst(addr, C);
			/* found a defined dynamic predicate */
			if (addr) {
			    int user_pred = strncmp("$c$",(char*)symbname(entry->con),3);
			    switch (*segtype) {
				    case USER:
					if (user_pred) {
					    *storetype = DYNAMIC;
					    return(entry);
					}
					break;
				    case SYSTEM:
					if (!user_pred) {
					    *storetype = DYNAMIC;
					    return(entry);
					}
					break;
				    case ANY_SEG:
					*segtype = (user_pred ? USER : SYSTEM);
					*storetype = DYNAMIC;
					return(entry);
					break;
			    }
			}
			break;
		    }
		    case EXTERNAL: {
			switch (*segtype) {
				case USER:
				    if (predicate_type(entry) ==  USER) {
					*storetype = EXTERNAL;
					return(entry);
				    }
				    break;
				case SYSTEM:
				    if (predicate_type(entry) == SYSTEM) {
					*storetype = EXTERNAL;
					return(entry);
				    }
				    break;
				case ANY_SEG:
				    *segtype = predicate_type(entry);
				    *storetype = EXTERNAL;
				    return(entry);
				    break;
			}
			break;
		    }
	    }
	}
	entry++;
    }
}


/************************************************************************/
/*	'pred_get%f'(Name, Arity, I, J, SegType, Storage)		*/
/*		SegType is system (0) or user (1)			*/
/*		Storage is static (0) or dynamic (1)			*/
/************************************************************************/
bool pr_pred_get()
{
    register
    dictionary	entry;

    cellpo	name		= &A[1],
		arit		= &A[2],
		in		= &A[3],
		out		= &A[4],
		SegType		= &A[5],
		StorageType	= &A[6];
    short	segtype,
		storetype;

    delnk(name);
    delnk(arit);
    delnk(in);
    delnk(out);
    delnk(SegType);
    delnk(StorageType);

    if (IsVar(SegType))
	segtype = ANY_SEG;
    else if (!IsSymb(SegType))
	return(FAIL);
    else if (!strcmp(string_val(SegType), symbname(user_sym)))
		segtype = USER;
    else if (!strcmp(string_val(SegType), symbname(system_sym)))
		segtype = SYSTEM;
    else
	 return(FAIL);

    if (IsVar(StorageType))
	storetype = ANY_PRED;
    else if (!IsSymb(StorageType))
	return(FAIL);
    else if (!strcmp(string_val(StorageType), symbname(static_sym)))
	storetype = STATIC;
    else if (!strcmp(string_val(StorageType), symbname(dynamic_sym)))
	storetype = DYNAMIC;
    else if (!strcmp(string_val(StorageType), symbname(external_sym)))
	storetype = EXTERNAL;
    else
	 return(FAIL);

    if (entry = get_pred(intvl(in),&segtype,&storetype)) {
	mkreset(name);
	mkreset(arit);
	mkreset(out);
	mksymb(name,entry->con);
	mkint(arit,entry->ar);
	mkint(out,entry - symtab);
	if (IsVar(SegType)) {
	    mkreset(SegType);
	    if (segtype == SYSTEM)
		mksymb(SegType, system_sym);
	    else
		mksymb(SegType, user_sym);
	}
	if (IsVar(StorageType)) {
	    mkreset(StorageType);
	    if (storetype == STATIC)
		mksymb(StorageType, static_sym);
	    else if (storetype == DYNAMIC)
		mksymb(StorageType, dynamic_sym);
	    else
		mksymb(StorageType, external_sym);
	}
	return(SUCCEED);
    }
    return(FAIL);
}

/*
   pr_system() takes one integer argument.
   If the argument is 0, protection mode is turned off.
   If the argument is non 0, protection mode is turned on.
*/
bool
pr_system()
{
    cellpo	reg1 = &A[1];

    delnk(reg1);
    if (NotInt(reg1))
	return(FAIL);

    if (intvl(reg1) == 0)
	no_system_preds = 1;
    else
	no_system_preds = 0;

    return(SUCCEED);
}
