/* Copyright (C) 1992 Imperial College */
/*
 * segment structure
 */

typedef struct segmnt {
	codepo	start,
		externals,
		entries,
		constants;	
	short	predno,
		size,
		type;
	bool	saved;
	struct segmnt *prev;
	struct segmnt *next;
} *segment;

#define	segStart(Seg) 	Seg->start
#define	segExt(Seg) 	Seg->externals
#define	segLoc(Seg) 	Seg->entries
#define	segCon(Seg) 	Seg->constants
#define	segPred(Seg) 	Seg->predno
#define	segSize(Seg) 	Seg->size
#define segType(Seg)	Seg->type
#define segSaved(Seg)	Seg->saved
#define segPrev(Seg)	Seg->prev
#define segNext(Seg)	Seg->next

/* segment types */
#define	USER		1
#define	SYSTEM		2
#define	ANY_SEG		-1

extern segment	seglist;	/* The segment list */
extern segment	newseg;		/* The most recently loaded segment */



/*
 * dictionary structure
 */

typedef struct d_entry {
	segment	segptr;		/* segment containing reference to constant */
	symbpo	con;		/* the constant	*/
	struct	d_entry	*next;
} *dlist;

typedef struct dict {
    codepo	addr;	/* address of code */
    segment	seg;	/* segment containing definition */
    codepo	entry;	/* address of its defining entry */
    dlist	d;	/* list of references for this predicate */
    symbpo	con;	/* the functor itself */
    short	ar;	/* arity of functor */
    short	link;	/* chain for clashes */
    bool	type;	/* predicate type : 1/2/3 i.e. static/dynamic/external */
} *dictionary;

/* predicate types */
#define	STATIC		1
#define	DYNAMIC		2
#define	EXTERNAL	3
#define	ANY_PRED	-1

extern dictionary	symtab;		/* the symbol table */
extern dictionary 	find_entry();
extern dictionary 	get_entry();



#define relative(P,N)	( (P) + (N) + *( (P) + (N) ) )

/*
 *   A segment head occupies 4 code cells, from
 *   PC to PC+3.  The structure is as follows :
 *
 *          PC             PC+1         PC+2        PC+3
 *   segment length    entrypoints    constants   externals
 */

#define HEAD_SIZE	4
#define seg_len(P)	*(P)
#define seg_ent(P)	*((P) + 1)
#define seg_con(P)	*((P) + 2)
#define seg_ext(P)	*((P) + 3)


/*
 *   An external reference entry occupies 4 code cells, from
 *   PC to PC+3.  The structure is as follows :
 *
 *      PC	PC+1         PC+2              PC+3  
 *  (ptr to symbol table)    arity       offset to symbol
 */

#define EXT_SIZE	4
#define ext_dict(P)	( *(dictionary *)(P) )
#define ext_arity(P)	( *(twoBytes *)((P) + 2) )
#define ext_pred(P)	( (symbpo) relative((P), 3) )

/*
 *   An entrypoint reference occupies 3 code cells, from
 *   PC to PC+2.  The structure is as follows :
 *
 *      PC	PC+1          PC+2
 *   address    arity    offset to symbol
 */

#define ENT_SIZE	3
#define ent_addr(P)	( *(twoBytes *)(P) )
#define ent_arity(P)	( *(twoBytes *)((P) + 1) )
#define ent_pred(P)	( (symbpo) relative((P), 2) )
