/*  $Id: itf-interface.h,v 1.9 92/04/27 16:18:50 jan Exp Locker: jan $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1992 University of Amsterdam. All rights reserved.
*/

#include <sys/types.h>

		/********************************
		*            VERSIONS		*
		********************************/

#ifndef PCE_VERSION
#define PCE_VERSION "4.3.3, April 1992"
#endif

#ifndef OS_VERSION
#define OS_VERSION "unknown"
#endif

#ifndef MACHINE
#define MACHINE "unknown"
#endif

		/********************************
		*          PROTOTYPES		*
		********************************/

#ifndef P
#ifdef __STDC__				/* Prototype handling */
# define P(s) s
#else
# define P(s) ()
#endif
#endif

		/********************************
		*           PRIMITIVES		*
		********************************/

#ifndef PCE_INCLUDED
typedef void *		PceObject;	/* PCE's view of an object */

#define INT_MASK_SHIFT	2
#define PCE_MAX_INT	((1 << (32 - INT_MASK_SHIFT - 1)) - 1)
#define PCE_MIN_INT	(-PCE_MAX_INT - 1)

typedef void *		AnswerMark;	/* Mark on AnswerStack */

void	  _markAnswerStack P((AnswerMark *));
void	  _rewindAnswerStack P((AnswerMark *, PceObject));

#define markAnswerStack(mark)	_markAnswerStack(&(mark))
#define rewindAnswerStack(mark, obj) _rewindAnswerStack(&(mark), obj)
#else
#define PceObject	Any
#endif


		/********************************
		*           CONSTANTS		*
		********************************/


#define PCE_FAIL	0
#define PCE_SUCCEED	1

#define PCE_INTEGER	0
#define PCE_REAL	1
#define PCE_STRING	2
#define PCE_NAME	3
#define PCE_TYPE	4 
#define PCE_ASSOC	5 
#define PCE_REFERENCE	6 

#define PCE_MAXINTEGER	PCE_MAX_INT
#define PCE_MININTEGER	PCE_MIN_INT

#define HOST_QUERY	0	/* execute interactive query on host */
#define HOST_TRACE	1	/* start debugger on host */
#define HOST_BACKTRACE	2	/* give stack trace on host */
#define HOST_HALT	3	/* exit host */
#define HOST_BREAK	4	/* start interactive session with host */
#define HOST_SYMBOLFILE	5	/* query symbol table */
#define HOST_ABORT	6	/* abort current query, return to toplevel */
#define HOST_SIGNAL	7	/* signal() replacement */
#define HOST_GETC	8	/* get a character from the host */
#define HOST_RECOVER_FROM_FATAL_ERROR 9 /* Error: don't return */
#define HOST_WRITE	10	/* Write a char * on the terminal */
#define HOST_FLUSH	11	/* Flush terminal */

typedef caddr_t PceValue;

typedef struct pce_type *	PceType;

struct pce_type
{ int		type;			/* type of C datum */
  PceValue	value;			/* C datum */
};

int		pceToC P((PceObject, PceType));
char *		pceStringToCharp P((PceObject));

int		pceSend P((PceObject, PceObject, int, PceObject *));
PceObject	pceGet P((PceObject, PceObject, int, PceObject *));
PceObject	pceNew P((char *, PceObject, int, PceObject *));
int		pceLock P((PceObject));
int		pceObject P((PceObject));
int		pceExists P((char *));

int		hostSend P((PceObject, PceObject, int, PceObject *));
PceObject	hostGet P((PceObject, PceObject, int, PceObject *));

#define PCE_DISPATCH_INPUT	(0)
#define PCE_DISPATCH_TIMEOUT	(1)

int	pceInitialise P((int, char**));
void	pceReset P((void));
void	pceDoDispatch P((void));
int	pceDispatch P((void));
void	pceTrace P((int));		/* 1: trace; 0: notrace */
void	pcePrintStack P((void));	/* dump C-stack */
void	pceTraceBack P((void));		/* dump PCE message stack */
void	pceWriteCurrentGoal P((void));	/* dump top of PCE message stack */

int	hostQuery P((int, PceValue *));
int	hostAction P((int, ...));

#define pcePP(x) ppPCE(x)

PceObject cToPceName P((char *));
PceObject cToPceInteger P((long));
PceObject cToPceReal P((double));
PceObject cToPceString P((char *, char *));
PceObject cToPceAssoc P((char *));
PceObject cToPceReference P((unsigned long));
PceObject cToPceSpecial P((int));
int	  pceExistsReference P((long));
int	  pceExistsAssoc P((char *));
