/*  $Id: pl-itf.h,v 1.3 92/04/09 10:56:49 jan Exp Locker: jan $

    Copyright (c) 1990 Jan Wielemaker. All rights reserved.
    See ../LICENCE to find out about your rights.
    jan@swi.psy.uva.nl

    Purpose: SWI-Prolog foreign language interface include file
*/

#ifndef PL_INCLUDED
#define PL_INCLUDED

#ifndef PLVERSION
#define PLVERSION "1.5.9, April 1992"
#endif

#ifndef Proto
#if __STDC__ || PROTO
#define Proto(x) x
#else
#define Proto(x) ()
#endif
#endif

#ifndef PL_KERNEL
typedef	cellpo	atomic;		/* atomic Prolog datum */
typedef cellpo	fnctor_t;	/* name/arity pair as Prolog */
typedef unsigned long	module;		/* Prolog module */
typedef cellpo 	term;		/* general term */
typedef unsigned long	foreign_t;	/* return type of foreign functions */
/* typedef	int		bool;		/* boolean */
#define O_STRING 1
#else
#define atomic	cellpo
#define fnctor_t cellpo
typedef Module		module;
#define term	cellpo
typedef word		foreign_t;
#endif

typedef foreign_t	(*function)();	/* foreign language functions */	

#ifndef TRUE
#define TRUE	(1)
#define FALSE	(0)
#endif


		/********************************
		*     NOTIFIER TRICKS (PCE)     *
		*********************************/

extern bool aborted;			/* system aborted in critical code */

#ifndef PL_KERNEL

extern struct
{ int		active;			/* are we in notify code? */
  bool		dispatching;		/* is notify_do_dispatch() on? */
  jmp_buf	context;		/* save context of Get0() */
  bool		called;			/* are we called from Pce? */
  bool		abort_is_save;		/* an abort is ok */
} notify_status;
#endif

		/********************************
		*            SYMBOLS            *
		*********************************/

/*  The TOS linker on the ATARI_ST only allows for 8 character external
    symbols.  The macros below redefine some of the interface function
    names to avoid name clashes.
*/

#if __TOS__
#define	PL_new_functor		PL_nfunc
#define PL_new_float		PL_nflt
#define PL_functor		PL_funct
#define PL_functor_name		PL_fname
#define PL_functor_arity	PL_farity
#define	PL_unify		PL_uf
#define PL_unify_atomic		PL_ufa
#define PL_unify_functor	PL_uff
#endif

		/********************************
		*           ANALYSES            *
		*********************************/

#define	PL_VARIABLE	(1)
#define PL_ATOM		(2)
#define PL_INTEGER	(3)
#define PL_FLOAT	(4)
#if O_STRING
#define PL_STRING	(5)
#endif O_STRING
#define PL_TERM		(6)

int 	PL_type Proto((term));		/* determine type of a term */
#define PL_atomic(t)	(t)		/* convert term to atomic */
long	PL_integer_value Proto((atomic));	/* Prolog int   -> C int */
double	PL_float_value Proto((atomic));	/* Prolog float -> C float */
#if O_STRING
char *	PL_string_value Proto((atomic));	/* Prolog string -> C char * */
#endif O_STRING
char *  PL_list_string_value Proto((term));	/* Prolog list of ASCII --> C char * */
char *	PL_atom_value Proto((atomic));	/* Prolog atom  -> C char * */
fnctor_t	PL_functor Proto((term));		/* determine functor of complex term */
symbpo	PL_functor_name Proto((fnctor_t));	/* determine name (atom) of functor */
int	PL_functor_arity Proto((fnctor_t));	/* determine arity of functor */
term	PL_arg Proto((term, int));		/* return argument of complex term */
term	PL_strip_module Proto((term, module*)); /* strip module information */

		/********************************
		*         CONSTRUCTION          *
		*********************************/

term	PL_new_term Proto((void));		/* create a new term (variable) */
atomic	PL_new_atom Proto((char *));	/* create an atom from a char * */
atomic  PL_new_integer Proto((int));	/* create a new integer */
atomic	PL_new_float Proto((double));	/* create a new float */
#if O_STRING
atomic	PL_new_string Proto((char *));	/* create a new string */
#endif O_STRING
fnctor_t	PL_new_functor Proto((atomic, int)); /* create a new functor */
bool	PL_unify Proto((term, term));	/* unify two terms */
bool	PL_unify_atomic Proto((term, atomic));  /* unify term with atomic value */
bool	PL_unify_functor Proto((term, fnctor_t));/* unify term with functor */

		/********************************
		*    DETERMINISTIC CALL/RETURN  *
		*********************************/

#define	PL_succeed	return 1	/* succeed deterministically */
#define PL_fail		return 0	/* fail */

		/********************************
		*        CALLING PROLOG         *
		*********************************/

struct data_mark
{ cellpo        trailtop;       /* top of the trail stack */
  cellpo        globaltop;      /* top of the global stack */
};
typedef struct data_mark        bktrk_buf;   /* backtrack mark */


#define Mark(b)         { (b).trailtop = TR; \
                          (b).globaltop = H; \
                        }
#define Undo(b)         { while(TR < (b).trailtop) { \
                            mkunb((cellpo) *TR); \
                            TR++; \
                          } \
                          H = (b).globaltop; \
                        }

void	PL_mark Proto((bktrk_buf *));	/* mark global and trail stack */
void	PL_bktrk Proto((bktrk_buf *));	/* backtrack global stack to mark */

bool	PL_call Proto((term, module));	/* invoke term as Prolog goal */

		/********************************
		*            MODULES            *
		*********************************/

module	PL_context Proto((void));		/* context module of predicate */		
atomic	PL_module_name Proto((module));	/* return name of a module */
module	PL_new_module Proto((atomic));	/* return module from an atom */


		/********************************
		*         EVENT HANDLING	*
		********************************/

#define PL_DISPATCH_INPUT   0		/* There is input available */
#define PL_DISPATCH_TIMEOUT 1		/* Dispatch timeout */

extern int (*PL_dispatch_events) Proto((void));	/* Dispatch user events */


		/********************************
		*      INITIALISATION HOOK	*
		********************************/

extern void (*PL_foreign_reinit_function) Proto((int argc, char **argv));


		/********************************
		*            SIGNALS            *
		*********************************/

void (*PL_signal Proto((int sig, void (*func)())))(); /* signal() replacement */


		/********************************
		*             ABORTS		*
		********************************/

void PL_abort_handle Proto((void (*func)())); /* func called by pl_abort() */


		/********************************
		*           WARNINGS            *
		*********************************/

#if __GNUC__ > 1
bool	PL_warning Proto((...));		/* Print standard Prolog warning */
void	PL_fatal_error Proto((...));		/* Print warning and die */
#else
bool	PL_warning Proto((char *, ...));	/* Print standard Prolog warning */
void	PL_fatal_error Proto((char *, ...));	/* Print warning and die */
#endif

		/********************************
		*        PROLOG ACTIONS         *
		*********************************/

#define	PL_ACTION_TRACE		1	/* switch to trace mode */
#define PL_ACTION_DEBUG		2	/* switch to debug mode */
#define PL_ACTION_BACKTRACE	3	/* show a backtrace (stack dump) */
#define PL_ACTION_BREAK		4	/* create a break environment */
#define PL_ACTION_HALT		5	/* halt Prolog execution */
#define PL_ACTION_ABORT		6	/* generate a Prolog abort */
#define PL_ACTION_SYMBOLFILE	7	/* make arg. the symbol file */
#define PL_ACTION_WRITE		8	/* write via Prolog i/o buffer */
#define PL_ACTION_FLUSH		9	/* Flush Prolog i/o buffer */

bool	PL_action Proto((int, void *));	/* perform some action */

		/********************************
		*         QUERY PROLOG          *
		*********************************/

#define PL_QUERY_ARGC		1	/* return main() argc */
#define PL_QUERY_ARGV		2	/* return main() argv */
#define PL_QUERY_SYMBOLFILE	3	/* return current symbol file */
#define PL_QUERY_ORGSYMBOLFILE	4	/* symbol file before first load */
#define PL_QUERY_GETC		5	/* Read character from terminal */

long	PL_query Proto((int));		/* get information from Prolog */

#define succeed			return TRUE
#define fail			return FALSE
#define TRY(goal)		{ if ((goal) == FALSE) fail; }

#endif PL_INCLUDED
/* DO NOT WRITE BELOW THIS ENDIF */
