%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%                             T R A C E R
%
%                 Author: Mantis H.M. Cheng (May/30/1994)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% traces( +Agent, +Length, +Traces )
%    Traces is a set of traces of Agent of at most Length ( >= 1 ) in
%    ascending order of lengths
%
%  N.B. It always succeeds. No duplicate traces are allowed.
%
traces( P, N, L1 ) :-
	N > 0, 
	setof( T, tracesN( P, 0, N, T ), L ), !,
	keysort( L, L1 ).
traces( _, _, [] ).
	

%% runs( +Agent, +Length, +Runs )
%    Runs is a sequence of traces of Agent of at most Length ( >= 1 ) in
%    ascending order of lengths
%
%  N.B. It always succeeds. It is the same as traces/3 except duplicates
%       are allowed.
%
runs( P, N, L1 ) :-
	N > 0, 
	findall( T, tracesN( P, 0, N, T ), L ), !,
	keysort( L, L1 ).
runs( _, _, [] ).
	

tracesN( P, C, N, C-[] ) :-
	C =< N, 
	\+ trans( P, _, _ ), !.
tracesN( P, C, N, C-[] ) :-
	C =< N, 
	trans( P, _, _ ).
tracesN( P, C, N, K-[A|As] ) :-
	C =< N,
	trans( P, A, P1 ), 
        instantiate( A ),
	C1 is C+1,
	tracesN( P1, C1, N, K-As ).


print_traces( [] ) :- !.
print_traces( [K-T|Ts] ) :-
	print_tracesK( K, [K-T|Ts], Ts1 ),
	print_traces( Ts1 ).

print_tracesK( _, [],       [] )  :- !.
print_tracesK( K, [K-T|Ts], Ts1 ) :- !,
	write( '(' ), write( K ), write( ') ' ),
	print_expression( T ), nl,
	print_tracesK( K, Ts, Ts1 ).
print_tracesK( _, Ts, Ts ).



%% run( +Agent, +Depth, +MaxDepth ) :-
%
run( Agent, Depth, MaxDepth ) :-
        Depth > MaxDepth,
        ask_input('(a)bort, (c)ontinue, (b)acktrack, or (s)tep? ', L),
        tokenise(L, [Cmd|_]),
        run_cmd(Cmd, Agent, Depth, MaxDepth).

run( Agent, Depth, MaxDepth ) :-
        Depth =< MaxDepth,
        trans( Agent, Act, Agent1 ),
        instantiate( Act ),
        echo_action( Act, Depth ),
        Depth1 is Depth + 1,
        run( Agent1, Depth1, MaxDepth ).


run_cmd( lid(c), Agent, Depth, MaxDepth) :- 
        !,
        ask_input('How far? ', L),
        tokenise(L,[Cmd|_]),
        ( Cmd = num(N) ->
                (M is MaxDepth + N,
                 run(Agent, Depth, M) ) ).
run_cmd( lid(b), _, _, _ ) :-
        !,
        fail.
run_cmd( lid(s), Agent, _, _) :-
        !,
        step_agent(Agent).
run_cmd( lid(a), _, _, _).


echo_action( A, Depth ) :- !,
        write( '('),
	write(Depth),
	write(') == ' ),
        echo_expression(A), 
	write( ' ==>' ),
        nl.


%% step_agent( +Agent )
%
% N.B. This predicate always succeeds.
%
step_agent( Agent ) :-
        successors( Agent, [T|Ts] ),
        echo_choices( [T|Ts], 1 ),
        ask_input('Which? ', L),
        tokenise(L, [Cmd|_]),
        !,
        ( Cmd = num(N) ->
            (nth( [T|Ts], N, pr(Act,Agent1) ),
             instantiate( Act ),
             step_agent( Agent1 )) ).
step_agent( _ ).


%% instantiate( Term )
%	asks the user if necessary about the values of the free
%	variables
%
instantiate( Act ) :- ground_term( Act ), !.
instantiate( Term ) :-
        % \+ ground_term( Term ),
        repeat,
          echo_expression( Term ),
          ask_input( ' = ', L ),
          get_next_expression( L, Input ),
          Term = Input, !.


echo_choices( [], _ ) :- !.
echo_choices( [pr(Act,_)], N ) :- !,
        write( N ),
        write( ') == ' ),
        echo_expression(Act),
        write( ' ==> ' ),
	write( ' ...' ),
	nl.
echo_choices( [pr(Act,_), T|Ts], N ) :-
        write( N ),
        write( ') == ' ),
        echo_expression(Act),
        write( ' ==> ' ),
	write( ' ...' ),
        nl,
        N1 is N+1,
        echo_choices( [T|Ts], N1 ).

