%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%             T Y P E / W E L L - F O R M E D      C H E C K E R
%
%                 Author: Mantis H.M. Cheng (May/30/1994)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% Definitions must be of the form:
%
%  <Defn> ::= <Const> "::=" ( <Agent> | <Form> )
%
% where free variables in (<Agent>|<Form>) must be defined in <Const>
%
semantic_check(op('::=',Const, Body),op('::=',Const1,Body1),Env) :-
	semantic_check_const(Const, Const1, [], Env),
          % free variables in "Body" should be defined in "Env"
	( semantic_check_agent(Body, Body1, Env ) ;
	  semantic_check_formula(Body,Body1, Env) ),
	!.
semantic_check(_,_,_ ) :-
	write( '*** expression not well-formed ***' ), nl,
	fail.


%
% <Const>  ::= <Uid> [ "(" <Exp> { "," <Exp> } ")" ]
%
semantic_check_const( uid(T), uid(T), Env, Env ) :- !.
semantic_check_const( func(uid(F),N,Ts), func(uid(F),N,Ts1), Env1, Env2 ) :-
	!,
	semantic_check_args( Ts, Ts1, Env1, Env2 ).

%
% <Exp> ::=  <String>
%          | <Boolean>
%          | <Number>
%          | <Lid>
%          | <Lid> "(" <Exp> ... <Exp> ")"
%          | "{" <Exp> { "," <Exp> } "}"
%          | "not" <Exp>
%          | "-" <Exp>
%          | <Exp> <Op> <Exp>   where Op is +, -, *, <, >, =<, >=, <>
%                                     mod, and, or, ., ++, in
%          | <Variable>
%	   | <Formula>
%
semantic_check_exp( const(T), const(T), E, E ) :- !.
semantic_check_exp( bool(T) , bool(T) , E, E ) :- !.
semantic_check_exp( num(T)  , num(T)  , E, E ) :- !.
semantic_check_exp( lid(X)  , lid(X)  , E, E ) :- !.       
semantic_check_exp( var(void), _      , E, E ) :- !.
semantic_check_exp( var(X)  , V       , E, E1 ) :- !,
	(member( X=V, E ) -> E = E1 ; E1 = [X=V|E]).
semantic_check_exp( func(lid(X),N,Ts), func(lid(X),N,Ts1), E1, E2) :- !,
	semantic_check_args(Ts, Ts1, E1, E2 ).
semantic_check_exp( set(F), set(F1), E1, E2 ) :-
	semantic_check_args( F, F1, E1, E2 ), !.
semantic_check_exp( F, F1, E, E ) :-
	semantic_check_formula( F, F1, E ), !.
semantic_check_exp( op(O,L), op(O,L1), E1, E2 ) :-
	member( O, ['-','not'] ), !,
	semantic_check_exp( L, L1, E1, E2 ).
semantic_check_exp( op(O,L,R), op(O,L1,R1), E1, E3 ) :-
	member( O, ['+','-','*','mod','and','or','=','<','>',
                    '=<','>=','<>','.','++','in'] ), !,
	semantic_check_exp( L, L1, E1, E2 ),
	semantic_check_exp( R, R1, E2, E3 ).


semantic_check_args( [], [], E, E ) :- !.
semantic_check_args( [T|Ts], [T1|Ts1], E1, E3 ) :- !,
	semantic_check_exp( T, T1, E1, E2 ),
	semantic_check_args( Ts, Ts1, E2, E3 ).

%
% <Agent> ::= 
%           | "STOP"
%           | "SKIP"
%           | "fix" <Uid> "."    <Agent>
%           | <Agent>    "|||"   <Agent>
%           | <Agent>    "|>"    <Agent>
%           | <Agent>    ";"     <Agent>
%           | <Agent>    "||"    <Agent>
%           | <Agent>    "+"     <Agent>
%           | <Agent>    "\"     <Hide>
%           | <Agent>    "/"     <Trace>
%           | <Agent>    "^"     <Sync>
%           | <Agent>    "#"     <Renames>
%           | "if" <Exp> "then"  <Agent>
%           | "@" <Agent>
%           | <Prefixes>
%           | <Con>
%
semantic_check_agent( 'STOP', 'STOP', _ ) :- !.
semantic_check_agent( 'SKIP', 'SKIP', _ ) :- !.
semantic_check_agent( op('.',op('fix',uid(C)),A), 
                      op('.',op('fix',uid(C)),A1), E ) :- !,
	semantic_check_agent( A, A1, E ).
semantic_check_agent( op(O,L,R), op(O,L1,R1), E ) :-
        member( O, ['|||','|>',';','||','+'] ),
	!,
	semantic_check_agent(L, L1, E ),
	semantic_check_agent(R, R1, E ).
semantic_check_agent( op(O,L,set(As)), op(O,L1,set(As)), E ) :- 
	member( O, ['^','\'] ), !, 
	semantic_check_labels( As ),
	semantic_check_agent( L, L1, E ).
semantic_check_agent( op('/',L,As), op('/',L1,As), E ) :- 
	!,
	semantic_check_trace( As ),
	semantic_check_agent( L, L1, E ).
semantic_check_agent( op('#',A,set(F)), op('#',A1,set(F)), E ) :- !,
	semantic_check_agent( A, A1, E ),
	semantic_check_renames( F ).
semantic_check_agent( ifthen(C,A), ifthen(C1,A1), E ) :- !,
	semantic_check_exp( C, C1, E, E ),
	semantic_check_agent( A, A1, E ).
semantic_check_agent( op('@',A), op('@',A1), E ) :- !,
	semantic_check_agent( A, A1, E ).
semantic_check_agent( op('|',L,R), op('|',L1,R1), E ) :-
	!,
	semantic_check_prefix(L, L1, E ),
	semantic_check_prefixes(R, R1, E ).
semantic_check_agent( op('->',A,L), op('->',A1,L1), E ) :- !,
	semantic_check_prefix( op('->',A,L), op('->',A1,L1), E ).
semantic_check_agent( A, A1, E ) :-
	semantic_check_const( A, A1, E, E ). 


%
% <Prefix>   ::= ["if" <Exp> "then"] <Action> -> <Agent>
% <Prefixes> ::= <Prefix>
%              | <Prefix> "|" <Prefixes>
%
semantic_check_prefix(ifthen(B, op('->',A, C )), 
                      ifthen(B1,op('->',A1,C1)), E ) :- !,
	semantic_check_exp( B, B1, E, E ),
	semantic_check_action( A, A1, E, E1 ),
	semantic_check_agent( C, C1, E1 ).
semantic_check_prefix(op('->',A,C), op('->',A1,C1), E ) :-
	semantic_check_action( A, A1, E, E1 ),
	semantic_check_agent( C, C1, E1 ).

semantic_check_prefixes( op('|',L,R), op('|',L1,R1), E ) :-
	!,
	semantic_check_prefix( L, L1, E ),
	semantic_check_prefixes( R, R1, E ).
semantic_check_prefixes( op('->',A,L), op('->',A1,L1), E ) :- !,
	semantic_check_prefix( op('->',A,L), op('->',A1,L1), E ).


semantic_check_renames( [] ) :- !.
semantic_check_renames( [op('=',A,B)|L] ) :- 
	ground_label(A), 
	ground_label(B),
	semantic_check_renames( L ).


semantic_check_trace( lid(nil) ) :- !.
semantic_check_trace( op('.',A,L) ) :- !,
	ground_label( A ),
	semantic_check_trace( L ).
semantic_check_trace( A ) :- 
	ground_label( A ).


semantic_check_labels( [] ) :- !.
semantic_check_labels( [A|L] ) :-
	ground_label( A ),
	semantic_check_labels( L ).


% <Action>   ::= <Label>
%              | <Choice>
%              | <Channel> "?" ( <Var> | <Choice> )
%              | <Channel> "!" ( <Exp> | <Choice> )
%              | <Action> "&" <Action> { "&" <Action> }
%	       | <Var>
%
semantic_check_action( var(X),       V,             E, E  ) :- !, 
	member( X=V, E ).
semantic_check_action( func(F,N,As), func(F,N,As1), E, E1 ) :- !,
	semantic_check_args( As, As1, E, E1 ).
semantic_check_action( A, A, E, E ) :-  ground_label(A), !.
  %
  % a variable in a menu action is a binding occurrence
  %
semantic_check_action(op(':',var(X),T), op(':',V,T1), E, E1 ) :- !,
	(X = void -> E = E1 ; E1 = [X=V|E] ),
	semantic_check_choice( T, T1, E ).
  %
  % an input/output action of the form c?_x:L or c!_x:L represents
  % an indexed (on L) choice of input/output actions
  %
semantic_check_action(op(O,C, op(':',var(X),T )), 
                      op(O,C1,op(':',V,     T1)), E, E1 ) :- 
	member( O, ['!','?'] ), !,
	semantic_check_channel( C, C1, E ),
	(X = void -> E = E1 ; E1 = [X=V|E] ),
	semantic_check_choice( T, T1, E ).
  %
  % an input prefix can introduce new bound variables
  %
semantic_check_action(op('?',C,T), op('?',C1,T1), E, E1 ) :- !,
	semantic_check_channel( C, C1, E ),
	semantic_check_exp( T, T1, E, E1 ).
  %
  % but, an output prefix cannot
  %
semantic_check_action(op('!',C,T), op('!',C1,T1), E, E ) :- !,
	semantic_check_channel( C, C1, E ),
	semantic_check_exp( T, T1, E, E ).
semantic_check_action(op('&',A,B), op('&',A1,B1), E, E4 ) :-
	semantic_check_action( A, A1, [], E1 ),
	semantic_check_action( B, B1, [], E2 ),
	disjoint( E1, E2 ),
	append( E1, E2, E3 ),
	union( E3, E, E4 ).


semantic_check_channel( lid(C), lid(C), _ ) :- !.
semantic_check_channel( func(lid(C),N,As), func(lid(C),N,As1), E ) :-
	semantic_check_args( As, As1, E, E ).


disjoint( [], _ ) :- !.
disjoint( [X=_|E1], E2 ) :-
	\+ member( X=_, E2 ),
	disjoint( E1, E2 ).


%
%  <Choice>  ::= <Var> ":" ( <Menu> | <Var> )
%
% (Note: The 2nd <Var> must be defined already.)
%
semantic_check_choice(var(void), _, _ ) :- !.
semantic_check_choice(var(X),    V, E ) :- !, member( X=V, E ).
semantic_check_choice(set(As), set(As), _ ) :- semantic_check_labels( As ).


%
% ground_label( +Label ) holds of "Label" is ground
%
ground_label( A ) :- label( A ), ground_term( A ), !.

label( lid(_)   ).
label( const(_) ).
label( num(_)   ).
label( done     ).
label( func(_,_,_) ).
label( op('?',_,_) ).
label( op('!',_,_) ).
label( op('$',_,_) ).


% <Formula> ::= 
%             "tt"
%	    | "ff"
%	    | <Var>
%	    | <Const>
%           | <Const> [ "(" <Exp> { "," <Exp> ")" ]
%           | "not" <Formula>
%           | <Formula> "and" <Formula>
%           | <Formula> "or" <Formula>
%	    | <Modal> "." <Formula>
%           | "min" <Const> "." <Formula>
%           | "max" <Const> "." <Formula>
%
semantic_check_formula( form(T),   form(T),   _ ) :- !.
semantic_check_formula( var(void), _,         _ ) :- !.
semantic_check_formula( var(X),    V,         E ) :- !, member( X=V, E ).
semantic_check_formula( uid(C),    uid(C),    _ ) :- !.
semantic_check_formula( func(uid(C),N,As), func(uid(C),N,As1), E ) :- !,
	semantic_check_args( As, As1, E, E ).
semantic_check_formula( op('not',R), op('not',R1), E ) :- !,
	semantic_check_formula(R,R1,E).
semantic_check_formula( op(O,L,R), op(O,L1,R1), E ) :-
        member( O, ['and','or'] ), !,
	semantic_check_formula(L,L1,E),
	semantic_check_formula(R,R1,E).
semantic_check_formula( op('.',op(O,uid(C)),R), op('.',op(O,uid(C)),R1), E ) :-
	member( O, ['min', 'max'] ), !,
	semantic_check_formula(R,R1,E).
semantic_check_formula( op('.',M,R), op('.',M1,R1), E ) :- 
	semantic_check_modal(M,M1,E),
	semantic_check_formula(R,R1,E).


% <Modal>   ::= "[[" <Acts> "]]"
%	    |   "<<" <Acts> "]]"
%
semantic_check_modal( box(A), box(A1), E ) :- !,
	semantic_check_acts(A,A1,E).
semantic_check_modal( diamond(A), diamond(A1), E ) :-
	semantic_check_acts(A,A1,E).


% <Acts>    ::= "-"
%           |  [ "-" ] "{" [ <Act> { "," <Act> } ] "}"
%           |  <Act> { "." <Act> } 
%           |  [ "-" ] <Act>
%
semantic_check_acts( '-', '-', _ ) :- !.
semantic_check_acts( op('-',set(As)), op('-',set(As1)), E ) :- !,
	semantic_check_actset( As, As1, E ).
semantic_check_acts( set(As), set(As1), E ) :- !,
	semantic_check_actset( As, As1, E ).
semantic_check_acts( op('.',A,As), op('.',A1,As1), E ) :- !,
	semantic_check_act( A, A1, E ),
	semantic_check_actlist( As, As1, E ).
semantic_check_acts( op('-',A), op('-',A1), E ) :- !,
	semantic_check_act( A, A1, E ).
semantic_check_acts( A, A1, E ) :- 
	semantic_check_act( A, A1, E ).


% <Act>     ::= <Action> | <Var>
%
semantic_check_act( var(void), _, _ ) :- !.
semantic_check_act( var(X),    V, E ) :- !, member( X=V, E ).
semantic_check_act( A,         A, _ ) :- label( A ).


semantic_check_actset( [], [], _ ) :- !.
semantic_check_actset( [A|As], [A1|As1], E ) :- !,
	non_member( A, As ),
	semantic_check_act( A, A1, E ),
	semantic_check_actset( As, As1, E ).


semantic_check_actlist( op('.',A,As), op('.',A1,As1), E ) :- !,
	semantic_check_act( A, A1, E ),
	semantic_check_actlist(As,As1,E).
semantic_check_actlist( A, A1, E ) :- 
	semantic_check_act( A, A1, E ).
