%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%             M I S C E L L A N E O U S    U T I L I T I E S
%
%                 Author: Mantis H.M. Cheng (May/30/1994)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% append( +List1, +List2, -List)
%     holds if "List" is the result of concatenating "List1" and "List2"
%
append([],    L, L     ) :- !.
append([X|Xs],L, [X|Ls]) :- append(Xs,L,Ls).


%% member( +Element, +List )
%       holds if "Element" is a member of "List"
%
member(X, [X|_]).
member(X, [_|Z]) :- member(X,Z).


%% non_member( +Element, +List )
%       holds if "Element" is not a member of "List"
%
non_member( _, [] ) :- !.
non_member( X, [Y|Ys] ) :- 
        X \==Y, 
        non_member( X, Ys ).


%% nth( +List,  +N, -Element) 
%       Return the "N"th element in "List", starting from 1.
%       This is deterministic.
%
nth([X|_], 1, X) :- !.
nth([_|L], N, X) :- 
        N > 1, 
        N1 is N-1, 
	nth(L,N1,X).


%% reverse( +ListIn, -ListOut )
%       "ListOut" is "Listin" with its elements in reverse order.
%
reverse(A,B) :- 
        reverse(A,[],B).

reverse([], B, B).
reverse([X|Xs],R,R1) :- reverse(Xs,[X|R],R1).


%% del( +ListIn, +Element, -ListOut )
%       return "ListIn" in "ListOut" with all occurrences of "Element" removed.
%
del([],_,[]).
del([X|Y],X,R)     :- 
        del(Y,X,R).
del([X|Y],Z,[X|R]) :- 
        X \== Z, 
        del(Y,Z,R).


%% union( +List1, +List2, -ListOut )
%       "ListOut" is the set union of "List1" and "List2".
%
union([],B,B).
union(A,[],A).
union([A1|A2],B,[A1|C1]) :- 
        del(B,A1,B1), 
        union(A2,B1,C1).


%% intersection( +List1, +List2, -ListOut )
%       "ListOut" is the set intersection of "List1" and "List2".
%
intersection([],_,[]).
intersection(_,[],[]) :- !.
intersection([X1|X2],Y,[X1|Z1]) :- 
        member(X1,Y),
        del(Y,X1,Y1), !,
        intersection(X2,Y1,Z1).
intersection([_|X2],Y,Z):- 
        % non_member(X1,Y),
        intersection(X2,Y,Z).


%% subset( +List1, +List2 )
%       holds if "List1" is a subset of "List2".
%
subset([],_).
subset([X|Y],Z) :- 
        member(X,Z), 
        subset(Y,Z).


%% set_minus(+A, +B, -C)
%       holds if "C" is "A" \ "B"
%
set_minus([], _, []).
set_minus([X|A], B, R)      :- 
        member(X,B), !, 
        set_minus(A,B,R).
set_minus([X|A], B, [X|R])  :- 
        set_minus(A,B,R).


%% newsym( +Atom, +Integer, -NewSym )
%
newsym( A, I, S ) :-
	atom_chars( A, L1 ),
	number_chars( I, L2 ),
	append( L1, L2, L3 ),
	atom_chars( S, L3 ).
