%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%              A G E N T / A C T I O N    E V A L U A T O R
%
%                 Author: Mantis H.M. Cheng (May/30/1994)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% eval( +Term, -Value )
%       Value may be 'error' if Term cannot be evaluated.
%       Value is either 'bool(true)' or 'bool(false)' for boolean Term.
%
% Notes: It NEVER fails!
%        All evaluable and constructor functions are STRICT!
%        (i.e., f(error) = error -- It preserves error.)
%
eval( X,        Y ) :- var(X), !, Y = error.
eval( error,    error ) :- !.
eval( [],        [] ) :- !.
eval( [T|Ts],    [V|Vs] ) :-
        eval( T, V ),
        V \== error, 
        eval( Ts, Vs ),
	Vs \== error,
	!.
eval( [_|_],    error ) :-
        % eval( T, error ),
        !.
eval( var(void), var(void) )  :- !.
eval( form(T),   form(T) )  :- !.
eval( bool(T),   bool(T) )  :- !.
eval( num(T),    num(T)  )  :- !.
eval( lid(T),    lid(T)  )  :- !.
eval( uid(T),    uid(T)  )  :- !.
eval( set(T),    set(T1) )  :- !,
	eval( T, T1 ).
eval( 'STOP',	 'STOP'  )  :- !.
eval( 'SKIP',	 'SKIP'  )  :- !.
eval( const(T),  const(T) ) :- !.
%
%
eval( func(Id,N,Ts), func(Id,N,Vs) ) :-
        eval( Ts, Vs ),
        Vs \== error,
        !.
eval( op('?',C,T), op('?',C,V) ) :- !,
        eval( T, V ).
eval( op('!',C,T), op('!',C,V) ) :- !,
        eval( T, V ).
eval( op('$',C,T), op('$',C,V) ) :- !,
        eval( T, V ).
eval( op(':',C,T), op(':',C,V) ) :- !,
        eval( T, V ).
eval( op('&',S,T), op('&',S1,T1) ) :- !,
        eval( S, S1 ),
	eval( T, T1 ).
  % The following check must be done after all of the above ones!!!
eval( C, C ) :- ground_label( C ), !.
eval( op(O,L,R), op(O,L1,R) ) :-
	member( O, ['#','^','\','/'] ), !,
        eval( L, L1 ).
eval( op('@',R), op('@',R1) ) :- !,
        eval( R, R1 ).
eval( op('.',L,R), op('.',L,R1) ) :- !,
        eval( R, R1 ).
eval( ifthen(L,R), ifthen(L1,R1) ) :- !,
        eval( L, L1 ),
        eval( R, R1 ).
eval( op(O,L,R), op(O,L1,R1) ) :-
	member( O, ['->',';','|','or','||','|||','|>'] ), !,
        eval( L, L1 ),
        eval( R, R1 ).
eval( op('+',T1,T2), num(V) ) :- 
        eval( T1, num(V1) ),
        eval( T2, num(V2) ), 
        !,
        V is V1 + V2.
% '+' is also used for agents.
eval( op('+',T1,T2), op('+',V1,V2) ) :-
	eval( T1, V1 ),
	V1 \== error,
	eval( T2, V2 ),
	V2 \== error,
	!.
eval( op('-',T), num(V) ) :-
	eval( T, num(V1) ),
	!,
	V is -V1.
eval( op('-',T1,T2), num(V) ) :-
        eval( T1, num(V1) ),
        eval( T2, num(V2) ),
        !,
        V is V1 - V2.
eval( op('*',T1,T2), num(V) ) :-
        eval( T1, num(V1) ),
        eval( T2, num(V2) ),
        !,
        V is V1 * V2.
eval( op(mod,T1,T2), num(V) ) :-
        eval( T1, num(V1) ),
        eval( T2, num(V2) ),
        !,
        V is V1 mod V2.
eval( op('<',T1,T2), bool(V) ) :-
        eval( T1, num(V1) ),
        eval( T2, num(V2) ),
        !,
        apply( '<', V1, V2, V ).
eval( op('>',T1,T2), V ) :- !,
        eval( op('<',T2,T1), V ).
eval( op('=<',T1,T2), bool(V) ) :-
        eval( T1, num(V1) ),
        eval( T2, num(V2) ),
        !,
        apply( '=<', V1, V2, V ).
eval( op('>=',T1,T2), V ) :- !,
        eval( op('=<',T2,T1), V ).
eval( op('<>',T1,T2), bool(V) ) :- 
        eval( T1, V1 ),
        eval( T2, V2 ),
        !,
        apply( '<>', V1, V2, V ).
eval( op(not,T), bool(V) ) :-
        eval( T, bool(V1) ),
        !,
        apply( not, V1, V ).
eval( op(and,T1,T2), bool(V) ) :-
        eval( T1, bool(V1) ),
        eval( T2, bool(V2) ),
        !,
        apply( and, V1, V2, V ).
eval( op(or,T1,T2), bool(V) ) :-
        eval( T1, bool(V1) ),
        eval( T2, bool(V2) ),
        !,
        apply( or, V1, V2, V ).
eval( op('=',T1,T2), error ) :-
        var(T1),
        var(T2), !.
eval( op('=',T1,T2), bool(true) ) :- 
        var(T1),
        nonvar(T2),
        eval( T2, V2 ),
        V2 \== error,
        !,
        T1 = V2.
eval( op('=',T1,T2), bool(true) ) :-
        var(T2),
        nonvar(T1),
        eval( T1, V1 ),
        V1 \== error,
        !,
        T2 = V1.
eval( op('=',T1,T2), bool(V) ) :-
        nonvar(T2),
        nonvar(T1),
        eval( T1, V1 ),
        V1 \== error,
        eval( T2, V2 ),
        V2 \== error,
        !,
        apply( '=', V1, V2, V ).
eval( op(O,T1,T2), op(O,V1,V2) ) :-  % not builtin binary op
        eval( T1, V1 ),
        V1 \== error,
        eval( T2, V2 ),
        V2 \== error, !.
eval( op(O,T), op(O,V) ) :-          % not builtin unary op
        eval( T, V ),
        V \== error, !.
eval( _, error ).             % everything else is an error.


evaluable( '=', 2  ).
evaluable( '=<', 2 ).
evaluable( '>=', 2 ).
evaluable( '<>', 2 ).
evaluable( '<', 2 ).
evaluable( '>', 2 ).
evaluable( '*', 2 ).
evaluable( '+', 2 ).
evaluable( '-', 2 ).
evaluable( '-', 1 ).
evaluable( mod, 2 ).
evaluable( not, 1 ).
evaluable( and, 2 ).
evaluable( or,  2 ).

%
% For booleans only
%
apply( not, true,  false ) :- !.
apply( not, false, true )  :- !.

apply( and, true,  true,  true )  :- !.
apply( and, _,     _,     false ) :- !.
apply( or,  false, false, false ) :- !.
apply( or,  _,     _,     true )  :- !.
%
% For numbers only
%
apply( '<', V1, V2, true )  :- V1 < V2, !.
apply( '<', V1, V2, false ) :- V1 >= V2, !.
apply( '=<',V1, V2, true )  :- V1 =< V2, !.
apply( '=<',V1, V2, false ) :- V1 > V2, !.

%
% For numbers and symbols
%
apply( '=', V1, V2, B )  :-  !,
        valueof(V1,S1),
        valueof(V2,S2),
        (S1 = S2 -> B = true; B = false).
apply( '<>', V1, V2, B )  :-  !,
        valueof(V1,S1),
        valueof(V2,S2),
        (S1 \== S2 -> B = true; B = false).


valueof( num(T),   T) :- !.
valueof( const(T), T) :- !.
valueof( lid(T),   T) :- !.
valueof( uid(T),   T).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%              A G E N T / A C T I O N    S I M P L I F I E R
%
%                 Author: Mantis H.M. Cheng (May/30/1994)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% simplify( +Term, -Value )
%	If Term cannot be simplified, then Value is error. The simplification
%	of an unbound variable is not an error, while evaluation does 
%	produce an error.
%
% Notes: - It NEVER fails!
%
simplify( X,         X      ) :- var(X), !.
simplify( error,     error  ) :- !.
simplify( [],        []     ) :- !.
simplify( [T|Ts],    [V|Vs] ) :-
        simplify( T, V ),
        V \== error, 
        simplify( Ts, Vs ),
	Vs \== error,
	!.
simplify( [_|_],    error ) :-
        % simplify( T, error ),
        !.
simplify( form(T),   form(T) ) :- !.
simplify( bool(T),   bool(T) ) :- !.
simplify( num(T),    num(T) ) :- !.
simplify( lid(T),    lid(T) ) :- !.
simplify( uid(T),    uid(T) ) :- !.
simplify( set(T),    set(T1)) :- !,
	simplify( T, T1 ).
simplify( 'STOP',    'STOP'  )  :- !.
simplify( 'SKIP',    'SKIP'  )  :- !.
simplify( const(T),  const(T) ) :- !.
simplify( func(Id,N,Ts), func(Id,N,Vs) ) :-
        simplify( Ts, Vs ),
        Vs \== error,
        !.
simplify( op('?',C,T), op('?',C,V) ) :- !,
        simplify( T, V ).
simplify( op('!',C,T), op('!',C,V) ) :- !,
        simplify( T, V ).
simplify( op('$',C,T), op('$',C,V) ) :- !,
        simplify( T, V ).
simplify( op(':',C,T), op(':',C,V) ) :- !,
        simplify( T, V ).
simplify( op('&',S,T), op('&',S1,T1) ) :- !,
        simplify( S, S1 ),
	simplify( T, T1 ).
simplify( C, C ) :- ground_label( C ), !.
simplify( op(O,L,R), op(O,L1,R) ) :-
	member( O, ['#','^','\','/'] ), !,
        simplify( L, L1 ).
simplify( op('@',R), op('@',R1) ) :- !,
        simplify( R, R1 ).
simplify( op('.',L,R), op('.',L,R1) ) :- !,
        simplify( R, R1 ).
simplify( ifthen(L,R), ifthen(L1,R1) ) :- !,
        simplify( L, L1 ),
        simplify( R, R1 ).
simplify( op(O,L,R), op(O,L1,R1) ) :-
	member( O, ['->',';','|','or','||','|||','|>'] ), !,
        simplify( L, L1 ),
        simplify( R, R1 ).
simplify( op(O,T1,T2), op(O,V1,V2) ) :-  % not builtin binary op
        \+ evaluable(O,2), 
        simplify( T1, V1 ),
        V1 \== error,
        simplify( T2, V2 ),
        V2 \== error, !.
simplify( op(O,T), op(O,V) ) :-          % not builtin unary op
        \+ evaluable(O,1), 
        simplify( T, V ),
        V \== error, !.
simplify( op(O,T), V ) :-
	evaluable(O,1),
	!,
	eval(op(O,T), V).
simplify( op(O,T1,T2), V ) :-
	evaluable(O,2),
	!,
	eval( op(O,T1,T2), V).
simplify( _, error ).             % everything else is an error.


%% ground_term( T ) holds if T contains no variables.
%
ground_term( X        ) :- var(X), !, fail.
ground_term( X        ) :- keyword( X ), !.
ground_term( uid(_)   ) :- !.
ground_term( lid(_)   ) :- !.
ground_term( const(_) ) :- !.
ground_term( num(_)   ) :- !.
ground_term( form(_)  ) :- !.
ground_term( bool(_)  ) :- !.
ground_term( set(L)   ) :- !, ground_term( L ).
ground_term( [A|As]   ) :- !, ground_term( A ), ground_term( As ).
ground_term( []       ) :- !.
ground_term( ifthen(B,E) ) :- !, ground_term( B ), ground_term( E ).
ground_term( func(_,_,Args) ) :- !, ground_term( Args ).
ground_term( op(_,L,R) ) :- !, ground_term( L ), ground_term( R ).
ground_term( op(_,L) ) :- ground_term( L ).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%                     P R E T T Y      P R I N T E R
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

var_names([
    '_x','_y','_z','_x1','_y1','_z1','_x2','_y2','_z2','_x3','_y3','_z3',
    '_n','_m','_p','_q','_n1','_m1','_p1','_q1','_n2','_m2','_p2','_q2',
    '_r','_s','_t','_r1','_s1','_t1','_r2','_s2','_t2','_r3','_s3','_t3',
    '_a','_b','_c','_a1','_b1','_c1','_a2','_b2','_c2','_a3','_b3','_c3']).


% print an expression in its original syntax based on the operator
% declarations but do not instantiate the unbound variables
%
print_expression( X ) :-
        var_names( L ),
        \+ \+ print_term( 1200, X, L, _ ), !.


print_list( [H|Hs], V1, V3 ) :-
	var(Hs),
	!,
        print_term( 1200, H, V1, V2 ),
	put(124),    % 124 == ~|
	print_term( 1200, Hs, V2, V3 ).
print_list( [H1,H2|Hs], V1, V3 ) :- !,
        print_term( 1200, H1, V1, V2 ),
        put( 44 ),  % 44 == ~,
        put( 32 ),  % 32 == ' '
        print_list( [H2|Hs], V2, V3 ).
print_list( [H], V1, V2 ) :- !,
        print_term( 1200, H, V1, V2 ).
print_list( [H|Hs], V1, V3 ) :- 
        Hs \== [], !,
        print_term( 1200, H, V1, V2 ),
        put( 124 ),  % 124 == ~|
        print_term( 1200, Hs, V2, V3 ).


print_term( _, X, [V|Vs], Vs ) :-
        var(X), !,
        X = V,
        write( X ).
print_term( _, X, [], [] ) :-  % runs out of variable names
        var(X), !,
        write( X ).
print_term( _, [], V, V ) :- !,
        write('[]').
print_term( _, set([]), V, V ) :- !,
        write('{}').
print_term( _, num(A), V, V ) :- !,
        write(A).
print_term( _, var(void), V, V ) :- !,
        write('_').
print_term( _, const(A), V, V ) :- !,
        write(A).
print_term( _, uid(A), V, V ) :- !,
        write(A).
print_term( _, var(A), V, V ) :- !,
        write(A).
print_term( _, lid(A), V, V ) :- !,
        write(A).
print_term( _, bool(A), V, V ) :- !,
        write(A).
print_term( _, form(A), V, V ) :- !,
        write(A).
print_term( _, A, V, V ) :- 
        keyword(A),
        !,
        write(A).
print_term( _, A, V, V ) :-
        atomic(A), !,
        write(A).
print_term( _, ifthen(B,E), V1, V3  ) :- !,
        write( '(if ' ),
        print_term( 999, B, V1, V2  ),
        write( ' then ' ),
        print_term( 999, E, V2, V3  ),
	write( ')' ).
print_term( H, op(F,A), V1, V2  ) :-
        op_decl( F, fx, L ), !,
        L1 is L-1,
        print_left_paren( H, L1 ),
        write( F ),
        print_space( F ), 
        print_term( L1, A, V1, V2  ),
        print_right_paren( H, L1 ).
print_term( H, op(F,A), V1, V2  ) :-
        op_decl( F, fy, L ), !,
        print_left_paren( H, L ),
        write( F ),
        print_space( F ), 
        print_term( L, A, V1, V2  ),
        print_right_paren( H, L ).
print_term( H, op(F,A), V1, V2  ) :-
        op_decl( F, xf, L ), !,
        L1 is L-1,
        print_left_paren( H, L1 ),
        print_term( L1, A, V1, V2  ),
        print_space( F ), 
        write( F ),
        print_right_paren( H, L1 ).
print_term( H, op(F,A), V1, V2  ) :-
        op_decl( F, yf, L ), !,
        print_left_paren( H, L ),
        print_term( L, A, V1, V2  ),
        print_space( F ), 
        write( F ),
        print_right_paren( H, L ).
print_term( H, op(F,A1,A2), V1, V3  ) :-
        op_decl( F, xfx, L ), !,
        L1 is L-1,
        print_left_paren( H, L ),
        print_term( L1, A1, V1, V2  ),
        print_space( F ), 
        write( F ),
        print_space( F ), 
        print_term( L1, A2, V2, V3  ),
        print_right_paren( H, L ).
print_term( H, op(F,A1,A2), V1, V3  ) :-
        op_decl( F, xfy, L ), !,
        L1 is L-1,
        print_left_paren( H, L ),
        print_term( L1, A1, V1, V2  ),
        print_space( F ), 
        write( F ),
        print_space( F ), 
        print_term( L, A2, V2, V3  ),
        print_right_paren( H, L ).
print_term( H, op(F,A1,A2), V1, V3  ) :-
        op_decl( F, yfx, L ), !,
        L1 is L-1,
        print_left_paren( H, L ),
        print_term( L, A1, V1, V2 ),
        print_space( F ), 
        write( F ),
        print_space( F ), 
        print_term( L1, A2, V2, V3 ),
        print_right_paren( H, L ).
print_term( H, box(A), V1, V2 ) :- !,
	write( '[[ ' ),
        print_term( H, A, V1, V2 ),
	write( ' ]]' ).
print_term( H, diamond(A), V1, V2 ) :- !,
	write( '<< ' ),
        print_term( H, A, V1, V2 ),
	write( ' >>' ).
print_term( _, set([H|Hs]), V1, V2 ) :- !,
        put( 123 ),  % 123 == ~{
        print_list( [H|Hs], V1, V2 ),
        put( 125 ).  % 125 == ~{
print_term( _, [H|Hs], V1, V2 ) :- !,
        put( 91 ),  % 91 == ~[
        print_list( [H|Hs], V1, V2 ),
        put( 93 ).  % 93 == ~]
print_term( H, func(F,_,Ts), V1, V3 ) :-
        print_term( H, F, V1, V2 ),
        put( 40 ),  % 40 == ~(
        print_tuple(Ts, V2, V3),
        put( 41 ).  % 41 == ~)


print_left_paren( H, L ) :-
        L > H, !,
        put( 40 ).  % 40 == ~(
print_left_paren( _, _ ).


print_right_paren( H, L ) :-
        L > H, !,
        put( 41 ).  % 41 == ~)
print_right_paren( _, _ ).


print_tuple( [], V, V ) :- !.
print_tuple( [E], V1, V2 ) :-
        print_term( 1200, E, V1, V2 ).
print_tuple( [E1,E2|Es], V1, V3 ) :-
        print_term( 1200, E1, V1, V2 ),
        put( 44 ),  % 44 == ~,
        print_tuple( [E2|Es], V2, V3 ).



print_space( ':' ) :- !.   % no spaces
print_space( '?' ) :- !.   % no spaces
print_space( '!' ) :- !.   % no spaces
print_space( '$' ) :- !.   % no spaces
print_space( '#' ) :- !.   % no spaces
print_space( '^' ) :- !.   % no spaces
print_space( '\' ) :- !.   % no spaces
print_space( '/' ) :- !.   % no spaces
print_space( '=' ) :- !.   % no spaces
print_space( '->' ) :- !.  % no spaces
print_space( '.' ) :- !.  % no spaces
print_space( _ ) :-
%        \+ operator( _, _, O ),   % it is a non-id operator
%        !,
        put( 32 ).


%
% print an expression in its original syntax based on the operator
% declarations
%
echo_expression( X ) :-
        var_names( L ),
        \+ \+ echo_term( 1200, X, L, _ ), !.

echo_list( [H|Hs], V1, V3 ) :-
        var(Hs),
        !,
        echo_term( 1200, H, V1, V2 ),
        put(124),    % 124 == ~|
        echo_term( 1200, Hs, V2, V3 ).
echo_list( [H1,H2|Hs], V1, V3 ) :- !,
        echo_term( 1200, H1, V1, V2 ),
        put( 44 ),  % 44 == ~,
        put( 32 ),  % 32 == ' '
        echo_list( [H2|Hs], V2, V3 ).
echo_list( [H], V1, V2 ) :- !,
        echo_term( 1200, H, V1, V2 ).
echo_list( [H|Hs], V1, V3 ) :-
        Hs \== [], !,
        echo_term( 1200, H, V1, V2 ),
        put( 124 ),  % 124 == ~|
        echo_term( 1200, Hs, V2, V3 ).


echo_term( _, X, [V|Vs], Vs ) :-
        var(X), !,
        X = V,
        write( X ).
echo_term( _, X, [], [] ) :-  % runs out of variable names
        var(X), !,
        write( X ).
echo_term( _, [], V, V ) :- !,
        write('[]').
echo_term( _, set([]), V, V ) :- !,
        write('{}').
echo_term( _, var(void), V, V ) :- !,
        write('_').
echo_term( _, num(A), V, V ) :- !,
        write(A).
echo_term( _, const(A), V, V ) :- !,
        write(A).
echo_term( _, uid(A), V, V ) :- !,
        write(A).
echo_term( _, lid(A), V, V ) :- !,
        write(A).
echo_term( _, bool(A), V, V ) :- !,
        write(A).
echo_term( _, form(A), V, V ) :- !,
        write(A).
echo_term( _, A, V, V ) :- 
        keyword(A),
        !,
        write(A).
echo_term( _, A, V, V ) :-
        atomic(A), !,
        write(A).
echo_term( H, op(F,A), V1, V2  ) :-
        op_decl( F, fx, L ), !,
        L1 is L-1,
        print_left_paren( H, L1 ),
        write( F ),
        print_space( F ), 
        echo_term( L1, A, V1, V2  ),
        print_right_paren( H, L1 ).
echo_term( H, op(F,A), V1, V2  ) :-
        op_decl( F, fy, L ), !,
        print_left_paren( H, L ),
        write( F ),
        print_space( F ), 
        echo_term( L, A, V1, V2  ),
        print_right_paren( H, L ).
echo_term( H, op(F,A), V1, V2  ) :-
        op_decl( F, xf, L ), !,
        L1 is L-1,
        print_left_paren( H, L1 ),
        echo_term( L1, A, V1, V2  ),
        print_space( F ), 
        write( F ),
        print_right_paren( H, L1 ).
echo_term( H, op(F,A), V1, V2  ) :-
        op_decl( F, yf, L ), !,
        print_left_paren( H, L ),
        echo_term( L, A, V1, V2  ),
        print_space( F ), 
        write( F ),
        print_right_paren( H, L ).
echo_term( H, op(F,A1,A2), V1, V3  ) :-
        op_decl( F, xfx, L ), !,
        L1 is L-1,
        print_left_paren( H, L ),
        echo_term( L1, A1, V1, V2  ),
        print_space( F ), 
        write( F ),
        print_space( F ), 
        echo_term( L1, A2, V2, V3  ),
        print_right_paren( H, L ).
echo_term( H, op(F,A1,A2), V1, V3  ) :-
        op_decl( F, xfy, L ), !,
        L1 is L-1,
        print_left_paren( H, L ),
        echo_term( L1, A1, V1, V2  ),
        print_space( F ), 
        write( F ),
        print_space( F ), 
        echo_term( L, A2, V2, V3  ),
        print_right_paren( H, L ).
echo_term( H, op(F,A1,A2), V1, V3  ) :-
        op_decl( F, yfx, L ), !,
        L1 is L-1,
        print_left_paren( H, L ),
        echo_term( L, A1, V1, V2 ),
        print_space( F ), 
        write( F ),
        print_space( F ), 
        echo_term( L1, A2, V2, V3 ),
        print_right_paren( H, L ).
echo_term( H, box(A), V1, V2 ) :- !,
	write( '[[ ' ),
        echo_term( H, A, V1, V2 ),
	write( ' ]]' ).
echo_term( H, diamond(A), V1, V2 ) :- !,
	write( '<< ' ),
        echo_term( H, A, V1, V2 ),
	write( ' >>' ).
echo_term( _, set([H|Hs]), V1, V2 ) :- !,
        put( 123 ),  % 123 == ~{
        echo_list( [H|Hs], V1, V2 ),
        put( 125 ).  % 125 == ~}
echo_term( _, [H|Hs], V1, V2 ) :- !,
        put( 91 ),  % 91 == ~[
        echo_list( [H|Hs], V1, V2 ),
        put( 93 ).  % 93 == ~]
echo_term( H, func(F,_,Ts), V1, V3 ) :-
        echo_term( H, F, V1, V2 ),
        put( 40 ),  % 40 == ~(
        echo_tuple(Ts, V2, V3),
        put( 41 ).  % 41 == ~)


echo_tuple( [], V, V ) :- !.
echo_tuple( [E], V1, V2 ) :-
        echo_term( 1200, E, V1, V2 ).
echo_tuple( [E1,E2|Es], V1, V3 ) :-
        echo_term( 1200, E1, V1, V2 ),
        put( 44 ),  % 44 == ~,
        echo_tuple( [E2|Es], V2, V3 ).

